/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiReferenceBase<T extends PsiElement>
implements PsiReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiReferenceBase");
    protected final T myElement;
    private TextRange myRangeInElement;
    protected boolean mySoft;

    public PsiReferenceBase(T element, TextRange rangeInElement, boolean soft) {
        this.myElement = element;
        this.myRangeInElement = rangeInElement;
        this.mySoft = soft;
    }

    public PsiReferenceBase(T element, TextRange rangeInElement) {
        this(element);
        this.myRangeInElement = rangeInElement;
    }

    public PsiReferenceBase(T element, boolean soft) {
        this.myElement = element;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase", "<init>"));
        }
        this.myElement = element;
        this.mySoft = false;
    }

    public void setRangeInElement(TextRange rangeInElement) {
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public String getValue() {
        String string;
        String text2 = this.myElement.getText();
        TextRange range = this.getRangeInElement();
        try {
            string = range.substring(text2);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Wrong range in reference " + this + ": " + range + ". Reference text: '" + text2 + "'", e);
            String string2 = text2;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceBase", "getValue"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceBase", "getValue"));
        }
        return string;
    }

    public T getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        if (this.myRangeInElement == null) {
            this.myRangeInElement = this.calculateDefaultRangeInElement();
        }
        return this.myRangeInElement;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return this.getManipulator().getRangeInElement(this.myElement);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getManipulator().handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase", "bindToElement"));
        }
        throw new IncorrectOperationException("Rebind cannot be performed for " + this.getClass());
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, PsiElement resolveTo) {
        return new Immediate<T>(element, true, resolveTo);
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, TextRange rangeInElement, PsiElement resolveTo) {
        return new Immediate<T>(element, rangeInElement, resolveTo);
    }

    private ElementManipulator<T> getManipulator() {
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(this.myElement);
        if (manipulator == null) {
            LOG.error("Cannot find manipulator for " + this.myElement + " in " + this + " class " + this.getClass());
        }
        return manipulator;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    public String toString() {
        return this.myElement + ":" + this.myRangeInElement;
    }

    public static class Immediate<T extends PsiElement>
    extends PsiReferenceBase<T> {
        private final PsiElement myResolveTo;

        public Immediate(T element, TextRange rangeInElement, boolean soft, PsiElement resolveTo) {
            super(element, rangeInElement, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, TextRange rangeInElement, PsiElement resolveTo) {
            super(element, rangeInElement);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, boolean soft, PsiElement resolveTo) {
            super(element, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(@NotNull T element, PsiElement resolveTo) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase$Immediate", "<init>"));
            }
            super(element);
            this.myResolveTo = resolveTo;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            return this.myResolveTo;
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceBase$Immediate", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
    }

    public static abstract class Poly<T extends PsiElement>
    extends PsiReferenceBase<T>
    implements PsiPolyVariantReference {
        public Poly(T psiElement) {
            super(psiElement);
        }

        public Poly(T element, boolean soft) {
            super(element, soft);
        }

        public Poly(T element, TextRange rangeInElement, boolean soft) {
            super(element, rangeInElement, soft);
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = this.multiResolve(false)) {
                if (!element.getManager().areElementsEquivalent(result2.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }
    }
}

