/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();
    private boolean myInitialized;
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register(manager.getProject(), this);
        LowMemoryWatcher.register(() -> this.processQueue(), this);
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.remove(NULL);
    }

    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = this.myVFileToViewProviderMap;
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getVFileToViewProviderMap"));
        }
        return concurrentMap;
    }

    private void updateAllViewProviders() {
        this.handleFileTypesChange(new FileTypesChanged(){

            @Override
            protected void updateMaps() {
                for (FileViewProvider provider : FileManagerImpl.this.myVFileToViewProviderMap.values()) {
                    if (!provider.getVirtualFile().isValid()) continue;
                    FileManagerImpl.clearPsiCaches(provider);
                }
                FileManagerImpl.this.removeInvalidFilesAndDirs(false);
                FileManagerImpl.this.checkLanguageChange();
            }
        });
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/file/impl/FileManagerImpl", "clearPsiCaches"));
        }
        if (provider instanceof SingleRootFileViewProvider) {
            for (PsiFile root2 : ((SingleRootFileViewProvider)provider).getCachedPsiFiles()) {
                if (!(root2 instanceof PsiFileImpl)) continue;
                ((PsiFileImpl)root2).clearCaches();
            }
        } else {
            for (Language language : provider.getLanguages()) {
                PsiFile psi = provider.getPsi(language);
                if (!(psi instanceof PsiFileImpl)) continue;
                ((PsiFileImpl)psi).clearCaches();
            }
        }
    }

    private void checkLanguageChange() {
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        THashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), vFile);
            if (language == null || language == ((FileViewProvider)fileToPsiFileMap.get(vFile)).getBaseLanguage()) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "forceReload"));
        }
        LanguageSubstitutors.cancelReparsing(vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            FileManagerImpl.setUpPropertyChangedForUnloadedPsi(event, vFile);
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent(parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    private static void setUpPropertyChangedForUnloadedPsi(@NotNull PsiTreeChangeEventImpl event, @NotNull VirtualFile vFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/FileManagerImpl", "setUpPropertyChangedForUnloadedPsi"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "setUpPropertyChangedForUnloadedPsi"));
        }
        event.setPropertyName("propUnloadedPsi");
        event.setOldValue(vFile);
        event.setNewValue(vFile);
    }

    @Override
    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.startPsiModification("clearViewProviders");
        try {
            for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
                this.markInvalidated(provider);
            }
            this.myVFileToViewProviderMap.clear();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(() -> this.clearViewProviders());
        this.myVFileToPsiDirMap.clear();
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        assert (!file.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(file, true);
        if (file instanceof LightVirtualFile) {
            FileViewProvider fileViewProvider = file.putUserDataIfAbsent(this.myPsiHardRefKey, viewProvider);
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, file, viewProvider);
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findCachedViewProvider"));
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        }
        if (viewProvider == null) {
            viewProvider = file.getUserData(this.myPsiHardRefKey);
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getFromInjected(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getFromInjected"));
        }
        if (file instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)((Object)file)).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myManager.getProject()).getCachedPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile2, @Nullable FileViewProvider fileViewProvider) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "setViewProvider"));
        }
        FileViewProvider prev = this.findCachedViewProvider(virtualFile2);
        if (prev == fileViewProvider) {
            return;
        }
        if (prev != null) {
            DebugUtil.startPsiModification(null);
            try {
                this.markInvalidated(prev);
                DebugUtil.onInvalidated(prev);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        }
        if (!(virtualFile2 instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile2);
            } else if (virtualFile2 instanceof LightVirtualFile) {
                virtualFile2.putUserData(this.myPsiHardRefKey, fileViewProvider);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile2, fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        FileType fileType = file.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), file);
        FileViewProviderFactory factory2 = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory2 == null ? null : factory2.createFileViewProvider(file, language, this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    public void markInitialized() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.updateAllViewProviders();
            }
        });
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void handleFileTypesChange(@NotNull FileTypesChanged runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/file/impl/FileManagerImpl", "handleFileTypesChange"));
        }
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        finally {
            this.myProcessingFileTypesChange = false;
        }
    }

    void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized: " + this.myManager.getProject());
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent2 = vFile.getParent();
            if (parent2 == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent2));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findFile"));
        }
        if (vFile.isDirectory()) {
            return null;
        }
        Project project = this.myManager.getProject();
        if (project.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), "Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectory"));
        }
        LOG.assertTrue(this.myInitialized, "Access to psi files should be performed only after startup activity");
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "findDirectoryImpl"));
        }
        PsiDirectory psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (Registry.is("ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 != null) {
            this.findDirectoryImpl(parent2);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, vFile, psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedDirectory"));
        }
        return (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/file/impl/FileManagerImpl", "markInvalidated"));
        }
        if (viewProvider instanceof SingleRootFileViewProvider) {
            ((SingleRootFileViewProvider)viewProvider).markInvalidated();
        }
        VirtualFile virtualFile2 = viewProvider.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile2);
        if (document != null) {
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myManager.getProject())).associatePsi(document, null);
        }
        virtualFile2.putUserData(this.myPsiHardRefKey, null);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getCachedPsiFileInner"));
        }
        FileViewProvider fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        if (fileViewProvider == null) {
            fileViewProvider = file.getUserData(this.myPsiHardRefKey);
        }
        return fileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            if (!(provider instanceof SingleRootFileViewProvider)) continue;
            ContainerUtil.addIfNotNull(files2, ((SingleRootFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/FileManagerImpl", "getAllCachedFiles"));
        }
        return arrayList;
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        THashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new THashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator2 = fileToPsiDirMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator2.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll(fileToPsiDirMap);
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        THashMap<VirtualFile, FileViewProvider> originalFileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator3 = fileToPsiFileMap.keySet().iterator();
        while (iterator3.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator3.next();
            if (!vFile.isValid()) {
                iterator3.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator3.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator3.remove();
                continue;
            }
            if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                iterator3.remove();
                continue;
            }
            FileManagerImpl.clearPsiCaches(view);
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view1", "com/intellij/psi/impl/file/impl/FileManagerImpl", "areViewProvidersEquivalent"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view2", "com/intellij/psi/impl/file/impl/FileManagerImpl", "areViewProvidersEquivalent"));
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null) {
            return psi2 == null;
        }
        return psi1.getClass() == psi2.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFileToPsiFileMap", "com/intellij/psi/impl/file/impl/FileManagerImpl", "markInvalidations"));
        }
        DebugUtil.startPsiModification(null);
        try {
            for (Map.Entry<VirtualFile, FileViewProvider> entry : originalFileToPsiFileMap.entrySet()) {
                FileViewProvider viewProvider = entry.getValue();
                if (this.myVFileToViewProviderMap.get(entry.getKey()) == viewProvider) continue;
                this.markInvalidated(viewProvider);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        this.reloadFromDisk(file, false);
    }

    void reloadFromDisk(@NotNull PsiFile file, boolean ignoreDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        if (file instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null && !ignoreDocument) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            FileViewProvider latestProvider = this.createFileViewProvider(vFile, false);
            PsiFile psi = latestProvider.getPsi(latestProvider.getBaseLanguage());
            if (psi instanceof PsiLargeFile || psi instanceof PsiBinaryFile) {
                this.forceReload(vFile);
                return;
            }
            FileViewProvider viewProvider = file.getViewProvider();
            if (viewProvider instanceof SingleRootFileViewProvider) {
                ((SingleRootFileViewProvider)viewProvider).onContentReload();
            } else {
                LOG.error("Invalid view provider: " + viewProvider + " of " + viewProvider.getClass());
            }
        }
    }

    private abstract class FileTypesChanged
    implements Runnable {
        private FileTypesChanged() {
        }

        protected abstract void updateMaps();

        @Override
        public void run() {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.beforePropertyChange(event);
            this.updateMaps();
            FileManagerImpl.this.myManager.propertyChanged(event);
        }
    }
}

