/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportsUtil {
    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement expression2) {
                PsiElement resolveScope;
                if ((refExpr == null || refExpr != expression2) && (resolveScope = expression2.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression2);
                }
                super.visitElement(expression2);
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        expressionToExpand.sort((o1, o2) -> o2.getTextOffset() - o1.getTextOffset());
        for (PsiJavaCodeReferenceElement expression2 : expressionToExpand) {
            ImportsUtil.expand(expression2, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/util/ImportsUtil", "expand"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(refExpr.getProject());
        PsiReferenceExpression referenceExpression = elementFactory.createReferenceExpression(staticImport.resolveTargetClass());
        if (refExpr instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)refExpr).setQualifierExpression(referenceExpression);
        } else {
            refExpr.replace(elementFactory.createReferenceFromText(referenceExpression.getText() + "." + refExpr.getText(), refExpr));
        }
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member, boolean acceptOnDemand) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                PsiClass containingClass = member.getContainingClass();
                String referenceName = stmt.getReferenceName();
                if (containingClass == null || stmt.resolveTargetClass() != containingClass) continue;
                if (!stmt.isOnDemand() && Comparing.strEqual(referenceName, member.getName())) {
                    if (member instanceof PsiMethod) {
                        return containingClass.findMethodsByName(referenceName, false).length > 0;
                    }
                    return true;
                }
                if (!acceptOnDemand || !stmt.isOnDemand()) continue;
                return true;
            }
        }
        return false;
    }
}

