/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.descriptorUtils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"isCoroutineLambda", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "nameIfStandardType", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNameIfStandardType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "getJetTypeFqName", "", "printTypeArguments", "hasPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "shouldBeExported", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "js.frontend"})
public final class DescriptorUtilsKt {
    @Nullable
    public static final Name getNameIfStandardType(@NotNull KotlinType $receiver) {
        ClassifierDescriptor classifierDescriptor;
        DeclarationDescriptor p1;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor2 != null && (classifierDescriptor2 = KotlinBuiltIns.isBuiltIn(p1 = (DeclarationDescriptor)(classifierDescriptor = classifierDescriptor2)) ? classifierDescriptor : null) != null ? classifierDescriptor2.getName() : null;
    }

    @NotNull
    public static final String getJetTypeFqName(@NotNull KotlinType $receiver, boolean printTypeArguments) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ClassifierDescriptor declaration = classifierDescriptor;
        if (declaration instanceof TypeParameterDescriptor) {
            String string3 = StringUtil.join((Collection)((TypeParameterDescriptor)declaration).getUpperBounds(), (Function)new Function<T, String>(printTypeArguments){
                final /* synthetic */ boolean $printTypeArguments;

                @NotNull
                public final String fun(KotlinType type2) {
                    return DescriptorUtilsKt.getJetTypeFqName(type2, this.$printTypeArguments);
                }
                {
                    this.$printTypeArguments = bl;
                }
            }, "&");
            Intrinsics.checkExpressionValueIsNotNull(string3, "StringUtil.join(declarat\u2026intTypeArguments) }, \"&\")");
            return string3;
        }
        List<TypeProjection> typeArguments2 = $receiver.getArguments();
        if (printTypeArguments && !typeArguments2.isEmpty()) {
            String joinedTypeArguments2 = StringUtil.join((Collection)typeArguments2, (Function)getJetTypeFqName.typeArgumentsAsString.joinedTypeArguments.1.INSTANCE, ", ");
            string = '<' + joinedTypeArguments2 + '>';
        } else {
            string = "";
        }
        String typeArgumentsAsString2 = string;
        return DescriptorUtils.getFqName(declaration).asString() + typeArgumentsAsString2;
    }

    public static final boolean hasPrimaryConstructor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getUnsubstitutedPrimaryConstructor() != null;
    }

    public static final boolean isCoroutineLambda(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)$receiver).isSuspend();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean shouldBeExported(@NotNull DeclarationDescriptor $receiver, @NotNull JsConfig config) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(config, "config");
        if (!($receiver instanceof DeclarationDescriptorWithVisibility)) return true;
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)$receiver;
        Visibility visibility = ((DeclarationDescriptorWithVisibility)$receiver).getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "visibility");
        if (DescriptorUtilsKt.shouldBeExported(EffectiveVisibilityKt.effectiveVisibility(declarationDescriptorWithVisibility, visibility, true), config)) return true;
        if (AnnotationsUtils.getJsNameAnnotation($receiver) == null) return false;
        return true;
    }

    private static final boolean shouldBeExported(@NotNull EffectiveVisibility $receiver, JsConfig config) {
        if ($receiver.getPublicApi()) {
            return true;
        }
        if (config.getConfiguration().getBoolean(JSConfigurationKeys.FRIEND_PATHS_DISABLED)) {
            return false;
        }
        return Intrinsics.areEqual($receiver.toVisibility(), Visibilities.INTERNAL);
    }
}

