/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a,\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0005\"\b\b\u0000\u0010\u000f*\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u00150\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00160\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0016\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u0016\u001a\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00162\n\u0010 \u001a\u00060!j\u0002`\"H\u0002\u001a\u0010\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020%\u001a\u0016\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0\u0001*\u00020\b\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0013\u001a\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0013\u00a8\u0006+"}, d2={"collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "collectDefinedNamesInAllScopes", "collectFunctionReferencesInside", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectNamedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "collectNamedFunctionsAndWrappers", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectUsedNames", "extractFunction", "expression", "extractImportTag", "extractImportTagImpl", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getImportTag", "jsVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "collectLocalVariables", "js.translator"})
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Iterable iterable = $receiver$iv = (Iterable)CollectUtilsKt.collectReferencedNames(scope);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JsName it = (JsName)element$iv$iv;
            if (!(MetadataProperties.getStaticRef(it) instanceof JsFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final Set<JsName> collectReferencedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null) {
                    Collection collection = this.$references;
                    collection.add(name);
                }
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    this.$references.add(name);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                CollectionsKt.addAll(collection, iterable);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                Collection collection = this.$names;
                JsName jsName = x.getName();
                collection.add(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression expression2 = x.getExpression();
                if (expression2 instanceof JsFunction && (name = ((JsFunction)expression2).getName()) != null) {
                    Collection collection = this.$names;
                    collection.add(name);
                }
                super.visitExpressionStatement(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return names2;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNamesInAllScopes(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visit(x);
                Collection collection = this.$names;
                JsName jsName = x.getName();
                collection.add(jsName);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $receiver$iv$iv;
                Iterable<E> iterable;
                Object object;
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitFunction(x);
                JsName jsName = x.getName();
                if (jsName != null) {
                    object = jsName;
                    JsName it = object;
                    iterable = this.$names;
                    iterable.add(it);
                }
                object = this.$names;
                Iterable $receiver$iv = x.getParameters();
                iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    JsName jsName2 = it.getName();
                    collection.add(jsName2);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                CollectionsKt.addAll(object, iterable2);
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "body");
        Iterable iterable = $receiver.getParameters();
        Set<JsName> set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.minus(set2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
        Iterable iterable = $receiver.getParameters();
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock);
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.plus(set, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope) {
        void $receiver$iv$iv;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map4.put(k2, jsFunction);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope) {
        void $receiver$iv$iv;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map4.put(k2, jsExpression);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            Map map2 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock, "fragment.declarationBlock");
            Map<JsName, JsFunction> map3 = CollectUtilsKt.collectNamedFunctions(jsGlobalBlock);
            map2.putAll(map3);
            map2 = result2;
            JsGlobalBlock jsGlobalBlock2 = jsProgramFragment.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock2, "fragment.initializerBlock");
            map3 = CollectUtilsKt.collectNamedFunctions(jsGlobalBlock2);
            map2.putAll(map3);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, FunctionWithWrapper> collectNamedFunctionsAndWrappers(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            FunctionWithWrapper functionWithWrapper;
            Map.Entry it;
            Map map2;
            Object k;
            Object k2;
            Map.Entry it$iv$iv;
            Map map3;
            Map $receiver$iv$iv;
            Map $receiver$iv;
            Map map4 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock, "fragment.declarationBlock");
            Map map5 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(jsGlobalBlock);
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            $receiver$iv = destination$iv$iv;
            map4.putAll($receiver$iv);
            map4 = result2;
            JsGlobalBlock jsGlobalBlock2 = jsProgramFragment.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock2, "fragment.initializerBlock");
            $receiver$iv$iv = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(jsGlobalBlock2);
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
            $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            Map map6 = destination$iv$iv;
            map4.putAll(map6);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map namedFunctions = new LinkedHashMap();
        scope.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map $namedFunctions;

            /*
             * WARNING - void declaration
             */
            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    JsName name;
                    void left;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression jsExpression = pair.component1();
                    JsExpression right = pair.component2();
                    if (left instanceof JsNameRef && (name = ((JsNameRef)left).getName()) != null) {
                        JsExpression jsExpression2 = right;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "right");
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(jsExpression2);
                        if (functionWithWrapper != null) {
                            FunctionWithWrapper functionWithWrapper2;
                            FunctionWithWrapper $function_wrapper = functionWithWrapper2 = functionWithWrapper;
                            JsFunction function2 = $function_wrapper.component1();
                            JsBlock wrapper = $function_wrapper.component2();
                            Map map2 = this.$namedFunctions;
                            JsName jsName = name;
                            Pair<FunctionWithWrapper, JsExpression> pair2 = new Pair<FunctionWithWrapper, JsExpression>(new FunctionWithWrapper(function2, wrapper), right);
                            map2.put(jsName, pair2);
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                JsName name = x.getName();
                if (initializer2 != null && name != null) {
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(initializer2);
                    if (functionWithWrapper != null) {
                        FunctionWithWrapper functionWithWrapper2;
                        FunctionWithWrapper function2 = functionWithWrapper2 = functionWithWrapper;
                        Map map2 = this.$namedFunctions;
                        JsName jsName = name;
                        Pair<FunctionWithWrapper, JsExpression> pair = new Pair<FunctionWithWrapper, JsExpression>(function2, initializer2);
                        map2.put(jsName, pair);
                    }
                }
                super.visit(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsName name = x.getName();
                if (name != null) {
                    Map map2 = this.$namedFunctions;
                    Pair<FunctionWithWrapper, JsFunction> pair = new Pair<FunctionWithWrapper, JsFunction>(new FunctionWithWrapper(x, null), x);
                    map2.put(name, pair);
                }
                super.visitFunction(x);
            }
            {
                this.$namedFunctions = $captured_local_variable$0;
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        HashMap accessors = new HashMap();
        scope.accept(new RecursiveJsVisitor(accessors){
            final /* synthetic */ HashMap $accessors;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull(invocation, "invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2;
                    InlineMetadata it = inlineMetadata2 = inlineMetadata;
                    Map map2 = this.$accessors;
                    String string = it.getTag().getValue();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.tag.value");
                    String string2 = string;
                    FunctionWithWrapper functionWithWrapper = it.getFunction();
                    map2.put(string2, functionWithWrapper);
                }
                super.visitInvocation(invocation);
            }
            {
                this.$accessors = $captured_local_variable$0;
            }
        });
        return accessors;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            Map map2 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock, "fragment.declarationBlock");
            Map<String, FunctionWithWrapper> map3 = CollectUtilsKt.collectAccessors(jsGlobalBlock);
            map2.putAll(map3);
        }
        return result2;
    }

    @Nullable
    public static final FunctionWithWrapper extractFunction(@NotNull JsExpression expression2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            object = new FunctionWithWrapper((JsFunction)expression2, null);
        } else {
            object = InlineMetadata.Companion.decompose(expression2);
            if (object == null || (object = ((InlineMetadata)object).getFunction()) == null) {
                object = InlineMetadata.Companion.tryExtractFunction(expression2);
            }
        }
        return object;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass2, @NotNull JsNode scope) {
        InstanceCollector<JsNode> instanceCollector;
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        InstanceCollector<JsNode> $receiver = instanceCollector = new InstanceCollector<JsNode>(klass2, false);
        $receiver.accept(scope);
        return $receiver.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Map targets = new LinkedHashMap();
        $receiver.accept(new RecursiveJsVisitor(targets){
            @Nullable
            private JsStatement defaultBreakTarget;
            @NotNull
            private Map<JsName, JsStatement> breakTargets;
            @Nullable
            private JsStatement defaultContinueTarget;
            @NotNull
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map $targets;

            @Nullable
            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(@Nullable JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
                this.breakTargets = map2;
            }

            @Nullable
            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(@Nullable JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
                this.continueTargets = map2;
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement inner;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "inner.body");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "inner.body");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement4, "inner.body");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement5, "x.statement");
                    this.withBreakAndContinue(jsName, jsStatement5, null, new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$inner = jsStatement;
                            super(0);
                        }
                    });
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement2, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement2, null, new Function0<Unit>(this, statement2){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsSwitch $statement;

                    public final void invoke() {
                        Iterable $receiver$iv = this.$statement.getCases();
                        for (T element$iv : $receiver$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            this.this$0.accept((JsNode)it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$statement = jsSwitch;
                        super(0);
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop, JsStatement body, JsName label) {
                this.withBreakAndContinue(label, loop, loop, new Function0<Unit>(this, body){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsStatement $body;

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = jsStatement;
                        super(0);
                    }
                });
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultBreakTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.breakTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultContinueTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.continueTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            /*
             * WARNING - void declaration
             */
            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                JsStatement jsStatement;
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Map<JsName, JsStatement> map2 = label != null ? new Pair<JsStatement, JsStatement>(this.breakTargets.get(label), this.continueTargets.get(label)) : new Pair<Object, Object>(null, null);
                JsStatement jsStatement2 = (JsStatement)((Pair)((Object)map2)).component1();
                JsStatement oldContinueTarget = ((Pair)((Object)map2)).component2();
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    map2 = this.breakTargets;
                    jsStatement = breakTargetStatement;
                    map2.put(label, jsStatement);
                    map2 = this.continueTargets;
                    jsStatement = continueTargetStatement;
                    map2.put(label, jsStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    void oldBreakTarget;
                    map2 = this.breakTargets;
                    jsStatement = oldBreakTarget;
                    map2.put(label, jsStatement);
                    map2 = this.continueTargets;
                    jsStatement = oldContinueTarget;
                    map2.put(label, jsStatement);
                }
            }

            static /* bridge */ /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, function0);
            }
            {
                Map map2;
                this.$targets = $captured_local_variable$0;
                collectBreakContinueTargets.1 var2_2 = this;
                var2_2.breakTargets = map2 = (Map)new LinkedHashMap<K, V>();
                var2_2 = this;
                var2_2.continueTargets = map2 = (Map)new LinkedHashMap<K, V>();
            }
        });
        return targets;
    }

    @Nullable
    public static final String getImportTag(@NotNull JsVars jsVars) {
        JsVars.JsVar jsVar;
        Intrinsics.checkParameterIsNotNull(jsVars, "jsVars");
        if (jsVars.getVars().size() == 1 && (jsVar = jsVars.getVars().get(0)).getInitExpression() != null && MetadataProperties.getImported(jsVar.getName())) {
            JsExpression jsExpression = jsVar.getInitExpression();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "jsVar.initExpression");
            return CollectUtilsKt.extractImportTag(jsExpression);
        }
        return null;
    }

    @Nullable
    public static final String extractImportTag(@NotNull JsExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        StringBuilder sb = new StringBuilder();
        return CollectUtilsKt.extractImportTagImpl(expression2, sb) ? sb.toString() : null;
    }

    private static final boolean extractImportTagImpl(JsExpression expression2, StringBuilder sb) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsNameRef) {
            JsExpression nameRef = expression2;
            if (((JsNameRef)nameRef).getQualifier() != null) {
                JsExpression jsExpression2 = ((JsNameRef)nameRef).getQualifier();
                if (jsExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "nameRef.qualifier!!");
                if (!CollectUtilsKt.extractImportTagImpl(jsExpression2, sb)) {
                    return false;
                }
                sb.append('.');
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(((JsNameRef)nameRef).getIdent()));
            return true;
        }
        if (jsExpression instanceof JsArrayAccess) {
            JsExpression arrayAccess = expression2;
            JsExpression jsExpression3 = ((JsArrayAccess)arrayAccess).getArrayExpression();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "arrayAccess.arrayExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression3, sb)) {
                return false;
            }
            sb.append(".");
            JsExpression jsExpression4 = ((JsArrayAccess)arrayAccess).getIndexExpression();
            if (!(jsExpression4 instanceof JsStringLiteral)) {
                jsExpression4 = null;
            }
            JsStringLiteral jsStringLiteral = (JsStringLiteral)jsExpression4;
            if (jsStringLiteral == null) {
                return false;
            }
            JsStringLiteral stringLiteral = jsStringLiteral;
            sb.append(JsToStringGenerationVisitor.javaScriptString(stringLiteral.getValue()));
            return true;
        }
        return false;
    }
}

