/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0012"}, d2={"isVararg", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "stableType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getStableType", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "unstableType", "getUnstableType", "unexpectedArgument", "", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getExpectedType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "resolution"})
public final class ArgumentsUtilsKt {
    @NotNull
    public static final Void unexpectedArgument(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        String string = "Unexpected argument type: " + argument + ", " + argument.getClass().getCanonicalName() + '.';
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Nullable
    public static final UnwrappedType getUnstableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return null;
        }
        return IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)SetsKt.plus($receiver.getPossibleTypes(), $receiver.getReceiverValue().getType()));
    }

    @NotNull
    public static final UnwrappedType getStableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return $receiver.getReceiverValue().getType().unwrap();
        }
        return IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)SetsKt.plus($receiver.getPossibleTypes(), $receiver.getReceiverValue().getType()));
    }

    @NotNull
    public static final UnwrappedType getExpectedType(@NotNull KotlinCallArgument $receiver, @NotNull ParameterDescriptor parameter) {
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        if ($receiver.isSpread()) {
            annotated = parameter.getType().unwrap();
        } else {
            ParameterDescriptor $receiver$iv = parameter;
            ParameterDescriptor parameterDescriptor = $receiver$iv;
            if (!(parameterDescriptor instanceof ValueParameterDescriptor)) {
                parameterDescriptor = null;
            }
            if ((annotated = (ValueParameterDescriptor)parameterDescriptor) == null || (annotated = annotated.getVarargElementType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                annotated = parameter.getType().unwrap();
            }
        }
        return annotated;
    }

    public static final boolean isVararg(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getVarargElementType() != null;
    }
}

