/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkIdentifier", "identifier", "Lcom/intellij/psi/PsiElement;", "allowSingleUnderscore", "", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "frontend"})
public final class UnderscoreChecker
implements DeclarationChecker {
    public static final UnderscoreChecker INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if (identifier == null) return;
        CharSequence charSequence = identifier.getText();
        if (charSequence.length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        boolean bl2 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual(identifier.getText(), "_");
        if (!isValidSingleUnderscore) {
            boolean bl3;
            block5: {
                CharSequence $receiver$iv;
                CharSequence charSequence2 = $receiver$iv = (CharSequence)identifier.getText();
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv = charSequence2.charAt(i);
                    char it = element$iv;
                    if (it == '_') continue;
                    bl3 = false;
                    break block5;
                }
                bl3 = true;
            }
            if (bl3) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, TuplesKt.to(LanguageFeature.SingleUnderscoreForParameterName, languageVersionSettings)));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings, bl);
    }

    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder, languageVersionSettings, allowSingleUnderscore);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, bl);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        UnderscoreChecker.checkNamed$default(this, declaration, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Iterator<KtNamedDeclarationStub> iterator2;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if (declaration instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration instanceof KtCallableDeclaration) {
            iterator2 = ((KtCallableDeclaration)declaration).getValueParameters().iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter;
                KtParameter ktParameter = parameter = (KtParameter)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(ktParameter, "parameter");
                this.checkNamed(ktParameter, diagnosticHolder, languageVersionSettings, descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            iterator2 = ((KtTypeParameterListOwner)declaration).getTypeParameters().iterator();
            while (iterator2.hasNext()) {
                KtTypeParameter typeParameter;
                KtTypeParameter ktTypeParameter = typeParameter = (KtTypeParameter)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
                UnderscoreChecker.checkNamed$default(this, ktTypeParameter, diagnosticHolder, languageVersionSettings, false, 8, null);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    private UnderscoreChecker() {
        INSTANCE = this;
    }

    static {
        new UnderscoreChecker();
    }
}

