/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions.unqualifiedSuper;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u001a$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a?\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010 \u001a\u00020\u00122\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\"H\u0082\b\u001a$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010$\u001a\u00020\rH\u0002\u001a,\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000bH\u0002\u001a*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010&\u001a\u00020\u000b\u001a\f\u0010(\u001a\u00020\u0012*\u00020\u000bH\u0002\"*\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"ARITY_OF_METHODS_OF_ANY", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "LOOKUP_LOCATION", "Lorg/jetbrains/kotlin/incremental/components/NoLookupLocation;", "getFunctionMembers", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getPropertyMembers", "isCallingMethodOfAny", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "isCallingMethodOfAnyWithSuper", "superExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "isConcreteMember", "supertype", "memberDescriptor", "isPossiblyAmbiguousUnqualifiedSuper", "supertypes", "resolveSupertypesByCalleeName", "resolveSupertypesByMembers", "allowNonConcreteMembers", "getMembers", "Lkotlin/Function1;", "resolveSupertypesByPropertyName", "propertyName", "resolveSupertypesForMethodOfAny", "anyType", "resolveUnqualifiedSuperFromExpressionContext", "isInterface", "frontend"})
public final class UnqualifiedSuperKt {
    private static final HashMap<String, Integer> ARITY_OF_METHODS_OF_ANY = MapsKt.hashMapOf(TuplesKt.to("hashCode", 0), TuplesKt.to("equals", 1), TuplesKt.to("toString", 0));
    private static final NoLookupLocation LOOKUP_LOCATION = NoLookupLocation.WHEN_GET_SUPER_MEMBERS;

    @NotNull
    public static final Collection<KotlinType> resolveUnqualifiedSuperFromExpressionContext(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2, @NotNull KotlinType anyType) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        Intrinsics.checkParameterIsNotNull(anyType, "anyType");
        PsiElement parentElement = superExpression.getParent();
        if (parentElement instanceof KtDotQualifiedExpression) {
            KtExpression selectorExpression = ((KtDotQualifiedExpression)parentElement).getSelectorExpression();
            KtExpression ktExpression = selectorExpression;
            if (ktExpression instanceof KtCallExpression) {
                KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
                if (calleeExpression instanceof KtSimpleNameExpression) {
                    Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
                    return UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName) ? UnqualifiedSuperKt.resolveSupertypesForMethodOfAny(supertypes2, calleeName, anyType) : UnqualifiedSuperKt.resolveSupertypesByCalleeName(supertypes2, calleeName);
                }
            } else if (ktExpression instanceof KtSimpleNameExpression) {
                return UnqualifiedSuperKt.resolveSupertypesByPropertyName(supertypes2, ((KtSimpleNameExpression)selectorExpression).getReferencedNameAsName());
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean isCallingMethodOfAny(KtCallExpression callExpression, Name calleeName) {
        Map map2 = ARITY_OF_METHODS_OF_ANY;
        String string = calleeName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "calleeName.asString()");
        String string2 = string;
        Object object = map2.get(string2);
        if (object == null) {
            object = -1;
        }
        return ((Number)object).intValue() == callExpression.getValueArguments().size();
    }

    public static final boolean isPossiblyAmbiguousUnqualifiedSuper(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        return supertypes2.size() > 1 || supertypes2.size() == 1 && UnqualifiedSuperKt.isInterface((KotlinType)CollectionsKt.single((Iterable)supertypes2)) && UnqualifiedSuperKt.isCallingMethodOfAnyWithSuper(superExpression);
    }

    private static final boolean isCallingMethodOfAnyWithSuper(KtSuperExpression superExpression) {
        KtExpression calleeExpression;
        KtExpression selectorExpression;
        PsiElement parent2 = superExpression.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && (selectorExpression = ((KtDotQualifiedExpression)parent2).getSelectorExpression()) instanceof KtCallExpression && (calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
            return UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName);
        }
        return false;
    }

    private static final boolean isInterface(@NotNull KotlinType $receiver) {
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor($receiver);
        return Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE);
    }

    private static final Collection<KotlinType> resolveSupertypesForMethodOfAny(Collection<? extends KotlinType> supertypes2, Name calleeName, KotlinType anyType) {
        boolean allowNonConcreteMembers$iv = false;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithNonConcreteMembers$iv = new SmartList<KotlinType>();
        for (KotlinType collection : supertypes2) {
            boolean bl;
            block5: {
                KotlinType it = collection;
                Collection<MemberDescriptor> members$iv = UnqualifiedSuperKt.getFunctionMembers(it, calleeName, LOOKUP_LOCATION);
                Collection<MemberDescriptor> collection2 = members$iv;
                if (!(!collection2.isEmpty())) continue;
                Iterable $receiver$iv$iv = members$iv;
                if ($receiver$iv$iv instanceof Collection && ((Collection)$receiver$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                        if (!UnqualifiedSuperKt.isConcreteMember(collection, it$iv)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                typesWithConcreteMembers$iv.add(collection);
                continue;
            }
            typesWithNonConcreteMembers$iv.add(collection);
        }
        CollectionsKt.removeAll((List)typesWithConcreteMembers$iv, (Function1)new Function1<KotlinType, Boolean>(typesWithNonConcreteMembers$iv){
            final /* synthetic */ SmartList $typesWithNonConcreteMembers;

            public final boolean invoke(KotlinType typeWithConcreteMember) {
                boolean bl;
                block3: {
                    Iterable $receiver$iv = this.$typesWithNonConcreteMembers;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            KotlinType typeWithNonConcreteMember = (KotlinType)element$iv;
                            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(typeWithNonConcreteMember, typeWithConcreteMember)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$typesWithNonConcreteMembers = smartList;
                super(1);
            }
        });
        Collection collection = typesWithConcreteMembers$iv;
        Collection typesWithConcreteOverride = !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)CollectionsKt.emptyList();
        Collection collection2 = typesWithConcreteOverride;
        return !collection2.isEmpty() ? typesWithConcreteOverride : (Collection)CollectionsKt.listOf(anyType);
    }

    private static final Collection<KotlinType> resolveSupertypesByCalleeName(Collection<? extends KotlinType> supertypes2, Name calleeName) {
        boolean allowNonConcreteMembers$iv = true;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithNonConcreteMembers$iv = new SmartList<KotlinType>();
        for (KotlinType collection : supertypes2) {
            boolean bl;
            block5: {
                KotlinType it = collection;
                Collection members$iv = CollectionsKt.plus(UnqualifiedSuperKt.getFunctionMembers(it, calleeName, LOOKUP_LOCATION), (Iterable)UnqualifiedSuperKt.getPropertyMembers(it, calleeName, LOOKUP_LOCATION));
                Collection collection2 = members$iv;
                if (!(!collection2.isEmpty())) continue;
                Iterable $receiver$iv$iv = members$iv;
                if ($receiver$iv$iv instanceof Collection && ((Collection)$receiver$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                        if (!UnqualifiedSuperKt.isConcreteMember(collection, it$iv)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                typesWithConcreteMembers$iv.add(collection);
                continue;
            }
            typesWithNonConcreteMembers$iv.add(collection);
        }
        CollectionsKt.removeAll((List)typesWithConcreteMembers$iv, (Function1)new /* invalid duplicate definition of identical inner class */);
        Collection collection = typesWithConcreteMembers$iv;
        return !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)typesWithNonConcreteMembers$iv;
    }

    private static final Collection<KotlinType> resolveSupertypesByPropertyName(Collection<? extends KotlinType> supertypes2, Name propertyName) {
        boolean allowNonConcreteMembers$iv = true;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithNonConcreteMembers$iv = new SmartList<KotlinType>();
        for (KotlinType collection : supertypes2) {
            boolean bl;
            block5: {
                KotlinType it = collection;
                Collection<MemberDescriptor> members$iv = UnqualifiedSuperKt.getPropertyMembers(it, propertyName, LOOKUP_LOCATION);
                Collection<MemberDescriptor> collection2 = members$iv;
                if (!(!collection2.isEmpty())) continue;
                Iterable $receiver$iv$iv = members$iv;
                if ($receiver$iv$iv instanceof Collection && ((Collection)$receiver$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                        if (!UnqualifiedSuperKt.isConcreteMember(collection, it$iv)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                typesWithConcreteMembers$iv.add(collection);
                continue;
            }
            typesWithNonConcreteMembers$iv.add(collection);
        }
        CollectionsKt.removeAll((List)typesWithConcreteMembers$iv, (Function1)new /* invalid duplicate definition of identical inner class */);
        Collection collection = typesWithConcreteMembers$iv;
        return !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)typesWithNonConcreteMembers$iv;
    }

    private static final Collection<MemberDescriptor> getFunctionMembers(KotlinType type2, Name name, LookupLocation location2) {
        return type2.getMemberScope().getContributedFunctions(name, location2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<MemberDescriptor> getPropertyMembers(KotlinType type2, Name name, LookupLocation location2) {
        void $receiver$iv;
        Iterable iterable = type2.getMemberScope().getContributedVariables(name, location2);
        Collection destination$iv = new SmartList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator2.next();
            if (!(t != null ? t instanceof MemberDescriptor : true)) continue;
            destination$iv.add(element$iv);
        }
        return destination$iv;
    }

    private static final boolean isConcreteMember(KotlinType supertype, MemberDescriptor memberDescriptor) {
        if (Intrinsics.areEqual((Object)memberDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            return false;
        }
        ClassDescriptor classDescriptorForSupertype = TypeUtils.getClassDescriptor(supertype);
        MemberDescriptor memberDescriptor2 = memberDescriptor;
        if (memberDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
        }
        CallableMemberDescriptor.Kind memberKind = ((CallableMemberDescriptor)memberDescriptor2).getKind();
        ClassDescriptor classDescriptor = classDescriptorForSupertype;
        if (Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)memberKind, (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            Annotated annotated = ((CallableMemberDescriptor)memberDescriptor).getDispatchReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return false;
            }
            Annotated dispatchReceiverType = annotated;
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor((KotlinType)dispatchReceiverType);
            if (classDescriptor2 == null) {
                return false;
            }
            ClassDescriptor dispatchReceiverClass = classDescriptor2;
            return !KotlinBuiltIns.isAny(dispatchReceiverClass);
        }
        return true;
    }
}

