/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineConnector;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.figures.PolyLineLocator;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Vector;

public class PolyLineFigure
extends AbstractFigure {
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    protected Vector fPoints;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Color fFrameColor = Color.black;
    private static final long serialVersionUID = -7951352179906577773L;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this.fPoints = new Vector(4);
    }

    public PolyLineFigure(int n) {
        this.fPoints = new Vector(n);
    }

    public PolyLineFigure(int n, int n2) {
        this.fPoints = new Vector();
        this.fPoints.addElement(new Point(n, n2));
    }

    public Rectangle displayBox() {
        Enumeration enumeration = this.points();
        Rectangle rectangle = new Rectangle((Point)enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            rectangle.add((Point)enumeration.nextElement());
        }
        return rectangle;
    }

    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    public Vector handles() {
        Vector<PolyLineHandle> vector = new Vector<PolyLineHandle>(this.fPoints.size());
        for (int i = 0; i < this.fPoints.size(); ++i) {
            vector.addElement(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        return vector;
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public void addPoint(int n, int n2) {
        this.fPoints.addElement(new Point(n, n2));
        this.changed();
    }

    public Enumeration points() {
        return this.fPoints.elements();
    }

    public int pointCount() {
        return this.fPoints.size();
    }

    protected void basicMoveBy(int n, int n2) {
        Enumeration enumeration = this.fPoints.elements();
        while (enumeration.hasMoreElements()) {
            ((Point)enumeration.nextElement()).translate(n, n2);
        }
    }

    public void setPointAt(Point point, int n) {
        this.willChange();
        this.fPoints.setElementAt(point, n);
        this.changed();
    }

    public void insertPointAt(Point point, int n) {
        this.fPoints.insertElementAt(point, n);
        this.changed();
    }

    public void removePointAt(int n) {
        this.willChange();
        this.fPoints.removeElementAt(n);
        this.changed();
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
        }
        return n3 + 1;
    }

    public Point pointAt(int n) {
        return (Point)this.fPoints.elementAt(n);
    }

    public boolean joinSegments(int n, int n2) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point point = this.pointAt(i);
            if (Geom.length(n, n2, point.x, point.y) >= 3L) continue;
            this.removePointAt(i);
            return true;
        }
        return false;
    }

    public Connector connectorAt(int n, int n2) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration lineDecoration) {
        this.fStartDecoration = lineDecoration;
    }

    public void setEndDecoration(LineDecoration lineDecoration) {
        this.fEndDecoration = lineDecoration;
    }

    public void draw(Graphics graphics, boolean bl) {
        graphics.setColor(this.getFrameColor());
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = (Point)this.fPoints.elementAt(i);
            Point point2 = (Point)this.fPoints.elementAt(i + 1);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
        this.decorate(graphics);
        if (bl) {
            this.drawURL(graphics);
        }
    }

    private void drawURL(Graphics graphics) {
        Point point;
        Point point2;
        String string = (String)this.getAttribute("Sensitive");
        if (string == null || string.length() == 0) {
            return;
        }
        int n = this.fPoints.size() < 3 ? 0 : this.fPoints.size() / 2 - 1;
        if ((this.fPoints.size() & 1) == 1) {
            point = point2 = (Point)this.fPoints.elementAt(n + 1);
        } else {
            point2 = (Point)this.fPoints.elementAt(n);
            point = (Point)this.fPoints.elementAt(n + 1);
        }
        graphics.setColor(Color.red);
        graphics.setFont(AbstractFigure.dialogFont);
        graphics.drawString("url=" + string, (point2.x + point.x) / 2, (point2.y + point.y) / 2);
    }

    public boolean containsPoint(int n, int n2) {
        Rectangle rectangle = this.displayBox();
        rectangle.grow(4, 4);
        if (!rectangle.contains(n, n2)) {
            return false;
        }
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = (Point)this.fPoints.elementAt(i);
            Point point2 = (Point)this.fPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return true;
        }
        return false;
    }

    public int findSegment(int n, int n2) {
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point point = (Point)this.fPoints.elementAt(i);
            Point point2 = (Point)this.fPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(point.x, point.y, point2.x, point2.y, n, n2)) continue;
            return i;
        }
        return -1;
    }

    private void decorate(Graphics graphics) {
        Point point;
        Point point2;
        if (this.fStartDecoration != null) {
            point2 = (Point)this.fPoints.elementAt(0);
            point = (Point)this.fPoints.elementAt(1);
            this.fStartDecoration.draw(graphics, point2.x, point2.y, point.x, point.y);
        }
        if (this.fEndDecoration != null) {
            point2 = (Point)this.fPoints.elementAt(this.fPoints.size() - 2);
            point = (Point)this.fPoints.elementAt(this.fPoints.size() - 1);
            this.fEndDecoration.draw(graphics, point.x, point.y, point2.x, point2.y);
        }
    }

    public Object getAttribute(String string) {
        if (string.equals("FrameColor")) {
            return this.getFrameColor();
        }
        if (string.equals("ArrowMode")) {
            int n = 0;
            if (this.fStartDecoration != null) {
                n |= 1;
            }
            if (this.fEndDecoration != null) {
                n |= 2;
            }
            return new Integer(n);
        }
        return super.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("FrameColor")) {
            this.setFrameColor((Color)object);
            this.changed();
        } else if (string.equals("ArrowMode")) {
            Integer n = (Integer)object;
            if (n != null) {
                int n2 = n;
                this.fStartDecoration = (n2 & 1) != 0 ? new ArrowTip() : null;
                this.fEndDecoration = (n2 & 2) != 0 ? new ArrowTip() : null;
            }
            this.changed();
        } else {
            super.setAttribute(string, object);
            this.changed();
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fPoints.size());
        Enumeration enumeration = this.fPoints.elements();
        while (enumeration.hasMoreElements()) {
            Point point = (Point)enumeration.nextElement();
            storableOutput.writeInt(point.x);
            storableOutput.writeInt(point.y);
        }
        storableOutput.writeStorable(this.fStartDecoration);
        storableOutput.writeStorable(this.fEndDecoration);
        storableOutput.writeColor(this.fFrameColor);
    }

    public String getMap() {
        String string = (String)this.getAttribute("Sensitive");
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            string = URLDecoder.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration enumeration = this.fPoints.elements();
        boolean bl = true;
        String string2 = "";
        String string3 = "";
        for (int i = 1; i < this.fPoints.size(); ++i) {
            Point point = (Point)this.fPoints.elementAt(i - 1);
            Point point2 = (Point)this.fPoints.elementAt(i);
            double d = Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
            int n = (int)((double)(4 * (point2.y - point.y)) / d);
            int n2 = (int)((double)(4 * (point2.x - point.x)) / d);
            if (!bl) {
                string2 = string2 + ",";
                string3 = "," + string3;
            }
            bl = false;
            string2 = string2 + (point.x + n) + "," + (point.y + n2) + "," + (point2.x + n) + "," + (point2.y + n2);
            string3 = point2.x - n + "," + (point2.y - n2) + "," + (point.x - n) + "," + (point.y - n2) + string3;
        }
        return "<area shape=\"poly\" coords=\"" + string2 + "," + string3 + "\" href=\"" + string + "\" />\n";
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        if (n == -1) {
            String string = storableInput.readString();
            this.setAttribute("Sensitive", string);
            n = storableInput.readInt();
        }
        this.fPoints = new Vector(n);
        for (int i = 0; i < n; ++i) {
            int n2 = storableInput.readInt();
            int n3 = storableInput.readInt();
            this.fPoints.addElement(new Point(n2, n3));
        }
        this.fStartDecoration = (LineDecoration)storableInput.readStorable();
        this.fEndDecoration = (LineDecoration)storableInput.readStorable();
        this.fFrameColor = storableInput.readColor();
    }

    public static Locator locator(int n) {
        return new PolyLineLocator(n);
    }

    protected Color getFrameColor() {
        return this.fFrameColor;
    }

    protected void setFrameColor(Color color) {
        this.fFrameColor = color;
    }
}

