/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureCategory
implements Comparable<FurnitureCategory> {
    private final String name;
    private List<CatalogPieceOfFurniture> furniture;
    private static final Collator COMPARATOR = Collator.getInstance();

    public FurnitureCategory(String string) {
        this.name = string;
        this.furniture = new ArrayList<CatalogPieceOfFurniture>();
    }

    public String getName() {
        return this.name;
    }

    public List<CatalogPieceOfFurniture> getFurniture() {
        return Collections.unmodifiableList(this.furniture);
    }

    public int getFurnitureCount() {
        return this.furniture.size();
    }

    public CatalogPieceOfFurniture getPieceOfFurniture(int n) {
        return this.furniture.get(n);
    }

    public int getIndexOfPieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        return this.furniture.indexOf(catalogPieceOfFurniture);
    }

    void add(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        catalogPieceOfFurniture.setCategory(this);
        int n = Collections.binarySearch(this.furniture, catalogPieceOfFurniture);
        if (n < 0) {
            n = -n - 1;
        }
        this.furniture.add(n, catalogPieceOfFurniture);
    }

    void delete(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n = this.furniture.indexOf(catalogPieceOfFurniture);
        if (n == -1) {
            throw new IllegalArgumentException(this.name + " doesn't contain piece " + catalogPieceOfFurniture.getName());
        }
        this.furniture = new ArrayList<CatalogPieceOfFurniture>(this.furniture);
        this.furniture.remove(n);
    }

    public boolean equals(Object object) {
        return object instanceof FurnitureCategory && COMPARATOR.equals(this.name, ((FurnitureCategory)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(FurnitureCategory furnitureCategory) {
        return COMPARATOR.compare(this.name, furnitureCategory.name);
    }
}

