/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.Collection;
import java.util.logging.Logger;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.TrickleCallback;

class CandidateHarvesterSetElement {
    private static final Logger logger = Logger.getLogger(CandidateHarvesterSetElement.class.getName());
    private boolean enabled = true;
    private final CandidateHarvester harvester;

    public CandidateHarvesterSetElement(CandidateHarvester harvester) {
        this.harvester = harvester;
        harvester.getHarvestStatistics().harvesterName = harvester.toString();
    }

    public void harvest(Component component, TrickleCallback trickleCallback) {
        if (!this.isEnabled()) {
            return;
        }
        this.startHarvestTiming();
        Collection<LocalCandidate> candidates = this.harvester.harvest(component);
        this.stopHarvestTiming(candidates);
        if (candidates == null || candidates.isEmpty()) {
            this.setEnabled(false);
        } else if (trickleCallback != null) {
            trickleCallback.onIceCandidates(candidates);
        }
    }

    public boolean harvesterEquals(CandidateHarvester harvester) {
        return this.harvester.equals(harvester);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        logger.info((enabled ? "Enabling: " : "Disabling: ") + this.harvester);
        this.enabled = enabled;
    }

    public CandidateHarvester getHarvester() {
        return this.harvester;
    }

    private void startHarvestTiming() {
        this.harvester.getHarvestStatistics().startHarvestTiming();
    }

    private void stopHarvestTiming(Collection<LocalCandidate> harvest) {
        this.harvester.getHarvestStatistics().stopHarvestTiming(harvest);
    }
}

