/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogCookie
extends FilterAdaptor {
    private static final String DELIM = "\t";
    private Vector<String> cookieList = null;

    @Override
    public int getId() {
        return 100;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.logcookies.name");
    }

    public void init() {
        this.cookieList = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        if (httpRequestHeader != null) {
            String string = httpRequestHeader.getHeader("Cookie");
            Vector<String> vector = this.cookieList;
            synchronized (vector) {
                if (string != null && this.cookieList.indexOf(string) == -1) {
                    try {
                        URI uRI;
                        try {
                            uRI = (URI)httpRequestHeader.getURI().clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            throw new URIException(cloneNotSupportedException.getMessage());
                        }
                        uRI.setQuery(null);
                        String string2 = uRI.toString();
                        this.cookieList.add(string);
                        this.getView().getOutputPanel().append(string2 + DELIM + string + "\n");
                    }
                    catch (URIException uRIException) {
                        this.getView().getOutputPanel().append((Exception)((Object)uRIException));
                    }
                }
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }
}

