/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public final class AddOnInstaller {
    private static final Logger logger = Logger.getLogger(AddOnInstaller.class);

    private AddOnInstaller() {
    }

    public static void install(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
        List<Extension> list = AddOnInstaller.installAddOnExtensions(addOn);
        AddOnInstaller.installAddOnActiveScanRules(addOn, addOnClassLoader);
        AddOnInstaller.installAddOnPassiveScanRules(addOn, addOnClassLoader);
        for (Extension extension : list) {
            try {
                extension.postInstall();
            }
            catch (Exception exception) {
                logger.error((Object)("Post install method failed for add-on " + addOn.getId() + " extension " + extension.getName()));
            }
        }
    }

    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(addOnUninstallationProgressCallback);
        try {
            boolean bl = true;
            bl &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, addOnUninstallationProgressCallback);
            bl &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, addOnUninstallationProgressCallback);
            bl &= AddOnInstaller.uninstallAddOnExtensions(addOn, addOnUninstallationProgressCallback);
            return bl &= AddOnInstaller.uninstallAddOnFiles(addOn, addOnUninstallationProgressCallback);
        }
        catch (Throwable throwable) {
            logger.error((Object)("An error occurred while uninstalling the add-on: " + addOn.getId()), throwable);
            return false;
        }
    }

    public static boolean softUninstall(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(addOnUninstallationProgressCallback);
        try {
            boolean bl = true;
            bl &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, addOnUninstallationProgressCallback);
            bl &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, addOnUninstallationProgressCallback);
            return bl &= AddOnInstaller.uninstallAddOnExtensions(addOn, addOnUninstallationProgressCallback);
        }
        catch (Throwable throwable) {
            logger.error((Object)("An error occurred while uninstalling the add-on: " + addOn.getId()), throwable);
            return false;
        }
    }

    private static List<Extension> installAddOnExtensions(AddOn addOn) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        List<Extension> list = ExtensionFactory.loadAddOnExtensions(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), addOn);
        for (Extension extension : list) {
            AddOnInstaller.installAddOnExtensionImpl(addOn, extension, extensionLoader);
        }
        return list;
    }

    public static void installAddOnExtension(AddOn addOn, Extension extension) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        ExtensionFactory.addAddOnExtension(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), extension);
        AddOnInstaller.installAddOnExtensionImpl(addOn, extension, extensionLoader);
    }

    private static void installAddOnExtensionImpl(AddOn addOn, Extension extension, ExtensionLoader extensionLoader) {
        if (extension.isEnabled()) {
            logger.debug((Object)("Starting extension " + extension.getName()));
            try {
                extensionLoader.startLifeCycle(extension);
            }
            catch (Exception exception) {
                logger.error((Object)("An error occurred while installing the add-on: " + addOn.getId()), (Throwable)exception);
            }
        }
    }

    private static boolean uninstallAddOnExtensions(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        boolean bl = true;
        addOnUninstallationProgressCallback.extensionsWillBeRemoved(addOn.getLoadedExtensions().size());
        ArrayList<Extension> arrayList = new ArrayList<Extension>(addOn.getLoadedExtensions());
        Collections.reverse(arrayList);
        for (Extension extension : arrayList) {
            bl &= AddOnInstaller.uninstallAddOnExtension(addOn, extension, addOnUninstallationProgressCallback);
        }
        return bl;
    }

    protected static boolean uninstallAddOnExtension(AddOn addOn, Extension extension, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        boolean bl = true;
        if (extension.isEnabled()) {
            String string = extension.getUIName();
            if (extension.canUnload()) {
                logger.debug((Object)("Unloading ext: " + extension.getName()));
                try {
                    extension.unload();
                    Control.getSingleton().getExtensionLoader().removeExtension(extension, extension.getExtensionHook());
                    ExtensionFactory.unloadAddOnExtension(extension);
                }
                catch (Exception exception) {
                    logger.error((Object)("An error occurred while uninstalling the extension \"" + extension.getName() + "\" bundled in the add-on \"" + addOn.getId() + "\":"), (Throwable)exception);
                    bl = false;
                }
            } else {
                logger.debug((Object)("Cant dynamically unload ext: " + extension.getName()));
                bl = false;
            }
            addOnUninstallationProgressCallback.extensionRemoved(string);
        }
        addOn.removeLoadedExtension(extension);
        return bl;
    }

    private static void installAddOnActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<AbstractPlugin> list = AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader);
        if (!list.isEmpty()) {
            for (AbstractPlugin abstractPlugin : list) {
                String string = abstractPlugin.getClass().getCanonicalName();
                logger.debug((Object)("Install ascanrule: " + string));
                PluginFactory.loadedPlugin(abstractPlugin);
                if (PluginFactory.isPluginLoaded(abstractPlugin)) continue;
                logger.error((Object)("Failed to install ascanrule: " + string));
            }
        }
    }

    private static boolean uninstallAddOnActiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        boolean bl = true;
        List<AbstractPlugin> list = addOn.getLoadedAscanrules();
        if (!list.isEmpty()) {
            logger.debug((Object)("Uninstall ascanrules: " + addOn.getAscanrules()));
            addOnUninstallationProgressCallback.activeScanRulesWillBeRemoved(list.size());
            for (AbstractPlugin abstractPlugin : list) {
                String string = abstractPlugin.getClass().getCanonicalName();
                logger.debug((Object)("Uninstall ascanrule: " + string));
                PluginFactory.unloadedPlugin(abstractPlugin);
                if (PluginFactory.isPluginLoaded(abstractPlugin)) {
                    logger.error((Object)("Failed to uninstall ascanrule: " + string));
                    bl = false;
                }
                addOnUninstallationProgressCallback.activeScanRuleRemoved(string);
            }
            addOn.setLoadedAscanrules(Collections.emptyList());
            addOn.setLoadedAscanrulesSet(false);
        }
        return bl;
    }

    private static void installAddOnPassiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<PluginPassiveScanner> list = AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader);
        ExtensionPassiveScan extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (!list.isEmpty() && extensionPassiveScan != null) {
            for (PluginPassiveScanner pluginPassiveScanner : list) {
                String string = pluginPassiveScanner.getClass().getCanonicalName();
                logger.debug((Object)("Install pscanrule: " + string));
                if (extensionPassiveScan.addPassiveScanner(pluginPassiveScanner)) continue;
                logger.error((Object)("Failed to install pscanrule: " + string));
            }
        }
    }

    private static boolean uninstallAddOnPassiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        boolean bl = true;
        List<PluginPassiveScanner> list = addOn.getLoadedPscanrules();
        ExtensionPassiveScan extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (!list.isEmpty()) {
            logger.debug((Object)("Uninstall pscanrules: " + addOn.getPscanrules()));
            addOnUninstallationProgressCallback.passiveScanRulesWillBeRemoved(list.size());
            for (PluginPassiveScanner pluginPassiveScanner : list) {
                String string = pluginPassiveScanner.getClass().getCanonicalName();
                logger.debug((Object)("Uninstall pscanrule: " + string));
                if (!extensionPassiveScan.removePassiveScanner(pluginPassiveScanner)) {
                    logger.error((Object)("Failed to uninstall pscanrule: " + string));
                    bl = false;
                }
                addOnUninstallationProgressCallback.passiveScanRuleRemoved(string);
            }
            addOn.setLoadedPscanrules(Collections.emptyList());
            addOn.setLoadedPscanrulesSet(false);
        }
        return bl;
    }

    public static void installMissingAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, false);
    }

    private static void installAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn, boolean bl) {
        List<String> list = addOn.getFiles();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            File file = new File(Constant.getZapHome(), string);
            if (!bl && file.exists()) continue;
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                logger.error((Object)("Failed to create directories for: " + file.getAbsolutePath()));
                continue;
            }
            logger.debug((Object)("Installing file: " + string));
            URL uRL = addOnClassLoader.findResource(string);
            if (uRL == null) {
                logger.error((Object)("File not found on add-on package: " + string));
                continue;
            }
            try {
                InputStream inputStream = uRL.openStream();
                Throwable throwable = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Throwable throwable2 = null;
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = inputStream.read(byArray)) != -1) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)fileOutputStream).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to install file " + file.getAbsolutePath()), (Throwable)iOException);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesAdded();
    }

    private static void validateCallbackNotNull(AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        Validate.notNull((Object)addOnUninstallationProgressCallback, (String)"Parameter callback must not be null.");
    }

    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(addOnUninstallationProgressCallback);
        List<String> list = addOn.getFiles();
        if (list == null || list.isEmpty()) {
            return true;
        }
        addOnUninstallationProgressCallback.filesWillBeRemoved(list.size());
        boolean bl = true;
        for (String string : list) {
            if (string == null) continue;
            logger.debug((Object)("Uninstall file: " + string));
            File file = new File(Constant.getZapHome(), string);
            try {
                File file2 = file.getParentFile();
                if (!file.delete()) {
                    logger.error((Object)("Failed to delete: " + file.getAbsolutePath()));
                    bl = false;
                }
                addOnUninstallationProgressCallback.fileRemoved();
                if (file2.isDirectory() && file2.list().length == 0) {
                    logger.debug((Object)("Deleting: " + file2.getAbsolutePath()));
                    if (!file2.delete()) {
                        logger.debug((Object)("Failed to delete: " + file2.getAbsolutePath()));
                    }
                }
                AddOnInstaller.deleteEmptyDirsCreatedForAddOnFiles(file);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to uninstall file " + file.getAbsolutePath()), (Throwable)exception);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesRemoved();
        return bl;
    }

    private static void deleteEmptyDirsCreatedForAddOnFiles(File file) {
        File file2;
        if (file == null) {
            return;
        }
        for (file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        String string = new File(Constant.getZapHome()).getAbsolutePath();
        while (file2 != null && file2.exists() && file2.getAbsolutePath().startsWith(string) && file2.getAbsolutePath().length() > string.length()) {
            AddOnInstaller.deleteEmptyDirs(file2);
            file2 = file2.getParentFile();
        }
    }

    private static void deleteEmptyDirs(File file) {
        logger.debug((Object)("Deleting dir " + file.getAbsolutePath()));
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            AddOnInstaller.deleteEmptyDirs(file2);
        }
        if (!file.delete()) {
            logger.debug((Object)("Failed to delete: " + file.getAbsolutePath()));
        }
    }
}

