/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTree;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;

public final class AddOnRunIssuesUtils {
    private static final Logger LOGGER = Logger.getLogger(AddOnRunIssuesUtils.class);

    private AddOnRunIssuesUtils() {
    }

    public static void showWarningMessageAddOnsNotRunnable(String string, AddOnCollection addOnCollection, Collection<AddOn> collection) {
        Object[] objectArray = new Object[]{string, AddOnRunIssuesUtils.createScrollableTreeAddOnsNotRunnable(addOnCollection, collection.toArray(new AddOn[collection.size()]))};
        JOptionPane.showMessageDialog(View.getSingleton().getMainFrame(), objectArray, "OWASP ZAP", 2);
    }

    private static JScrollPane createScrollableTreeAddOnsNotRunnable(final AddOnCollection addOnCollection, AddOn ... jXTree) {
        AddOnSearcher addOnSearcher = new AddOnSearcher(){

            @Override
            public AddOn searchAddOn(String string) {
                return addOnCollection.getAddOn(string);
            }
        };
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
        for (AddOn addOn : jXTree) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(addOn.getName());
            AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(addOnCollection.getAddOns());
            List<String> list = AddOnRunIssuesUtils.getUiRunningIssues(addOnRunRequirements, addOnSearcher);
            if (list.isEmpty()) {
                list.addAll(AddOnRunIssuesUtils.getUiExtensionsRunningIssues(addOnRunRequirements, addOnSearcher));
            }
            for (String string : list) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        JXTree jXTree2 = new JXTree((TreeModel)new DefaultTreeModel(defaultMutableTreeNode));
        jXTree2.setVisibleRowCount(5);
        jXTree2.setEditable(false);
        jXTree2.setRootVisible(false);
        jXTree2.setShowsRootHandles(true);
        jXTree2.expandAll();
        return new JScrollPane((Component)jXTree2);
    }

    public static boolean askConfirmationAddOnNotRunnable(String string, String string2, AddOnCollection addOnCollection, AddOn addOn) {
        Object[] objectArray = new Object[]{string, AddOnRunIssuesUtils.createScrollableTreeAddOnsNotRunnable(addOnCollection, addOn), string2};
        return JOptionPane.showConfirmDialog(View.getSingleton().getMainFrame(), objectArray, "OWASP ZAP", 0, 3) == 0;
    }

    public static List<String> getUiRunningIssues(AddOn.BaseRunRequirements baseRunRequirements, AddOnSearcher addOnSearcher) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (baseRunRequirements.isNewerJavaVersionRequired()) {
            if (baseRunRequirements.getAddOn() != baseRunRequirements.getAddOnMinimumJavaVersion()) {
                arrayList.add(MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.javaversion.dependency"), baseRunRequirements.getMinimumJavaVersion(), SystemUtils.JAVA_VERSION == null ? Constant.messages.getString("cfu.warn.unknownJavaVersion") : SystemUtils.JAVA_VERSION, baseRunRequirements.getAddOnMinimumJavaVersion().getName()));
            } else {
                arrayList.add(MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.javaversion"), baseRunRequirements.getMinimumJavaVersion(), SystemUtils.JAVA_VERSION == null ? Constant.messages.getString("cfu.warn.unknownJavaVersion") : SystemUtils.JAVA_VERSION));
            }
        }
        if (baseRunRequirements.hasDependencyIssue()) {
            List<Object> list = baseRunRequirements.getDependencyIssueDetails();
            String string = null;
            switch (baseRunRequirements.getDependencyIssue()) {
                case CYCLIC: {
                    string = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.id");
                    break;
                }
                case OLDER_VERSION: {
                    break;
                }
                case MISSING: {
                    String string2 = (String)list.get(0);
                    AddOn addOn = addOnSearcher != null ? addOnSearcher.searchAddOn(string2) : null;
                    if (addOn == null) {
                        string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.id"), string2);
                        break;
                    }
                    string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon"), addOn.getName());
                    break;
                }
                case PACKAGE_VERSION_NOT_BEFORE: {
                    AddOn addOn = (AddOn)list.get(0);
                    string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.version.notBefore"), addOn.getName(), list.get(1), addOn.getFileVersion());
                    break;
                }
                case PACKAGE_VERSION_NOT_FROM: {
                    AddOn addOn = (AddOn)list.get(0);
                    string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.version.notAfter"), addOn.getName(), list.get(1), addOn.getFileVersion());
                    break;
                }
                case VERSION: {
                    AddOn addOn = (AddOn)list.get(0);
                    if (addOn.getVersion() == null) {
                        string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.semver.notAvailable"), addOn.getName(), list.get(1));
                        break;
                    }
                    string = MessageFormat.format(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.semver"), addOn.getName(), list.get(1), addOn.getVersion());
                    break;
                }
                default: {
                    string = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.unknown");
                    LOGGER.warn((Object)("Failed to handle dependency issue with name \"" + baseRunRequirements.getDependencyIssue().name() + "\" and details: " + list));
                }
            }
            if (string != null) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static List<String> getUiExtensionsRunningIssues(AddOn.AddOnRunRequirements addOnRunRequirements, AddOnSearcher addOnSearcher) {
        if (!addOnRunRequirements.hasExtensionsWithRunningIssues()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (AddOn.ExtensionRunRequirements extensionRunRequirements : addOnRunRequirements.getExtensionRequirements()) {
            arrayList.addAll(AddOnRunIssuesUtils.getUiRunningIssues(extensionRunRequirements, addOnSearcher));
        }
        return arrayList;
    }

    public static List<String> getRunningIssues(AddOn.BaseRunRequirements baseRunRequirements) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        String string = AddOnRunIssuesUtils.getJavaVersionIssue(baseRunRequirements);
        if (string != null) {
            arrayList.add(string);
        }
        if ((string = AddOnRunIssuesUtils.getDependencyIssue(baseRunRequirements)) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> getExtensionsRunningIssues(AddOn.AddOnRunRequirements addOnRunRequirements) {
        if (!addOnRunRequirements.hasExtensionsWithRunningIssues()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (AddOn.ExtensionRunRequirements extensionRunRequirements : addOnRunRequirements.getExtensionRequirements()) {
            arrayList.addAll(AddOnRunIssuesUtils.getRunningIssues(extensionRunRequirements));
        }
        return arrayList;
    }

    public static String getJavaVersionIssue(AddOn.BaseRunRequirements baseRunRequirements) {
        if (!baseRunRequirements.isNewerJavaVersionRequired()) {
            return null;
        }
        if (baseRunRequirements.getAddOn() != baseRunRequirements.getAddOnMinimumJavaVersion()) {
            return MessageFormat.format("Minimum Java version: {0} (\"{1}\" add-on)", baseRunRequirements.getMinimumJavaVersion(), baseRunRequirements.getAddOnMinimumJavaVersion().getName());
        }
        return MessageFormat.format("Minimum Java version: {0}", baseRunRequirements.getMinimumJavaVersion());
    }

    public static String getDependencyIssue(AddOn.BaseRunRequirements baseRunRequirements) {
        if (!baseRunRequirements.hasDependencyIssue()) {
            return null;
        }
        List<Object> list = baseRunRequirements.getDependencyIssueDetails();
        switch (baseRunRequirements.getDependencyIssue()) {
            case CYCLIC: {
                return "Cyclic dependency with: " + list.get(0);
            }
            case OLDER_VERSION: {
                return "Older version still installed: " + list.get(0);
            }
            case MISSING: {
                String string = (String)list.get(0);
                return MessageFormat.format("Add-On with ID \"{0}\"", string);
            }
            case PACKAGE_VERSION_NOT_BEFORE: {
                AddOn addOn = (AddOn)list.get(0);
                return MessageFormat.format("Add-on \"{0}\" with version not before {1} (found version {2})", addOn.getName(), list.get(1), addOn.getFileVersion());
            }
            case PACKAGE_VERSION_NOT_FROM: {
                AddOn addOn = (AddOn)list.get(0);
                return MessageFormat.format("Add-on \"{0}\" with version not after {1} (found version {2})", addOn.getName(), list.get(1), addOn.getFileVersion());
            }
            case VERSION: {
                AddOn addOn = (AddOn)list.get(0);
                if (addOn.getVersion() == null) {
                    return MessageFormat.format("Add-on \"{0}\" with semantic version >= {1} (found no semantic version)", addOn.getName(), list.get(1));
                }
                return MessageFormat.format("Add-on \"{0}\" with semantic version >= {1} (found version {2})", addOn.getName(), list.get(1), addOn.getVersion());
            }
        }
        LOGGER.warn((Object)("Failed to handle dependency issue with name \"" + baseRunRequirements.getDependencyIssue().name() + "\" and details: " + list));
        return null;
    }

    public static interface AddOnSearcher {
        public AddOn searchAddOn(String var1);
    }
}

