/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertNode;

class AlertTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final Comparator<AlertNode> GROUP_ALERT_CHILD_COMPARATOR = new GroupAlertChildNodeComparator();
    private static final Comparator<AlertNode> ALERT_CHILD_COMPARATOR = new AlertChildNodeComparator();
    private static Logger logger = Logger.getLogger(AlertTreeModel.class);

    AlertTreeModel() {
        super(new AlertNode(-1, Constant.messages.getString("alerts.tree.title"), GROUP_ALERT_CHILD_COMPARATOR));
    }

    void addPath(final Alert alert) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.addPathEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.addPathEventHandler(alert);
                    }
                });
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private synchronized void addPathEventHandler(Alert alert) {
        AlertNode alertNode = (AlertNode)this.getRoot();
        alertNode = this.findAndAddChild(alertNode, alert.getName(), alert);
        String string = "";
        if (alert.getMethod() != null) {
            string = alert.getMethod() + ": ";
        }
        this.addLeaf(alertNode, string + alert.getUri(), alert);
    }

    private AlertNode findLeafNodeForAlert(AlertNode alertNode, Alert alert) {
        for (int i = 0; i < alertNode.getChildCount(); ++i) {
            AlertNode alertNode2 = alertNode.getChildAt(i);
            if (alertNode2.getChildCount() == 0) {
                if (alertNode2.getUserObject() == null || alertNode2.getUserObject().getAlertId() != alert.getAlertId()) continue;
                return alertNode2;
            }
            AlertNode alertNode3 = this.findLeafNodeForAlert(alertNode2, alert);
            if (alertNode3 == null) continue;
            return alertNode3;
        }
        return null;
    }

    public AlertNode getAlertNode(Alert alert) {
        AlertNode alertNode = (AlertNode)this.getRoot();
        int n = alert.getRisk();
        if (alert.getConfidence() == 0) {
            n = -1;
        }
        AlertNode alertNode2 = new AlertNode(n, alert.getName());
        alertNode2.setUserObject(alert);
        int n2 = alertNode.findIndex(alertNode2);
        if (n2 < 0) {
            return null;
        }
        if ((n2 = (alertNode = alertNode.getChildAt(n2)).findIndex(alertNode2)) < 0) {
            return null;
        }
        return alertNode.getChildAt(n2);
    }

    void updatePath(final Alert alert, final Alert alert2) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.updatePathEventHandler(alert, alert2);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.updatePathEventHandler(alert, alert2);
                    }
                });
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private synchronized void updatePathEventHandler(Alert alert, Alert alert2) {
        AlertNode alertNode = this.findLeafNodeForAlert((AlertNode)this.getRoot(), alert2);
        if (alertNode != null) {
            AlertNode alertNode2 = alertNode.getParent();
            this.removeNodeFromParent(alertNode);
            this.nodeStructureChanged(alertNode2);
            if (alertNode2.getChildCount() == 0) {
                this.removeNodeFromParent(alertNode2);
                this.nodeStructureChanged((AlertNode)this.getRoot());
            }
        }
        this.addPath(alert2);
    }

    private AlertNode findAndAddChild(AlertNode alertNode, String string, Alert alert) {
        int n;
        int n2 = alert.getRisk();
        if (alert.getConfidence() == 0) {
            n2 = -1;
        }
        if ((n = alertNode.findIndex(new AlertNode(n2, string))) < 0) {
            n = -(n + 1);
            AlertNode alertNode2 = new AlertNode(n2, string, ALERT_CHILD_COMPARATOR);
            alertNode2.setUserObject(alert);
            alertNode.insert(alertNode2, n);
            this.nodesWereInserted(alertNode, new int[]{n});
            this.nodeChanged(alertNode);
            return alertNode2;
        }
        return alertNode.getChildAt(n);
    }

    private void addLeaf(AlertNode alertNode, String string, Alert alert) {
        int n = alert.getRisk();
        if (alert.getConfidence() == 0) {
            n = -1;
        }
        AlertNode alertNode2 = new AlertNode(n, string);
        alertNode2.setUserObject(alert);
        int n2 = alertNode.findIndex(alertNode2);
        if (n2 < 0) {
            n2 = -(n2 + 1);
            alertNode.insert(alertNode2, n2);
            this.nodesWereInserted(alertNode, new int[]{n2});
            this.nodeChanged(alertNode);
        }
    }

    public synchronized void deletePath(Alert alert) {
        AlertNode alertNode = this.findLeafNodeForAlert((AlertNode)this.getRoot(), alert);
        if (alertNode != null) {
            AlertNode alertNode2 = alertNode.getParent();
            if (alertNode2.getChildCount() == 1) {
                alertNode2.remove(0);
                AlertNode alertNode3 = alertNode2.getParent();
                this.removeNodeFromParent(alertNode2);
                this.nodeChanged(alertNode3);
                return;
            }
            this.removeNodeFromParent(alertNode);
            if (alertNode2.getUserObject() == alertNode.getUserObject()) {
                alertNode2.setUserObject(alertNode2.getChildAt(0).getUserObject());
            }
            this.nodeChanged(alertNode2);
        }
    }

    private static class AlertChildNodeComparator
    implements Comparator<AlertNode> {
        private AlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode alertNode2) {
            return alertNode.getUserObject().compareTo(alertNode2.getUserObject());
        }
    }

    private static class GroupAlertChildNodeComparator
    implements Comparator<AlertNode> {
        private GroupAlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode alertNode2) {
            if (alertNode.getRisk() < alertNode2.getRisk()) {
                return 1;
            }
            if (alertNode.getRisk() > alertNode2.getRisk()) {
                return -1;
            }
            return alertNode.getNodeName().compareTo(alertNode2.getNodeName());
        }
    }
}

