/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.api.WebUI;

public class API {
    public static String API_DOMAIN = "zap";
    public static String API_URL = "http://" + API_DOMAIN + "/";
    public static String API_URL_S = "https://" + API_DOMAIN + "/";
    public static String API_KEY_PARAM = "apikey";
    public static String API_NONCE_PARAM = "apinonce";
    private static Pattern patternParam = Pattern.compile("&", 2);
    private static final String CALL_BACK_URL = "/zapCallBackUrl/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private Map<String, ApiImplementor> implementors = new HashMap<String, ApiImplementor>();
    private static API api = null;
    private WebUI webUI = new WebUI(this);
    private Map<String, ApiImplementor> callBacks = new HashMap<String, ApiImplementor>();
    private Map<String, ApiImplementor> shortcuts = new HashMap<String, ApiImplementor>();
    private Map<String, Nonce> nonces = Collections.synchronizedMap(new HashMap());
    private OptionsParamApi optionsParamApi;
    private Random random = new SecureRandom();
    private static final Logger logger = Logger.getLogger(API.class);

    private static synchronized API newInstance() {
        if (api == null) {
            api = new API();
        }
        return api;
    }

    public static API getInstance() {
        if (api == null) {
            API.newInstance();
        }
        return api;
    }

    public void registerApiImplementor(ApiImplementor apiImplementor) {
        if (this.implementors.get(apiImplementor.getPrefix()) != null) {
            logger.error((Object)("Second attempt to register API implementor with prefix of " + apiImplementor.getPrefix()));
            return;
        }
        this.implementors.put(apiImplementor.getPrefix(), apiImplementor);
        for (String string : apiImplementor.getApiShortcuts()) {
            logger.debug((Object)("Registering API shortcut: " + string));
            if (this.shortcuts.containsKey(string)) {
                logger.error((Object)("Duplicate API shortcut: " + string));
            }
            this.shortcuts.put("/" + string, apiImplementor);
        }
    }

    public void removeApiImplementor(ApiImplementor apiImplementor) {
        if (!this.implementors.containsKey(apiImplementor.getPrefix())) {
            logger.warn((Object)("Attempting to remove an API implementor not registered, with prefix: " + apiImplementor.getPrefix()));
            return;
        }
        this.implementors.remove(apiImplementor.getPrefix());
        for (String string : apiImplementor.getApiShortcuts()) {
            String string2 = "/" + string;
            if (!this.shortcuts.containsKey(string2)) continue;
            logger.debug((Object)("Removing registered API shortcut: " + string));
            this.shortcuts.remove(string2);
        }
    }

    public boolean isEnabled() {
        return !View.isInitialised() || this.getOptionsParamApi().isEnabled();
    }

    private OptionsParamApi getOptionsParamApi() {
        if (this.optionsParamApi == null) {
            this.optionsParamApi = Model.getSingleton().getOptionsParam().getApiParam();
        }
        return this.optionsParamApi;
    }

    void setOptionsParamApi(OptionsParamApi optionsParamApi) {
        this.optionsParamApi = optionsParamApi;
    }

    public boolean handleApiRequest(HttpRequestHeader httpRequestHeader, HttpInputStream httpInputStream, HttpOutputStream httpOutputStream) throws IOException {
        return this.handleApiRequest(httpRequestHeader, httpInputStream, httpOutputStream, false);
    }

    private boolean isPermittedAddr(HttpRequestHeader httpRequestHeader) {
        if (this.getOptionsParamApi().isPermittedAddress(httpRequestHeader.getSenderAddress().getHostAddress())) {
            if (this.getOptionsParamApi().isPermittedAddress(httpRequestHeader.getHostName())) {
                return true;
            }
            logger.warn((Object)("Request to API URL " + httpRequestHeader.getURI().toString() + " with host header " + httpRequestHeader.getHostName() + " not permitted"));
            return false;
        }
        logger.warn((Object)("Request to API URL " + httpRequestHeader.getURI().toString() + " from " + httpRequestHeader.getSenderAddress().getHostAddress() + " not permitted"));
        return false;
    }

    public boolean handleApiRequest(HttpRequestHeader httpRequestHeader, HttpInputStream httpInputStream, HttpOutputStream httpOutputStream, boolean bl) throws IOException {
        Map.Entry<String, ApiImplementor> entry2;
        Object object;
        Object object2;
        String string = httpRequestHeader.getURI().toString();
        Format format = Format.OTHER;
        ApiImplementor apiImplementor = null;
        ApiImplementor apiImplementor2 = null;
        if (string.contains(CALL_BACK_URL)) {
            if (!this.isPermittedAddr(httpRequestHeader)) {
                return true;
            }
            logger.debug((Object)("handleApiRequest Callback: " + string));
            object2 = this.callBacks.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (!string.startsWith((String)object.getKey())) continue;
                apiImplementor = (ApiImplementor)object.getValue();
                break;
            }
        }
        if ((object2 = httpRequestHeader.getURI().getPath()) != null) {
            for (Map.Entry<String, ApiImplementor> entry2 : this.shortcuts.entrySet()) {
                if (!((String)object2).startsWith(entry2.getKey())) continue;
                apiImplementor2 = entry2.getValue();
                break;
            }
        }
        if (!(apiImplementor2 != null || apiImplementor != null || string.startsWith(API_URL) || string.startsWith(API_URL_S) || bl)) {
            return false;
        }
        if (!this.isPermittedAddr(httpRequestHeader)) {
            return true;
        }
        if (this.getOptionsParamApi().isSecureOnly() && !httpRequestHeader.isSecure()) {
            logger.debug((Object)"handleApiRequest rejecting insecure request");
            return true;
        }
        logger.debug((Object)("handleApiRequest " + string));
        object = new HttpMessage();
        ((HttpMessage)object).setRequestHeader(httpRequestHeader);
        if (httpRequestHeader.getContentLength() > 0) {
            ((HttpMessage)object).setRequestBody(httpInputStream.readRequestBody(httpRequestHeader));
        }
        entry2 = null;
        ApiImplementor apiImplementor3 = null;
        RequestType requestType = null;
        String string2 = "text/plain; charset=UTF-8";
        String string3 = "";
        String string4 = null;
        boolean bl2 = false;
        try {
            JSONObject jSONObject = API.getParams(httpRequestHeader.getURI().getEscapedQuery());
            if (apiImplementor2 != null) {
                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(httpRequestHeader, jSONObject))) {
                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                }
                object = apiImplementor2.handleShortcut((HttpMessage)object);
            } else if (apiImplementor != null) {
                string3 = apiImplementor.handleCallBack((HttpMessage)object);
            } else {
                String[] stringArray = string.split("/");
                if (stringArray.length > 3 && stringArray[3].equalsIgnoreCase("favicon.ico")) {
                    if (!this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    InputStream inputStream = API.class.getResourceAsStream("/resource/zap.ico");
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    inputStream.close();
                    ((HttpMessage)object).setResponseHeader(API.getDefaultResponseHeader(string2));
                    ((HttpMessage)object).getResponseHeader().setContentLength(byArray.length);
                    httpOutputStream.write(((HttpMessage)object).getResponseHeader());
                    httpOutputStream.write(byArray);
                    httpOutputStream.flush();
                    httpOutputStream.close();
                    httpInputStream.close();
                    return true;
                }
                if (stringArray.length > 3) {
                    try {
                        format = Format.valueOf(stringArray[3].toUpperCase());
                        switch (format) {
                            case JSON: {
                                string2 = "application/json; charset=UTF-8";
                                break;
                            }
                            case JSONP: {
                                string2 = "application/javascript; charset=UTF-8";
                                break;
                            }
                            case XML: {
                                string2 = "text/xml; charset=UTF-8";
                                break;
                            }
                            case HTML: {
                                string2 = "text/html; charset=UTF-8";
                                break;
                            }
                            case UI: {
                                string2 = "text/html; charset=UTF-8";
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        format = Format.HTML;
                        throw new ApiException(ApiException.Type.BAD_FORMAT);
                    }
                }
                if (stringArray.length > 4 && (apiImplementor3 = this.implementors.get(entry2 = stringArray[4])) == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR);
                }
                if (stringArray.length > 5) {
                    try {
                        requestType = RequestType.valueOf(stringArray[5]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ApiException(ApiException.Type.BAD_TYPE);
                    }
                }
                if (stringArray.length > 6 && (string4 = stringArray[6]) != null && string4.indexOf("?") > 0) {
                    string4 = string4.substring(0, string4.indexOf("?"));
                }
                if (format.equals((Object)Format.UI)) {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    string3 = this.webUI.handleRequest((String)((Object)entry2), apiImplementor3, requestType, string4);
                    string2 = "text/html; charset=UTF-8";
                } else if (string4 != null) {
                    Object object3;
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    if (httpRequestHeader.getMethod().equalsIgnoreCase("POST")) {
                        object3 = httpRequestHeader.getHeader("Content-Type");
                        if (object3 != null && ((String)object3).equals("application/x-www-form-urlencoded")) {
                            jSONObject = API.getParams(((HttpMessage)object).getRequestBody().toString());
                        } else {
                            throw new ApiException(ApiException.Type.CONTENT_TYPE_NOT_SUPPORTED);
                        }
                    }
                    if (format.equals((Object)Format.JSONP)) {
                        if (!this.getOptionsParamApi().isEnableJSONP()) {
                            throw new ApiException(ApiException.Type.DISABLED);
                        }
                        if (!this.hasValidKey(httpRequestHeader, jSONObject)) {
                            throw new ApiException(ApiException.Type.BAD_API_KEY);
                        }
                    }
                    block10 : switch (requestType) {
                        case action: {
                            List<String> list;
                            if (!this.getOptionsParamApi().isDisableKey() && !this.hasValidKey(httpRequestHeader, jSONObject)) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiAction apiAction = apiImplementor3.getApiAction(string4);
                            if (apiAction != null && (list = apiAction.getMandatoryParamNames()) != null) {
                                for (String string5 : list) {
                                    if (jSONObject.has(string5) && jSONObject.getString(string5).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, string5);
                                }
                            }
                            if ((object3 = apiImplementor3.handleApiOptionAction(string4, jSONObject)) == null) {
                                object3 = apiImplementor3.handleApiAction(string4, jSONObject);
                            }
                            switch (format) {
                                case JSON: {
                                    string3 = ((ApiResponse)object3).toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    string3 = this.getJsonpWrapper(((ApiResponse)object3).toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    string3 = this.responseToXml(string4, (ApiResponse)object3);
                                    break block10;
                                }
                                case HTML: {
                                    string3 = this.responseToHtml(string4, (ApiResponse)object3);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case view: {
                            List<String> list;
                            if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(httpRequestHeader, jSONObject))) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiView apiView = apiImplementor3.getApiView(string4);
                            if (apiView != null && (list = apiView.getMandatoryParamNames()) != null) {
                                for (String string6 : list) {
                                    if (jSONObject.has(string6) && jSONObject.getString(string6).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, string6);
                                }
                            }
                            if ((object3 = apiImplementor3.handleApiOptionView(string4, jSONObject)) == null) {
                                object3 = apiImplementor3.handleApiView(string4, jSONObject);
                            }
                            switch (format) {
                                case JSON: {
                                    string3 = ((ApiResponse)object3).toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    string3 = this.getJsonpWrapper(((ApiResponse)object3).toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    string3 = this.responseToXml(string4, (ApiResponse)object3);
                                    break block10;
                                }
                                case HTML: {
                                    string3 = this.responseToHtml(string4, (ApiResponse)object3);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case other: {
                            ApiOther apiOther = apiImplementor3.getApiOther(string4);
                            if (apiOther != null) {
                                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() && !apiOther.isRequiresApiKey() || this.hasValidKey(httpRequestHeader, jSONObject))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                List<String> list = apiOther.getMandatoryParamNames();
                                if (list != null) {
                                    for (String string7 : list) {
                                        if (jSONObject.has(string7) && jSONObject.getString(string7).length() != 0) continue;
                                        throw new ApiException(ApiException.Type.MISSING_PARAMETER, string7);
                                    }
                                }
                            }
                            object = apiImplementor3.handleApiOther((HttpMessage)object, string4, jSONObject);
                        }
                    }
                } else {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    string3 = this.webUI.handleRequest(httpRequestHeader.getURI(), this.isEnabled());
                    format = Format.UI;
                    string2 = "text/html; charset=UTF-8";
                }
            }
            logger.debug((Object)("handleApiRequest returning: " + string3));
        }
        catch (Exception exception) {
            ApiException apiException;
            if (!this.getOptionsParamApi().isReportPermErrors() && exception instanceof ApiException && ((apiException = (ApiException)exception).getType().equals((Object)ApiException.Type.DISABLED) || apiException.getType().equals((Object)ApiException.Type.BAD_API_KEY))) {
                return true;
            }
            this.handleException((HttpMessage)object, format, string2, exception);
            bl2 = true;
        }
        if (!bl2 && !format.equals((Object)Format.OTHER) && apiImplementor2 == null) {
            ((HttpMessage)object).setResponseHeader(API.getDefaultResponseHeader(string2));
            ((HttpMessage)object).setResponseBody(string3);
            ((HttpMessage)object).getResponseHeader().setContentLength(((HttpMessage)object).getResponseBody().length());
        }
        if (apiImplementor3 != null) {
            apiImplementor3.addCustomHeaders(string4, requestType, (HttpMessage)object);
        }
        httpOutputStream.write(((HttpMessage)object).getResponseHeader());
        httpOutputStream.write(((HttpMessage)object).getResponseBody().getBytes());
        httpOutputStream.flush();
        httpOutputStream.close();
        httpInputStream.close();
        return true;
    }

    public String getBaseURL(Format format, String string, RequestType requestType, String string2, boolean bl) {
        String string3 = format.name() + "/" + string + "/" + requestType.name() + "/" + string2 + "/";
        String string4 = API_URL;
        if (this.getOptionsParamApi().isSecureOnly()) {
            string4 = API_URL_S;
        }
        if (!bl) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            string4 = this.getOptionsParamApi().isSecureOnly() ? "https://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/" : "http://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/";
        }
        if (!RequestType.view.equals((Object)requestType)) {
            return string4 + string3 + "/?" + API_NONCE_PARAM + "=" + this.getOneTimeNonce(string3) + "&";
        }
        return string4 + string3;
    }

    private String responseToHtml(String string, ApiResponse apiResponse) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<head>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        apiResponse.toHTML(stringBuilder);
        stringBuilder.append("</body>\n");
        return stringBuilder.toString();
    }

    private String responseToXml(String string, ApiResponse apiResponse) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            apiResponse.toXML(document, element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    public static JSONObject getParams(String string) throws ApiException {
        JSONObject jSONObject = new JSONObject();
        if (string == null || string.length() == 0) {
            return jSONObject;
        }
        String[] stringArray = patternParam.split(string);
        String string2 = null;
        String string3 = null;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = null;
            n = stringArray[i].indexOf(61);
            if (n > 0) {
                try {
                    string2 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                    string3 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                    jSONObject.put((Object)string2, (Object)string3);
                }
                catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                    ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, string, exception);
                    logger.error((Object)apiException.getMessage(), (Throwable)apiException);
                }
                continue;
            }
            ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, string);
            logger.error((Object)apiException.getMessage(), (Throwable)apiException);
        }
        return jSONObject;
    }

    private String getJsonpWrapper(String string) {
        return "zapJsonpResult (" + string + " )";
    }

    public Map<String, ApiImplementor> getImplementors() {
        return Collections.unmodifiableMap(this.implementors);
    }

    public String getCallBackUrl(ApiImplementor apiImplementor, String string) {
        String string2 = string + CALL_BACK_URL + this.random.nextLong();
        this.callBacks.put(string2, apiImplementor);
        return string2;
    }

    public String getOneTimeNonce(String string) {
        String string2 = Long.toHexString(this.random.nextLong());
        this.nonces.put(string2, new Nonce(string2, string, true));
        return string2;
    }

    public String getLongLivedNonce(String string) {
        String string2 = Long.toHexString(this.random.nextLong());
        this.nonces.put(string2, new Nonce(string2, string, false));
        return string2;
    }

    public boolean hasValidKey(HttpMessage httpMessage) {
        try {
            return this.hasValidKey(httpMessage.getRequestHeader(), API.getParams(httpMessage.getRequestHeader().getURI().getEscapedQuery()));
        }
        catch (ApiException apiException) {
            logger.error((Object)apiException.getMessage(), (Throwable)apiException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValidKey(HttpRequestHeader httpRequestHeader, JSONObject jSONObject) {
        try {
            Object object;
            String string;
            try {
                string = httpRequestHeader.getURI().getPath();
            }
            catch (URIException uRIException) {
                logger.error((Object)uRIException.getMessage(), (Throwable)uRIException);
                boolean bl = false;
                Map<String, Nonce> map = this.nonces;
                synchronized (map) {
                    for (Map.Entry<String, Nonce> entry : this.nonces.entrySet()) {
                        if (entry.getValue().isValid()) continue;
                        this.nonces.remove(entry.getKey());
                    }
                }
                return bl;
            }
            String string2 = httpRequestHeader.getHeader("X-ZAP-API-Nonce");
            if (string2 == null && jSONObject.has(API_NONCE_PARAM)) {
                string2 = jSONObject.getString(API_NONCE_PARAM);
            }
            if (string2 != null) {
                object = this.nonces.get(string2);
                if (object == null) {
                    logger.warn((Object)("API nonce " + string2 + " not found in request from " + httpRequestHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
                if (((Nonce)object).isOneTime()) {
                    this.nonces.remove(string2);
                }
                if (!((Nonce)object).isValid()) {
                    logger.warn((Object)("API nonce " + ((Nonce)object).getNonceKey() + " expired at " + ((Nonce)object).getExpires().toString() + " in request from " + httpRequestHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
                if (!string.equals(((Nonce)object).getApiPath())) {
                    logger.warn((Object)("API nonce path was " + ((Nonce)object).getApiPath() + " but call was for " + string + " in request from " + httpRequestHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
            } else {
                object = httpRequestHeader.getHeader("X-ZAP-API-Key");
                if (object == null && jSONObject.has(API_KEY_PARAM)) {
                    object = jSONObject.getString(API_KEY_PARAM);
                }
                if (!this.getOptionsParamApi().getKey().equals(object)) {
                    logger.warn((Object)("API key incorrect or not supplied: " + (String)object + " in request from " + httpRequestHeader.getSenderAddress().getHostAddress()));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Map<String, Nonce> map = this.nonces;
            synchronized (map) {
                for (Map.Entry<String, Nonce> entry : this.nonces.entrySet()) {
                    if (entry.getValue().isValid()) continue;
                    this.nonces.remove(entry.getKey());
                }
            }
        }
    }

    public static String getDefaultResponseHeader(String string) {
        return API.getDefaultResponseHeader(string, 0);
    }

    public static String getDefaultResponseHeader(String string, int n) {
        return API.getDefaultResponseHeader(STATUS_OK, string, n, false);
    }

    public static String getDefaultResponseHeader(String string, int n, boolean bl) {
        return API.getDefaultResponseHeader(STATUS_OK, string, n, bl);
    }

    public static String getDefaultResponseHeader(String string, String string2, int n) {
        return API.getDefaultResponseHeader(string, string2, n, false);
    }

    public static String getDefaultResponseHeader(String string, String string2, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("HTTP/1.1 ").append(string).append("\r\n");
        if (!bl) {
            stringBuilder.append("Pragma: no-cache\r\n");
            stringBuilder.append("Cache-Control: no-cache\r\n");
        }
        stringBuilder.append("Content-Security-Policy: default-src 'none'; script-src 'self'; connect-src 'self'; child-src 'self'; img-src 'self' data:; font-src 'self' data:; style-src 'self'\r\n");
        stringBuilder.append("Referrer-Policy: no-referrer\r\n");
        stringBuilder.append("Access-Control-Allow-Methods: GET,POST,OPTIONS\r\n");
        stringBuilder.append("Access-Control-Allow-Headers: ZAP-Header\r\n");
        stringBuilder.append("X-Frame-Options: DENY\r\n");
        stringBuilder.append("X-XSS-Protection: 1; mode=block\r\n");
        stringBuilder.append("X-Content-Type-Options: nosniff\r\n");
        stringBuilder.append("X-Clacks-Overhead: GNU Terry Pratchett\r\n");
        stringBuilder.append("Content-Length: ").append(n).append("\r\n");
        stringBuilder.append("Content-Type: ").append(string2).append("\r\n");
        return stringBuilder.toString();
    }

    private void handleException(HttpMessage httpMessage, Format format, String string, Exception exception) {
        String string2 = STATUS_INTERNAL_SERVER_ERROR;
        if (format == Format.OTHER) {
            boolean bl = true;
            if (exception instanceof ApiException) {
                switch (((ApiException)exception).getType()) {
                    case DISABLED: {
                        string2 = STATUS_BAD_REQUEST;
                        logger.warn((Object)"ApiException while handling API request:", (Throwable)exception);
                        bl = false;
                        break;
                    }
                    case BAD_TYPE: 
                    case NO_IMPLEMENTOR: 
                    case BAD_API_KEY: 
                    case MISSING_PARAMETER: 
                    case BAD_ACTION: 
                    case BAD_VIEW: 
                    case BAD_OTHER: {
                        string2 = STATUS_BAD_REQUEST;
                        logger.warn((Object)"API 'other' malformed request:", (Throwable)exception);
                        bl = false;
                        break;
                    }
                }
            }
            if (bl) {
                logger.error((Object)"API 'other' endpoint didn't handle exception:", (Throwable)exception);
            }
        } else {
            ApiException apiException;
            if (exception instanceof ApiException) {
                apiException = (ApiException)exception;
                if (!ApiException.Type.INTERNAL_ERROR.equals((Object)apiException.getType())) {
                    string2 = STATUS_BAD_REQUEST;
                    logger.warn((Object)"ApiException while handling API request:", (Throwable)exception);
                }
            } else {
                apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)exception);
                logger.error((Object)"Exception while handling API request:", (Throwable)exception);
            }
            String string3 = apiException.toString(format, this.getOptionsParamApi().isIncErrorDetails());
            httpMessage.getResponseBody().setCharset(API.getCharset(string));
            httpMessage.getResponseBody().setBody(string3);
        }
        try {
            httpMessage.setResponseHeader(API.getDefaultResponseHeader(string2, string, httpMessage.getResponseBody().length()));
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.warn((Object)"Failed to build API error response:", (Throwable)httpMalformedHeaderException);
        }
    }

    private static String getCharset(String string) {
        int n = string.indexOf("charset=");
        if (n == -1) {
            return "UTF-8";
        }
        return string.substring(n + 8);
    }

    private class Nonce {
        private final String nonceKey;
        private final String apiPath;
        private final boolean oneTime;
        private final Date expires;

        public Nonce(String string, String string2, boolean bl) {
            this.nonceKey = string;
            this.apiPath = string2;
            this.oneTime = bl;
            this.expires = DateUtils.addSeconds((Date)new Date(), (int)API.this.getOptionsParamApi().getNonceTimeToLiveInSecs());
        }

        public String getNonceKey() {
            return this.nonceKey;
        }

        public String getApiPath() {
            return this.apiPath;
        }

        public boolean isOneTime() {
            return this.oneTime;
        }

        public boolean isValid() {
            return !this.oneTime || this.expires.after(new Date());
        }

        public Date getExpires() {
            return this.expires;
        }
    }

    public static enum RequestType {
        action,
        view,
        other;

    }

    public static enum Format {
        XML,
        HTML,
        JSON,
        JSONP,
        UI,
        OTHER;

    }
}

