/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ActiveScanAPI
extends ApiImplementor {
    private static Logger log = Logger.getLogger(ActiveScanAPI.class);
    private static final String PREFIX = "ascan";
    private static final String ACTION_SCAN = "scan";
    private static final String ACTION_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String ACTION_ENABLE_ALL_SCANNERS = "enableAllScanners";
    private static final String ACTION_DISABLE_ALL_SCANNERS = "disableAllScanners";
    private static final String ACTION_ENABLE_SCANNERS = "enableScanners";
    private static final String ACTION_DISABLE_SCANNERS = "disableScanners";
    private static final String ACTION_SET_ENABLED_POLICIES = "setEnabledPolicies";
    private static final String ACTION_SET_POLICY_ATTACK_STRENGTH = "setPolicyAttackStrength";
    private static final String ACTION_SET_POLICY_ALERT_THRESHOLD = "setPolicyAlertThreshold";
    private static final String ACTION_SET_SCANNER_ATTACK_STRENGTH = "setScannerAttackStrength";
    private static final String ACTION_SET_SCANNER_ALERT_THRESHOLD = "setScannerAlertThreshold";
    private static final String ACTION_ADD_SCAN_POLICY = "addScanPolicy";
    private static final String ACTION_REMOVE_SCAN_POLICY = "removeScanPolicy";
    private static final String ACTION_UPDATE_SCAN_POLICY = "updateScanPolicy";
    private static final String ACTION_ADD_EXCLUDED_PARAM = "addExcludedParam";
    private static final String ACTION_MODIFY_EXCLUDED_PARAM = "modifyExcludedParam";
    private static final String ACTION_REMOVE_EXCLUDED_PARAM = "removeExcludedParam";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_SCANS = "scans";
    private static final String VIEW_MESSAGES_IDS = "messagesIds";
    private static final String VIEW_ALERTS_IDS = "alertsIds";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private static final String VIEW_SCANNERS = "scanners";
    private static final String VIEW_POLICIES = "policies";
    private static final String VIEW_SCAN_POLICY_NAMES = "scanPolicyNames";
    private static final String VIEW_ATTACK_MODE_QUEUE = "attackModeQueue";
    private static final String VIEW_SCAN_PROGRESS = "scanProgress";
    private static final String VIEW_EXCLUDED_PARAMS = "excludedParams";
    private static final String VIEW_OPTION_EXCLUDED_PARAM_LIST = "optionExcludedParamList";
    private static final String VIEW_EXCLUDED_PARAM_TYPES = "excludedParamTypes";
    private static final String PARAM_URL = "url";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_JUST_IN_SCOPE = "inScopeOnly";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ATTACK_STRENGTH = "attackStrength";
    private static final String PARAM_ALERT_THRESHOLD = "alertThreshold";
    private static final String PARAM_SCAN_POLICY_NAME = "scanPolicyName";
    private static final String PARAM_CATEGORY_ID = "policyId";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_NAME = "name";
    private ExtensionActiveScan controller = null;

    public ActiveScanAPI(ExtensionActiveScan extensionActiveScan) {
        this.controller = extensionActiveScan;
        this.addApiAction(new ApiAction(ACTION_SCAN, null, new String[]{PARAM_URL, PARAM_RECURSE, PARAM_JUST_IN_SCOPE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA, PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SCAN_AS_USER, null, new String[]{PARAM_URL, PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_RECURSE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED_POLICIES, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ADD_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}, new String[]{PARAM_ALERT_THRESHOLD, PARAM_ATTACK_STRENGTH}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_UPDATE_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}, new String[]{PARAM_ALERT_THRESHOLD, PARAM_ATTACK_STRENGTH}));
        this.addApiAction(new ApiAction(ACTION_ADD_EXCLUDED_PARAM, new String[]{PARAM_NAME}, new String[]{PARAM_TYPE, PARAM_URL}));
        this.addApiAction(new ApiAction(ACTION_MODIFY_EXCLUDED_PARAM, new String[]{PARAM_IDX}, new String[]{PARAM_NAME, PARAM_TYPE, PARAM_URL}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_EXCLUDED_PARAM, new String[]{PARAM_IDX}));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCAN_PROGRESS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_SCAN_POLICY_NAMES));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
        this.addApiView(new ApiView(VIEW_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_POLICIES, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_ATTACK_MODE_QUEUE));
        this.addApiView(new ApiView(VIEW_EXCLUDED_PARAMS));
        ApiView apiView = new ApiView(VIEW_OPTION_EXCLUDED_PARAM_LIST);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
        this.addApiView(new ApiView(VIEW_EXCLUDED_PARAM_TYPES));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        User user = null;
        Context context = null;
        try {
            switch (string) {
                case "scanAsUser": {
                    this.validateParamExists(jSONObject, PARAM_CONTEXT_ID);
                    this.validateParamExists(jSONObject, PARAM_USER_ID);
                    int n = ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
                    ExtensionUserManagement extensionUserManagement = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                    if (extensionUserManagement == null) {
                        throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                    }
                    context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                    if (!context.isIncluded(jSONObject.getString(PARAM_URL))) {
                        throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_CONTEXT_ID);
                    }
                    user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(n);
                    if (user == null) {
                        throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                    }
                }
                case "scan": {
                    String string2 = ApiUtils.getOptionalStringParam(jSONObject, PARAM_URL);
                    if (context == null && jSONObject.has(PARAM_CONTEXT_ID) && !jSONObject.getString(PARAM_CONTEXT_ID).isEmpty()) {
                        context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                    }
                    boolean bl = context != null ? false : this.getParam(jSONObject, PARAM_JUST_IN_SCOPE, false);
                    String string3 = null;
                    ScanPolicy scanPolicy = null;
                    try {
                        string3 = jSONObject.getString(PARAM_SCAN_POLICY_NAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (string3 != null && string3.length() > 0) {
                            log.debug((Object)("handleApiAction scan policy =" + string3));
                            scanPolicy = this.controller.getPolicyManager().getPolicy(string3);
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
                    }
                    String string4 = this.getParam(jSONObject, PARAM_METHOD, "GET");
                    if (string4.trim().length() == 0) {
                        string4 = "GET";
                    }
                    if (!Arrays.asList(HttpRequestHeader.METHODS).contains(string4)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_METHOD);
                    }
                    int n = this.scanURL(string2, user, this.getParam(jSONObject, PARAM_RECURSE, true), bl, string4, this.getParam(jSONObject, PARAM_POST_DATA, ""), scanPolicy, context);
                    return new ApiResponseElement(string, Integer.toString(n));
                }
                case "pause": {
                    this.getActiveScan(jSONObject).pauseScan();
                    break;
                }
                case "resume": {
                    this.getActiveScan(jSONObject).resumeScan();
                    break;
                }
                case "stop": {
                    this.getActiveScan(jSONObject).stopScan();
                    break;
                }
                case "removeScan": {
                    ActiveScan activeScan = this.controller.removeScan(jSONObject.getInt(PARAM_SCAN_ID));
                    if (activeScan == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                    }
                    break;
                }
                case "pauseAllScans": {
                    this.controller.pauseAllScans();
                    break;
                }
                case "resumeAllScans": {
                    this.controller.resumeAllScans();
                    break;
                }
                case "stopAllScans": {
                    this.controller.stopAllScans();
                    break;
                }
                case "removeAllScans": {
                    this.controller.removeAllScans();
                    break;
                }
                case "clearExcludedFromScan": {
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.setExcludeFromScanRegexs(new ArrayList<String>());
                        break;
                    }
                    catch (DatabaseException databaseException) {
                        log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                    }
                }
                case "excludeFromScan": {
                    String string5 = jSONObject.getString(PARAM_REGEX);
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.addExcludeFromScanRegexs(string5);
                        break;
                    }
                    catch (DatabaseException databaseException) {
                        log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                    }
                }
                case "enableAllScanners": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    scanPolicy.getPluginFactory().setAllPluginEnabled(true);
                    scanPolicy.save();
                    break;
                }
                case "disableAllScanners": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    scanPolicy.getPluginFactory().setAllPluginEnabled(false);
                    scanPolicy.save();
                    break;
                }
                case "enableScanners": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    this.setScannersEnabled(scanPolicy, this.getParam(jSONObject, PARAM_IDS, "").split(","), true);
                    scanPolicy.save();
                    break;
                }
                case "disableScanners": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    this.setScannersEnabled(scanPolicy, this.getParam(jSONObject, PARAM_IDS, "").split(","), false);
                    scanPolicy.save();
                    break;
                }
                case "setEnabledPolicies": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    this.setEnabledPolicies(scanPolicy, this.getParam(jSONObject, PARAM_IDS, "").split(","));
                    scanPolicy.save();
                    break;
                }
                case "setPolicyAttackStrength": {
                    int n = this.getPolicyIdFromParamId(jSONObject);
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    Plugin.AttackStrength attackStrength = this.getAttackStrengthFromParamAttack(jSONObject);
                    for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
                        if (plugin.getCategory() != n) continue;
                        plugin.setAttackStrength(attackStrength);
                    }
                    scanPolicy.save();
                    break;
                }
                case "setPolicyAlertThreshold": {
                    int n = this.getPolicyIdFromParamId(jSONObject);
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    Plugin.AlertThreshold alertThreshold = this.getAlertThresholdFromParamAlertThreshold(jSONObject);
                    for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
                        if (plugin.getCategory() != n) continue;
                        plugin.setAlertThreshold(alertThreshold);
                    }
                    scanPolicy.save();
                    break;
                }
                case "setScannerAttackStrength": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    Plugin plugin = this.getScannerFromParamId(scanPolicy, jSONObject);
                    plugin.setAttackStrength(this.getAttackStrengthFromParamAttack(jSONObject));
                    scanPolicy.save();
                    break;
                }
                case "setScannerAlertThreshold": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    Plugin.AlertThreshold alertThreshold = this.getAlertThresholdFromParamAlertThreshold(jSONObject);
                    this.getScannerFromParamId(scanPolicy, jSONObject).setAlertThreshold(alertThreshold);
                    scanPolicy.save();
                    break;
                }
                case "addScanPolicy": {
                    String string6 = jSONObject.getString(PARAM_SCAN_POLICY_NAME);
                    if (this.controller.getPolicyManager().getAllPolicyNames().contains(string6)) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, PARAM_SCAN_POLICY_NAME);
                    }
                    if (!this.controller.getPolicyManager().isLegalPolicyName(string6)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SCAN_POLICY_NAME);
                    }
                    ScanPolicy scanPolicy = this.controller.getPolicyManager().getTemplatePolicy();
                    scanPolicy.setName(string6);
                    this.setAlertThreshold(scanPolicy, jSONObject);
                    this.setAttackStrength(scanPolicy, jSONObject);
                    this.controller.getPolicyManager().savePolicy(scanPolicy);
                    break;
                }
                case "removeScanPolicy": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    if (this.controller.getPolicyManager().getAllPolicyNames().size() == 1) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "You are not allowed to remove the last scan policy");
                    }
                    this.controller.getPolicyManager().deletePolicy(scanPolicy.getName());
                    break;
                }
                case "updateScanPolicy": {
                    ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                    if (!this.isParamsChanged(scanPolicy, jSONObject)) break;
                    this.updateAlertThreshold(scanPolicy, jSONObject);
                    this.updateAttackStrength(scanPolicy, jSONObject);
                    this.controller.getPolicyManager().savePolicy(scanPolicy);
                    break;
                }
                case "addExcludedParam": {
                    int n = this.getParam(jSONObject, PARAM_TYPE, -1);
                    if (!ScannerParamFilter.getTypes().containsKey(n)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_TYPE);
                    }
                    String string7 = this.getParam(jSONObject, PARAM_URL, "*");
                    if (string7.isEmpty()) {
                        string7 = "*";
                    }
                    ScannerParamFilter scannerParamFilter = new ScannerParamFilter(jSONObject.getString(PARAM_NAME), n, string7);
                    ArrayList<ScannerParamFilter> arrayList = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                    arrayList.add(scannerParamFilter);
                    this.controller.getScannerParam().setExcludedParamList(arrayList);
                    break;
                }
                case "modifyExcludedParam": {
                    try {
                        ScannerParamFilter scannerParamFilter;
                        int n = jSONObject.getInt(PARAM_IDX);
                        if (n < 0 || n >= this.controller.getScannerParam().getExcludedParamList().size()) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                        }
                        ScannerParamFilter scannerParamFilter2 = this.controller.getScannerParam().getExcludedParamList().get(n);
                        String string8 = this.getParam(jSONObject, PARAM_NAME, scannerParamFilter2.getParamName());
                        if (string8.isEmpty()) {
                            string8 = scannerParamFilter2.getParamName();
                        }
                        int n2 = this.getParam(jSONObject, PARAM_TYPE, scannerParamFilter2.getType());
                        if (!ScannerParamFilter.getTypes().containsKey(n2)) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_TYPE);
                        }
                        String string9 = this.getParam(jSONObject, PARAM_URL, scannerParamFilter2.getWildcardedUrl());
                        if (string9.isEmpty()) {
                            string9 = "*";
                        }
                        if (scannerParamFilter2.equals(scannerParamFilter = new ScannerParamFilter(string8, n2, string9))) break;
                        ArrayList<ScannerParamFilter> arrayList = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                        arrayList.set(n, scannerParamFilter);
                        this.controller.getScannerParam().setExcludedParamList(arrayList);
                        break;
                    }
                    catch (JSONException jSONException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, jSONException);
                    }
                }
                case "removeExcludedParam": {
                    try {
                        int n = jSONObject.getInt(PARAM_IDX);
                        if (n < 0 || n >= this.controller.getScannerParam().getExcludedParamList().size()) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                        }
                        ArrayList<ScannerParamFilter> arrayList = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                        arrayList.remove(n);
                        this.controller.getScannerParam().setExcludedParamList(arrayList);
                        break;
                    }
                    catch (JSONException jSONException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, jSONException);
                    }
                }
                default: {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, configurationException.getMessage());
        }
        return ApiResponseElement.OK;
    }

    private void setAlertThreshold(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (this.isParamExists(jSONObject, PARAM_ALERT_THRESHOLD)) {
            scanPolicy.setDefaultThreshold(this.getAlertThresholdFromParamAlertThreshold(jSONObject));
        }
    }

    private void setAttackStrength(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (this.isParamExists(jSONObject, PARAM_ATTACK_STRENGTH)) {
            scanPolicy.setDefaultStrength(this.getAttackStrengthFromParamAttack(jSONObject));
        }
    }

    private boolean isParamsChanged(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        return this.isAlertThresholdChanged(scanPolicy, jSONObject) || this.isAttackStrengthChanged(scanPolicy, jSONObject);
    }

    private boolean isAlertThresholdChanged(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (!this.isParamExists(jSONObject, PARAM_ALERT_THRESHOLD)) {
            return false;
        }
        Plugin.AlertThreshold alertThreshold = this.getAlertThresholdFromParamAlertThreshold(jSONObject);
        Plugin.AlertThreshold alertThreshold2 = scanPolicy.getDefaultThreshold();
        return !alertThreshold2.equals((Object)alertThreshold);
    }

    private boolean isAttackStrengthChanged(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (!this.isParamExists(jSONObject, PARAM_ATTACK_STRENGTH)) {
            return false;
        }
        Plugin.AttackStrength attackStrength = this.getAttackStrengthFromParamAttack(jSONObject);
        Plugin.AttackStrength attackStrength2 = scanPolicy.getDefaultStrength();
        return !attackStrength2.equals((Object)attackStrength);
    }

    private void updateAlertThreshold(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (this.isAlertThresholdChanged(scanPolicy, jSONObject)) {
            scanPolicy.setDefaultThreshold(this.getAlertThresholdFromParamAlertThreshold(jSONObject));
        }
    }

    private void updateAttackStrength(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        if (this.isAttackStrengthChanged(scanPolicy, jSONObject)) {
            scanPolicy.setDefaultStrength(this.getAttackStrengthFromParamAttack(jSONObject));
        }
    }

    private boolean isParamExists(JSONObject jSONObject, String string) {
        return jSONObject.has(string) && StringUtils.isNotBlank((String)jSONObject.getString(string));
    }

    private ScanPolicy getScanPolicyFromParams(JSONObject jSONObject) throws ApiException {
        String string = null;
        try {
            string = jSONObject.getString(PARAM_SCAN_POLICY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            return this.controller.getPolicyManager().getDefaultScanPolicy();
        }
        try {
            return this.controller.getPolicyManager().getPolicy(string);
        }
        catch (ConfigurationException configurationException) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
        }
    }

    private ActiveScan getActiveScan(JSONObject jSONObject) throws ApiException {
        int n = this.getParam(jSONObject, PARAM_SCAN_ID, -1);
        ActiveScan activeScan = null;
        activeScan = n == -1 ? this.controller.getLastScan() : this.controller.getScan(n);
        if (activeScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return activeScan;
    }

    private void setScannersEnabled(ScanPolicy scanPolicy, String[] stringArray, boolean bl) throws ConfigurationException, ApiException {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                try {
                    Plugin plugin = scanPolicy.getPluginFactory().getPlugin(Integer.valueOf(string.trim()));
                    if (plugin == null) continue;
                    plugin.setEnabled(bl);
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn((Object)"Failed to parse scanner ID: ", (Throwable)numberFormatException);
                }
            }
        }
    }

    private void setEnabledPolicies(ScanPolicy scanPolicy, String[] stringArray) {
        scanPolicy.getPluginFactory().setAllPluginEnabled(false);
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                try {
                    int n = Integer.valueOf(string.trim());
                    if (!ActiveScanAPI.hasPolicyWithId(n)) continue;
                    for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
                        if (plugin.getCategory() != n) continue;
                        plugin.setEnabled(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn((Object)"Failed to parse policy ID: ", (Throwable)numberFormatException);
                }
            }
        }
    }

    private static boolean hasPolicyWithId(int n) {
        return Arrays.asList(Category.getAllNames()).contains(Category.getName(n));
    }

    private int getPolicyIdFromParamId(JSONObject jSONObject) throws ApiException {
        int n = this.getParam(jSONObject, PARAM_ID, -1);
        if (n == -1) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
        }
        if (!ActiveScanAPI.hasPolicyWithId(n)) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
        }
        return n;
    }

    private Plugin.AttackStrength getAttackStrengthFromParamAttack(JSONObject jSONObject) throws ApiException {
        String string = jSONObject.getString(PARAM_ATTACK_STRENGTH).trim().toUpperCase();
        try {
            return Plugin.AttackStrength.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ATTACK_STRENGTH);
        }
    }

    private Plugin.AlertThreshold getAlertThresholdFromParamAlertThreshold(JSONObject jSONObject) throws ApiException {
        String string = jSONObject.getString(PARAM_ALERT_THRESHOLD).trim().toUpperCase();
        try {
            return Plugin.AlertThreshold.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ALERT_THRESHOLD);
        }
    }

    private Plugin getScannerFromParamId(ScanPolicy scanPolicy, JSONObject jSONObject) throws ApiException {
        int n = this.getParam(jSONObject, PARAM_ID, -1);
        if (n == -1) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
        }
        Plugin plugin = scanPolicy.getPluginFactory().getPlugin(n);
        if (plugin == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
        }
        return plugin;
    }

    private int scanURL(String string, User user, boolean bl, boolean bl2, String string2, String string3, ScanPolicy scanPolicy, Context context) throws ApiException {
        Object[] objectArray;
        Object object;
        boolean bl3 = true;
        if (string == null || string.isEmpty()) {
            if (context == null || !context.hasNodesInContextFromSiteTree()) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_URL);
            }
            bl3 = false;
        } else if (context != null && !context.isInContext(string)) {
            throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_URL);
        }
        StructuralNode structuralNode = null;
        if (bl3) {
            try {
                object = new URI(string, true);
            }
            catch (URIException uRIException) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            objectArray = object.getScheme();
            if (objectArray == null || !objectArray.equalsIgnoreCase("http") && !objectArray.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            try {
                long l = Model.getSingleton().getSession().getSessionId();
                structuralNode = SessionStructure.find(l, (URI)object, string2, string3);
                if (structuralNode == null && "GET".equalsIgnoreCase(string2)) {
                    structuralNode = SessionStructure.find(l, (URI)object, null, string3);
                }
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)exception);
            }
            if (structuralNode == null) {
                throw new ApiException(ApiException.Type.URL_NOT_FOUND);
            }
        }
        if (bl3) {
            object = new Target(structuralNode);
            ((Target)object).setContext(context);
        } else {
            object = new Target(context);
        }
        ((Target)object).setRecurse(bl);
        ((Target)object).setInScopeOnly(bl2);
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case protect: {
                if ((!bl3 || Model.getSingleton().getSession().isInScope(string)) && (context == null || context.isInScope())) break;
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case standard: {
                break;
            }
        }
        objectArray = new Object[]{};
        if (scanPolicy != null) {
            objectArray = new Object[]{scanPolicy};
        }
        return this.controller.startScan(null, (Target)object, user, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        ActiveScan activeScan = null;
        switch (string) {
            case "status": {
                activeScan = this.getActiveScan(jSONObject);
                int n = 0;
                if (activeScan != null) {
                    n = activeScan.getProgress();
                }
                apiResponse = new ApiResponseElement(string, String.valueOf(n));
                break;
            }
            case "scans": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (GenericScanner2 genericScanner2 : this.controller.getAllScans()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(PARAM_ID, Integer.toString(genericScanner2.getScanId()));
                    hashMap.put("progress", Integer.toString(genericScanner2.getProgress()));
                    hashMap.put("state", ((ActiveScan)genericScanner2).getState().name());
                    apiResponseList.addItem(new ApiResponseSet(ACTION_SCAN, hashMap));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "scanProgress": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                activeScan = this.getActiveScan(jSONObject);
                if (activeScan != null) {
                    for (HostProcess hostProcess : activeScan.getHostProcesses()) {
                        ApiResponseList apiResponseList2 = new ApiResponseList("HostProcess");
                        apiResponseList.addItem(new ApiResponseElement(PARAM_ID, XMLStringUtil.escapeControlChrs(hostProcess.getHostAndPort())));
                        for (Plugin plugin : hostProcess.getCompleted()) {
                            long l = plugin.getTimeFinished().getTime() - plugin.getTimeStarted().getTime();
                            int n = hostProcess.getPluginRequestCount(plugin.getId());
                            if (hostProcess.isSkipped(plugin)) {
                                String string2 = hostProcess.getSkippedReason(plugin);
                                string2 = string2 == null ? Constant.messages.getString("ascan.progress.label.skipped") : Constant.messages.getString("ascan.progress.label.skippedWithReason", string2);
                                apiResponseList2.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, string2, l, n));
                                continue;
                            }
                            apiResponseList2.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, "Complete", l, n));
                        }
                        for (Plugin plugin : hostProcess.getRunning()) {
                            int n = hostProcess.getTestCurrentCount(plugin) * 100 / hostProcess.getTestTotalCount();
                            if (n >= 100) {
                                n = 99;
                            }
                            long l = new Date().getTime() - plugin.getTimeStarted().getTime();
                            int n2 = hostProcess.getPluginRequestCount(plugin.getId());
                            apiResponseList2.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, n + "%", l, n2));
                        }
                        for (Plugin plugin : hostProcess.getPending()) {
                            if (hostProcess.isSkipped(plugin)) {
                                String string3 = hostProcess.getSkippedReason(plugin);
                                string3 = string3 == null ? Constant.messages.getString("ascan.progress.label.skipped") : Constant.messages.getString("ascan.progress.label.skippedWithReason", string3);
                                apiResponseList2.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, string3, 0L, 0));
                                continue;
                            }
                            apiResponseList2.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, "Pending", 0L, 0));
                        }
                        apiResponseList.addItem(apiResponseList2);
                    }
                }
                apiResponse = apiResponseList;
                break;
            }
            case "messagesIds": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                activeScan = this.getActiveScan(jSONObject);
                if (activeScan != null) {
                    List<Integer> list = activeScan.getMessagesIds();
                    synchronized (list) {
                        for (Integer n : activeScan.getMessagesIds()) {
                            apiResponseList.addItem(new ApiResponseElement(PARAM_ID, n.toString()));
                        }
                    }
                }
                apiResponse = apiResponseList;
                break;
            }
            case "alertsIds": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                activeScan = this.getActiveScan(jSONObject);
                if (activeScan != null) {
                    List<Integer> list = activeScan.getAlertsIds();
                    synchronized (list) {
                        for (Integer n : activeScan.getAlertsIds()) {
                            apiResponseList.addItem(new ApiResponseElement(PARAM_ID, n.toString()));
                        }
                    }
                }
                apiResponse = apiResponseList;
                break;
            }
            case "excludedFromScan": {
                apiResponse = new ApiResponseList(string);
                Session session = Model.getSingleton().getSession();
                List<String> list = session.getExcludeFromScanRegexs();
                for (String string4 : list) {
                    ((ApiResponseList)apiResponse).addItem(new ApiResponseElement(PARAM_REGEX, string4));
                }
                break;
            }
            case "scanners": {
                ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                List<Plugin> list = scanPolicy.getPluginFactory().getAllPlugin();
                int n = this.getParam(jSONObject, PARAM_CATEGORY_ID, -1);
                if (n != -1 && !ActiveScanAPI.hasPolicyWithId(n)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_CATEGORY_ID);
                }
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (Plugin plugin : list) {
                    if (n != -1 && n != plugin.getCategory()) continue;
                    apiResponseList.addItem(new ScannerApiResponse(scanPolicy, plugin));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "policies": {
                ScanPolicy scanPolicy = this.getScanPolicyFromParams(jSONObject);
                String[] stringArray = Category.getAllNames();
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (String string5 : stringArray) {
                    int n = Category.getCategory(string5);
                    Plugin.AttackStrength attackStrength = this.getPolicyAttackStrength(scanPolicy, n);
                    Plugin.AlertThreshold alertThreshold = this.getPolicyAlertThreshold(scanPolicy, n);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(PARAM_ID, String.valueOf(n));
                    hashMap.put(PARAM_NAME, string5);
                    hashMap.put(PARAM_ATTACK_STRENGTH, attackStrength == null ? "" : String.valueOf((Object)attackStrength));
                    hashMap.put(PARAM_ALERT_THRESHOLD, alertThreshold == null ? "" : String.valueOf((Object)alertThreshold));
                    hashMap.put("enabled", String.valueOf(this.isPolicyEnabled(scanPolicy, n)));
                    apiResponseList.addItem(new ApiResponseSet("policy", hashMap));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "scanPolicyNames": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (String string6 : this.controller.getPolicyManager().getAllPolicyNames()) {
                    apiResponseList.addItem(new ApiResponseElement("policy", string6));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "attackModeQueue": {
                apiResponse = new ApiResponseElement(string, String.valueOf(this.controller.getAttackModeStackSize()));
                break;
            }
            case "optionExcludedParamList": 
            case "excludedParams": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                List<ScannerParamFilter> list = this.controller.getScannerParam().getExcludedParamList();
                for (int i = 0; i < list.size(); ++i) {
                    apiResponseList.addItem(new ExcludedParamApiResponse(list.get(i), i));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "excludedParamTypes": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (Map.Entry<Integer, String> entry : ScannerParamFilter.getTypes().entrySet()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(PARAM_ID, Integer.toString(entry.getKey()));
                    hashMap.put(PARAM_NAME, entry.getValue());
                    apiResponseList.addItem(new ApiResponseSet(PARAM_TYPE, hashMap));
                }
                apiResponse = apiResponseList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return apiResponse;
    }

    private static ApiResponseList createPluginProgressEntry(Plugin plugin, String string, long l, int n) {
        ApiResponseList apiResponseList = new ApiResponseList("Plugin");
        apiResponseList.addItem(new ApiResponseElement(PARAM_NAME, XMLStringUtil.escapeControlChrs(plugin.getName())));
        apiResponseList.addItem(new ApiResponseElement(PARAM_ID, Integer.toString(plugin.getId())));
        apiResponseList.addItem(new ApiResponseElement("quality", plugin.getStatus().toString()));
        apiResponseList.addItem(new ApiResponseElement(VIEW_STATUS, string));
        apiResponseList.addItem(new ApiResponseElement("timeInMs", Long.toString(l)));
        apiResponseList.addItem(new ApiResponseElement("reqCount", Integer.toString(n)));
        return apiResponseList;
    }

    private boolean isPolicyEnabled(ScanPolicy scanPolicy, int n) {
        for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
            if (plugin.getCategory() != n || plugin.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private Plugin.AttackStrength getPolicyAttackStrength(ScanPolicy scanPolicy, int n) {
        Plugin.AttackStrength attackStrength = null;
        for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
            if (plugin.getCategory() != n) continue;
            if (attackStrength == null) {
                attackStrength = plugin.getAttackStrength(true);
                continue;
            }
            if (attackStrength.equals((Object)plugin.getAttackStrength(true))) continue;
            return null;
        }
        return attackStrength;
    }

    private Plugin.AlertThreshold getPolicyAlertThreshold(ScanPolicy scanPolicy, int n) {
        Plugin.AlertThreshold alertThreshold = null;
        for (Plugin plugin : scanPolicy.getPluginFactory().getAllPlugin()) {
            if (plugin.getCategory() != n) continue;
            if (alertThreshold == null) {
                alertThreshold = plugin.getAlertThreshold(true);
                continue;
            }
            if (alertThreshold.equals((Object)plugin.getAlertThreshold(true))) continue;
            return null;
        }
        return alertThreshold;
    }

    private class ScannerApiResponse
    extends ApiResponse {
        final Map<String, String> scannerData;
        final ApiResponseList dependencies;

        public ScannerApiResponse(ScanPolicy scanPolicy, Plugin plugin) {
            super("scanner");
            this.scannerData = new HashMap<String, String>();
            this.scannerData.put(ActiveScanAPI.PARAM_ID, String.valueOf(plugin.getId()));
            this.scannerData.put(ActiveScanAPI.PARAM_NAME, plugin.getName());
            this.scannerData.put("cweId", String.valueOf(plugin.getCweId()));
            this.scannerData.put("wascId", String.valueOf(plugin.getWascId()));
            this.scannerData.put(ActiveScanAPI.PARAM_ATTACK_STRENGTH, String.valueOf((Object)plugin.getAttackStrength(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_ALERT_THRESHOLD, String.valueOf((Object)plugin.getAlertThreshold(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_CATEGORY_ID, String.valueOf(plugin.getCategory()));
            this.scannerData.put("enabled", String.valueOf(plugin.isEnabled()));
            this.scannerData.put("quality", plugin.getStatus().toString());
            boolean bl = scanPolicy.getPluginFactory().hasAllDependenciesAvailable(plugin);
            this.scannerData.put("allDependenciesAvailable", Boolean.toString(bl));
            this.dependencies = new ApiResponseList("dependencies");
            for (Plugin plugin2 : scanPolicy.getPluginFactory().getDependencies(plugin)) {
                this.dependencies.addItem(new ApiResponseElement("dependency", Integer.toString(plugin2.getId())));
            }
        }

        @Override
        public void toXML(Document document, Element element) {
            element.setAttribute(ActiveScanAPI.PARAM_TYPE, "set");
            for (Map.Entry<String, String> entry : this.scannerData.entrySet()) {
                Element element2 = document.createElement(entry.getKey());
                element2.appendChild(document.createTextNode(XMLStringUtil.escapeControlChrs(entry.getValue())));
                element.appendChild(element2);
            }
            Element element3 = document.createElement(this.dependencies.getName());
            this.dependencies.toXML(document, element3);
            element.appendChild(element3);
        }

        @Override
        public JSON toJSON() {
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, String> entry : this.scannerData.entrySet()) {
                jSONObject.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            jSONObject.put((Object)this.dependencies.getName(), (Object)((JSONObject)this.dependencies.toJSON()).getJSONArray(this.dependencies.getName()));
            return jSONObject;
        }

        @Override
        public void toHTML(StringBuilder stringBuilder) {
            stringBuilder.append("<h2>" + this.getName() + "</h2>\n");
            stringBuilder.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> object : this.scannerData.entrySet()) {
                stringBuilder.append("<tr><td>\n");
                stringBuilder.append(object.getKey());
                stringBuilder.append("</td><td>\n");
                stringBuilder.append(StringEscapeUtils.escapeHtml((String)object.getValue()));
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>\n");
            stringBuilder.append(this.dependencies.getName());
            stringBuilder.append("</td><td>\n");
            stringBuilder.append("<table border=\"1\">\n");
            for (ApiResponse apiResponse : this.dependencies.getItems()) {
                stringBuilder.append("<tr><td>\n");
                apiResponse.toHTML(stringBuilder);
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("</table>\n");
            stringBuilder.append("</td></tr>\n");
            stringBuilder.append("</table>\n");
        }

        @Override
        public String toString(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("ScannerApiResponse ");
            stringBuilder.append(this.getName());
            stringBuilder.append(" : [\n");
            for (Map.Entry<String, String> entry : this.scannerData.entrySet()) {
                for (int i = 0; i < n + 1; ++i) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" = ");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("\n");
            }
            this.dependencies.toString(n + 1);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("]\n");
            return stringBuilder.toString();
        }
    }

    private static class ExcludedParamApiResponse
    extends ApiResponse {
        private final Map<String, String> excludedParamData = new HashMap<String, String>();
        private final ApiResponseSet<String> type;
        private final Map<String, String> typeData;

        public ExcludedParamApiResponse(ScannerParamFilter scannerParamFilter, int n) {
            super("excludedParam");
            this.excludedParamData.put(ActiveScanAPI.PARAM_IDX, Integer.toString(n));
            this.excludedParamData.put("parameter", scannerParamFilter.getParamName());
            this.excludedParamData.put(ActiveScanAPI.PARAM_URL, scannerParamFilter.getWildcardedUrl());
            this.typeData = new HashMap<String, String>();
            this.typeData.put(ActiveScanAPI.PARAM_ID, Integer.toString(scannerParamFilter.getType()));
            this.typeData.put(ActiveScanAPI.PARAM_NAME, scannerParamFilter.getTypeString());
            this.type = new ApiResponseSet<String>(ActiveScanAPI.PARAM_TYPE, this.typeData);
        }

        @Override
        public void toXML(Document document, Element element) {
            element.setAttribute(ActiveScanAPI.PARAM_TYPE, "set");
            for (Map.Entry<String, String> entry : this.excludedParamData.entrySet()) {
                Element element2 = document.createElement(entry.getKey());
                element2.appendChild(document.createTextNode(XMLStringUtil.escapeControlChrs(entry.getValue())));
                element.appendChild(element2);
            }
            Element element3 = document.createElement(this.type.getName());
            this.type.toXML(document, element3);
            element.appendChild(element3);
        }

        @Override
        public JSON toJSON() {
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, String> entry : this.excludedParamData.entrySet()) {
                jSONObject.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            jSONObject.put((Object)this.type.getName(), (Object)this.type.toJSON());
            return jSONObject;
        }

        @Override
        public void toHTML(StringBuilder stringBuilder) {
            stringBuilder.append("<h2>" + this.getName() + "</h2>\n");
            stringBuilder.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> entry : this.excludedParamData.entrySet()) {
                stringBuilder.append("<tr><td>\n");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("</td><td>\n");
                stringBuilder.append(StringEscapeUtils.escapeHtml((String)entry.getValue()));
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("<tr><td>\n");
            stringBuilder.append(this.type.getName());
            stringBuilder.append("</td><td>\n");
            stringBuilder.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> entry : this.typeData.entrySet()) {
                stringBuilder.append("<tr><td>\n");
                stringBuilder.append(StringEscapeUtils.escapeHtml((String)entry.getKey()));
                stringBuilder.append("</td><td>\n");
                String string = entry.getValue();
                if (string != null) {
                    stringBuilder.append(StringEscapeUtils.escapeHtml((String)string.toString()));
                }
                stringBuilder.append("</td></tr>\n");
            }
            stringBuilder.append("</table>\n");
            stringBuilder.append("</td></tr>\n");
            stringBuilder.append("</table>\n");
        }

        @Override
        public String toString(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("ApiResponseSet ");
            stringBuilder.append(this.getName());
            stringBuilder.append(" : [\n");
            for (Map.Entry<String, String> entry : this.excludedParamData.entrySet()) {
                for (int i = 0; i < n + 1; ++i) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" = ");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("\n");
            }
            stringBuilder.append(this.type.toString(n + 1));
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append("]\n");
            return stringBuilder.toString();
        }
    }
}

