/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class CallbackParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(CallbackParam.class);
    private static final String PROXY_BASE_KEY = "callback";
    private static final String LOCAL_ADDRESS_KEY = "callback.localaddr";
    private static final String REMOTE_ADDRESS_KEY = "callback.remoteaddr";
    private static final String PORT_KEY = "callback.port";
    private String localAddress;
    private String remoteAddress;
    private int port;

    @Override
    protected void parse() {
        try {
            this.localAddress = this.getConfig().getString(LOCAL_ADDRESS_KEY, "0.0.0.0");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            this.remoteAddress = this.getConfig().getString(REMOTE_ADDRESS_KEY, this.getDefaultAddress());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            this.port = this.getConfig().getInt(PORT_KEY, 0);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private String getDefaultAddress() {
        List<String> list = this.getAvailableAddresses(false);
        for (String string : list) {
            if (string.contains(":") || string.equals("localhost") || string.equals("127.0.0.1")) continue;
            return string;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return "localhost";
    }

    public List<String> getAvailableAddresses(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (bl && inetAddress.isSiteLocalAddress()) continue;
                    String string = inetAddress.getHostAddress();
                    if (string.indexOf(37) > 0) {
                        string = string.substring(0, string.indexOf(37));
                    }
                    arrayList.add(string);
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException.getMessage(), (Throwable)socketException);
        }
        return arrayList;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String string) {
        if (this.localAddress.equals(string)) {
            return;
        }
        this.localAddress = string.trim();
        this.getConfig().setProperty(LOCAL_ADDRESS_KEY, (Object)this.localAddress);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String string) {
        if (this.remoteAddress.equals(string)) {
            return;
        }
        this.remoteAddress = string.trim();
        this.getConfig().setProperty(REMOTE_ADDRESS_KEY, (Object)this.remoteAddress);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (this.port == n) {
            return;
        }
        this.port = n;
        this.getConfig().setProperty(PORT_KEY, (Object)Integer.toString(this.port));
    }
}

