/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class DynamicSSLPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final int MIN_CERT_LENGTH = 10;
    private static final String OWASP_ZAP_ROOT_CA_NAME = "owasp_zap_root_ca";
    private static final String OWASP_ZAP_ROOT_CA_FILE_EXT = ".cer";
    private static final String OWASP_ZAP_ROOT_CA_FILENAME = "owasp_zap_root_ca.cer";
    private static final String CONFIGURATION_FILENAME = "config.xml";
    private ZapTextArea txt_PubCert;
    private JButton bt_view;
    private JButton bt_save;
    private KeyStore rootca;
    private ExtensionDynSSL extension;
    private static final Logger logger = Logger.getLogger(DynamicSSLPanel.class);

    public DynamicSSLPanel(ExtensionDynSSL extensionDynSSL) {
        this.extension = extensionDynSSL;
        this.setName(Constant.messages.getString("dynssl.options.name"));
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add(jPanel);
        JLabel jLabel = new JLabel(Constant.messages.getString("dynssl.label.rootca"));
        this.txt_PubCert = new ZapTextArea();
        this.txt_PubCert.setFont(FontUtils.getFont("Monospaced"));
        this.txt_PubCert.setEditable(false);
        this.txt_PubCert.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkAndEnableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkAndEnableButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkAndEnableButtons();
            }

            private void checkAndEnableButtons() {
                DynamicSSLPanel.this.checkAndEnableViewButton();
                DynamicSSLPanel.this.checkAndEnableSaveButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.txt_PubCert);
        JButton jButton = new JButton(Constant.messages.getString("dynssl.button.generate"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSSLPanel.this.doGenerate();
            }
        });
        jButton.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/041.png")));
        this.bt_save = new JButton(Constant.messages.getString("menu.file.save"));
        this.checkAndEnableSaveButton();
        this.bt_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSSLPanel.this.doSave();
            }
        });
        this.bt_save.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/096.png")));
        this.bt_view = new JButton(Constant.messages.getString("menu.view"));
        this.checkAndEnableViewButton();
        this.bt_view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSSLPanel.this.doView();
            }
        });
        this.bt_view.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/049.png")));
        JButton jButton2 = new JButton(Constant.messages.getString("dynssl.button.import"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSSLPanel.this.doImport();
            }
        });
        jButton2.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/047.png")));
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel, -2, 115, -2).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton))).addGap(6)).addGroup(groupLayout.createSequentialGroup().addComponent(jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.bt_view).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bt_save)).addComponent(jScrollPane, -1, 369, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addGap(10).addComponent(jButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton2, -2, 25, -2)).addComponent(jScrollPane, -2, 400, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bt_save, -2, 25, -2).addComponent(this.bt_view, -2, 25, -2)).addGap(0, 29, Short.MAX_VALUE)));
        jPanel.setLayout(groupLayout);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        DynSSLParam dynSSLParam = optionsParam.getParamSet(DynSSLParam.class);
        this.setRootca(dynSSLParam.getRootca());
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        DynSSLParam dynSSLParam = optionsParam.getParamSet(DynSSLParam.class);
        dynSSLParam.setRootca(this.rootca);
        this.extension.setRootCa(this.rootca);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.dynsslcert";
    }

    private void setRootca(KeyStore keyStore) {
        this.rootca = keyStore;
        StringWriter stringWriter = new StringWriter();
        if (keyStore != null) {
            try {
                Certificate certificate = keyStore.getCertificate(OWASP_ZAP_ROOT_CA_NAME);
                try (PemWriter pemWriter = new PemWriter((Writer)stringWriter);){
                    pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)certificate));
                    pemWriter.flush();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error while extracting public part from generated Root CA certificate.", (Throwable)exception);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Certificate defined.\n" + stringWriter.toString()));
        }
        this.txt_PubCert.setText(stringWriter.toString());
    }

    private void checkAndEnableViewButton() {
        boolean bl = true;
        bl &= Desktop.isDesktopSupported();
        this.bt_view.setEnabled(bl &= this.txt_PubCert.getDocument().getLength() > 10);
    }

    private void checkAndEnableSaveButton() {
        boolean bl = true;
        this.bt_save.setEnabled(bl &= this.txt_PubCert.getDocument().getLength() > 10);
    }

    private void doImport() {
        if (this.checkExistingCertificate()) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(new File(CONFIGURATION_FILENAME));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Constant.messages.getString("dynssl.filter.file");
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(DynamicSSLPanel.CONFIGURATION_FILENAME) || file.getName().toLowerCase().endsWith("pem") || file.isDirectory();
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (n == 0 && file.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Loading Root CA certificate from " + file));
            }
            KeyStore keyStore = null;
            if (file.getName().toLowerCase().endsWith("pem")) {
                keyStore = this.convertPemFileToKeyStore(file.toPath());
            } else {
                try {
                    ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(file);
                    String string = zapXmlConfiguration.getString("dynssl.param.rootca");
                    keyStore = SslCertificateUtils.string2Keystore(string);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error importing Root CA cert from config file:", (Throwable)exception);
                    JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.message1.filecouldntloaded"), Constant.messages.getString("dynssl.message1.title"), 0);
                }
            }
            if (keyStore != null) {
                this.setRootca(keyStore);
            }
        }
    }

    private KeyStore convertPemFileToKeyStore(Path path) {
        byte[] byArray;
        byte[] byArray2;
        String string;
        try {
            string = FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.US_ASCII);
        }
        catch (IOException iOException) {
            logger.warn((Object)"Failed to read .pem file:", (Throwable)iOException);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.failedreadfile", iOException.getLocalizedMessage()), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            byArray2 = SslCertificateUtils.extractCertificate(string);
            if (byArray2.length == 0) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.nocertsection", "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn((Object)"Failed to base64 decode the certificate from .pem file:", (Throwable)illegalArgumentException);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.certnobase64"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            byArray = SslCertificateUtils.extractPrivateKey(string);
            if (byArray.length == 0) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.noprivkeysection", "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn((Object)"Failed to base64 decode the private key from .pem file:", (Throwable)illegalArgumentException);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.privkeynobase64"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            return SslCertificateUtils.pem2KeyStore(byArray2, byArray);
        }
        catch (Exception exception) {
            logger.error((Object)"Error creating KeyStore for Root CA cert from .pem file:", (Throwable)exception);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.failedkeystore", exception.getLocalizedMessage()), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
    }

    private void doSave() {
        if (this.txt_PubCert.getDocument().getLength() < 10) {
            logger.error((Object)"Illegal state! There seems to be no certificate available.");
            this.bt_save.setEnabled(false);
        }
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(new File(OWASP_ZAP_ROOT_CA_FILENAME));
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Saving Root CA certificate to " + file));
            }
            try {
                this.writePubCertificateToFile(file);
            }
            catch (Exception exception) {
                logger.error((Object)("Error while writing certificate data to file " + file), (Throwable)exception);
            }
        }
    }

    private void writePubCertificateToFile(File file) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ASCII");){
            outputStreamWriter.write(this.txt_PubCert.getText());
        }
    }

    private void doGenerate() {
        if (this.checkExistingCertificate()) {
            return;
        }
        try {
            KeyStore keyStore = SslCertificateUtils.createRootCA();
            this.setRootca(keyStore);
        }
        catch (Exception exception) {
            logger.error((Object)"Error while generating Root CA certificate", (Throwable)exception);
        }
    }

    private boolean checkExistingCertificate() {
        boolean bl;
        boolean bl2 = bl = this.txt_PubCert.getDocument().getLength() > 10;
        if (bl) {
            int n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("dynssl.message2.caalreadyexists") + "\n" + Constant.messages.getString("dynssl.message2.willreplace") + "\n\n" + Constant.messages.getString("dynssl.message2.wanttooverwrite"), Constant.messages.getString("dynssl.message2.title"), 0);
            bl = n != 0;
        }
        return bl;
    }

    private void doView() {
        if (this.txt_PubCert.getDocument().getLength() < 10) {
            logger.error((Object)"Illegal state! There seems to be no certificate available.");
            this.bt_view.setEnabled(false);
        }
        boolean bl = false;
        File file = null;
        try {
            file = File.createTempFile(OWASP_ZAP_ROOT_CA_NAME, OWASP_ZAP_ROOT_CA_FILE_EXT);
            this.writePubCertificateToFile(file);
            bl = true;
        }
        catch (Exception exception) {
            logger.error((Object)"Error while writing certificate data into temporary file.", (Throwable)exception);
        }
        if (file != null && bl && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException iOException) {
                logger.error((Object)("Error while telling the Operating System to open " + file), (Throwable)iOException);
            }
        }
    }
}

