/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.parosproxy.paros.security.SslCertificateService;

public class SslCertificateUtils {
    public static final String BEGIN_CERTIFICATE_TOKEN = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE_TOKEN = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY_TOKEN = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY_TOKEN = "-----END PRIVATE KEY-----";
    private static final long DEFAULT_VALID_DAYS = 365L;

    public static final KeyStore createRootCA() throws NoSuchAlgorithmException {
        Date date = Calendar.getInstance().getTime();
        Date date2 = new Date(date.getTime() + 31536000000L);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, SecureRandom.getInstance("SHA1PRNG"));
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Security.addProvider((Provider)new BouncyCastleProvider());
        Random random = new Random();
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, "OWASP Zed Attack Proxy Root CA");
        x500NameBuilder.addRDN(BCStyle.L, Integer.toHexString(System.getProperty("user.name").hashCode()) + Integer.toHexString(System.getProperty("user.home").hashCode()));
        x500NameBuilder.addRDN(BCStyle.O, "OWASP Root CA");
        x500NameBuilder.addRDN(BCStyle.OU, "OWASP ZAP Root CA");
        x500NameBuilder.addRDN(BCStyle.C, "xx");
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500NameBuilder.build(), BigInteger.valueOf(random.nextInt()), date, date2, x500NameBuilder.build(), publicKey);
        KeyStore keyStore = null;
        try {
            jcaX509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(publicKey.getEncoded()));
            jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            jcaX509v3CertificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(182));
            KeyPurposeId[] keyPurposeIdArray = new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth, KeyPurposeId.anyExtendedKeyUsage};
            jcaX509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(keyPurposeIdArray));
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setKeyEntry("owasp_zap_root_ca", privateKey, SslCertificateService.PASSPHRASE, new Certificate[]{x509Certificate});
        }
        catch (Exception exception) {
            throw new IllegalStateException("Errors during assembling root CA.", exception);
        }
        return keyStore;
    }

    public static final String keyStore2String(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        keyStore.store(byteArrayOutputStream, SslCertificateService.PASSPHRASE);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return Base64.encodeBase64URLSafeString((byte[])byArray);
    }

    public static final KeyStore string2Keystore(String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        byte[] byArray = Base64.decodeBase64((String)string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(byteArrayInputStream, SslCertificateService.PASSPHRASE);
        byteArrayInputStream.close();
        return keyStore;
    }

    public static KeyStore pem2Keystore(File file) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        String string = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.US_ASCII);
        byte[] byArray = SslCertificateUtils.extractCertificate(string);
        byte[] byArray2 = SslCertificateUtils.extractPrivateKey(string);
        return SslCertificateUtils.pem2KeyStore(byArray, byArray2);
    }

    public static byte[] extractCertificate(String string) {
        return SslCertificateUtils.parseDERFromPEM(string, BEGIN_CERTIFICATE_TOKEN, END_CERTIFICATE_TOKEN);
    }

    public static byte[] extractPrivateKey(String string) {
        return SslCertificateUtils.parseDERFromPEM(string, BEGIN_PRIVATE_KEY_TOKEN, END_PRIVATE_KEY_TOKEN);
    }

    private static boolean containsSection(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        return n != -1 && string.indexOf(string3) >= n;
    }

    public static KeyStore pem2KeyStore(byte[] byArray, byte[] byArray2) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        X509Certificate x509Certificate = SslCertificateUtils.generateCertificateFromDER(byArray);
        RSAPrivateKey rSAPrivateKey = SslCertificateUtils.generatePrivateKeyFromDER(byArray2);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setCertificateEntry("cert-alias", x509Certificate);
        keyStore.setKeyEntry("owasp_zap_root_ca", rSAPrivateKey, SslCertificateService.PASSPHRASE, new Certificate[]{x509Certificate});
        return keyStore;
    }

    private static byte[] parseDERFromPEM(String string, String string2, String string3) {
        if (!SslCertificateUtils.containsSection(string, string2, string3)) {
            return new byte[0];
        }
        String[] stringArray = string.split(string2);
        stringArray = stringArray[1].split(string3);
        return DatatypeConverter.parseBase64Binary((String)stringArray[0]);
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    private static X509Certificate generateCertificateFromDER(byte[] byArray) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }
}

