/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsTableModel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanPanel;

public class HttpSessionsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "httpsessions";
    private ExtensionHttpSessions extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JScrollPane jScrollPane = null;
    private JComboBox<String> siteSelect = null;
    private JButton newSessionButton = null;
    private JXTable sessionsTable = null;
    private JButton optionsButton = null;
    private String currentSite = null;
    private SortedComboBoxModel<String> siteModel = new SortedComboBoxModel();
    private HttpSessionsTableModel sessionsModel = new HttpSessionsTableModel(null);

    public HttpSessionsPanel(ExtensionHttpSessions extensionHttpSessions) {
        this.extension = extensionHttpSessions;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("httpsessions.panel.title"));
        this.setIcon(new ImageIcon(HttpSessionsPanel.class.getResource("/resource/icon/16/session.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 | 1, false));
        this.setMnemonic(Constant.messages.getChar("httpsessions.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(Constant.messages.getString("httpsessions.panel.title"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 1;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints);
            this.panelCommand.add((Component)this.getWorkPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString("httpsessions.toolbar.options.button"));
            this.optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/041.png"))));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("httpsessions.options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    private JButton getNewSessionButton() {
        if (this.newSessionButton == null) {
            this.newSessionButton = new JButton();
            this.newSessionButton.setText(Constant.messages.getString("httpsessions.toolbar.newsession.label"));
            this.newSessionButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(HttpSessionsPanel.class.getResource("/resource/icon/16/103.png"))));
            this.newSessionButton.setToolTipText(Constant.messages.getString("httpsessions.toolbar.newsession.tooltip"));
            this.newSessionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HttpSessionsSite httpSessionsSite = HttpSessionsPanel.this.getCurrentHttpSessionSite();
                    if (httpSessionsSite != null) {
                        httpSessionsSite.createEmptySession();
                    }
                }
            });
        }
        return this.newSessionButton;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("HttpSessionToolbar");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints5.gridx = 4;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints5.anchor = 13;
            JLabel jLabel = new JLabel(Constant.messages.getString("httpsessions.toolbar.site.label"));
            this.panelToolbar.add((Component)jLabel, gridBagConstraints);
            this.panelToolbar.add(this.getSiteSelect(), gridBagConstraints2);
            this.panelToolbar.add((Component)this.getNewSessionButton(), gridBagConstraints3);
            this.panelToolbar.add((Component)this.getOptionsButton(), gridBagConstraints5);
            this.panelToolbar.add((Component)new JLabel(), gridBagConstraints4);
        }
        return this.panelToolbar;
    }

    private JScrollPane getWorkPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getHttpSessionsTable());
        }
        return this.jScrollPane;
    }

    private void setSessionsTableColumnSizes() {
        this.sessionsTable.getColumnModel().getColumn(0).setMinWidth(60);
        this.sessionsTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.sessionsTable.getColumnModel().getColumn(1).setMinWidth(120);
        this.sessionsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.sessionsTable.getColumnModel().getColumn(3).setMinWidth(100);
        this.sessionsTable.getColumnModel().getColumn(3).setPreferredWidth(150);
    }

    private JXTable getHttpSessionsTable() {
        if (this.sessionsTable == null) {
            this.sessionsTable = new JXTable((TableModel)this.sessionsModel);
            this.sessionsTable.setColumnSelectionAllowed(false);
            this.sessionsTable.setCellSelectionEnabled(false);
            this.sessionsTable.setRowSelectionAllowed(true);
            this.sessionsTable.setAutoCreateRowSorter(true);
            this.sessionsTable.setColumnControlVisible(true);
            this.setSessionsTableColumnSizes();
            this.sessionsTable.setName(PANEL_NAME);
            this.sessionsTable.setDoubleBuffered(true);
            this.sessionsTable.setSelectionMode(0);
            this.sessionsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                private void showPopupMenuIfTriggered(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = HttpSessionsPanel.this.sessionsTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0 || !HttpSessionsPanel.this.sessionsTable.getSelectionModel().isSelectedIndex(n)) {
                            HttpSessionsPanel.this.sessionsTable.getSelectionModel().clearSelection();
                            if (n >= 0) {
                                HttpSessionsPanel.this.sessionsTable.getSelectionModel().setSelectionInterval(n, n);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.sessionsTable;
    }

    private JComboBox<String> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JComboBox<String>(this.siteModel);
            this.siteSelect.addItem(Constant.messages.getString("httpsessions.toolbar.site.select"));
            this.siteSelect.setSelectedIndex(0);
            this.siteSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (1 == itemEvent.getStateChange()) {
                        if (HttpSessionsPanel.this.siteSelect.getSelectedIndex() > 0) {
                            HttpSessionsPanel.this.siteSelected((String)itemEvent.getItem());
                        } else if (HttpSessionsPanel.this.siteModel.getSize() > 1) {
                            HttpSessionsPanel.this.siteModel.setSelectedItem(HttpSessionsPanel.this.siteModel.getElementAt(1));
                        }
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public void addSite(String string) {
        if (this.siteModel.getIndexOf(string) < 0) {
            this.siteModel.addElement(string);
            if (this.currentSite == null) {
                this.siteModel.setSelectedItem(string);
            }
        }
    }

    public void addSiteAsynchronously(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HttpSessionsPanel.this.addSite(string);
            }
        });
    }

    private void siteSelected(String string) {
        if (!string.equals(this.currentSite)) {
            this.sessionsModel = this.extension.getHttpSessionsSite(string).getModel();
            this.getHttpSessionsTable().setModel((TableModel)this.sessionsModel);
            this.setSessionsTableColumnSizes();
            this.currentSite = string;
        }
    }

    public void nodeSelected(SiteNode siteNode) {
        if (siteNode != null) {
            this.siteModel.setSelectedItem(ScanPanel.cleanSiteName(siteNode, true));
        }
    }

    public void reset() {
        this.currentSite = null;
        this.siteModel.removeAllElements();
        this.siteModel.addElement(Constant.messages.getString("httpsessions.toolbar.site.select"));
        this.sessionsModel = new HttpSessionsTableModel(null);
        this.getHttpSessionsTable().setModel((TableModel)this.sessionsModel);
    }

    public HttpSessionsSite getCurrentHttpSessionSite() {
        if (this.currentSite == null) {
            return null;
        }
        return this.extension.getHttpSessionsSite(this.currentSite);
    }

    public String getCurrentSite() {
        return this.currentSite;
    }

    public HttpSession getSelectedSession() {
        int n = this.sessionsTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        int n2 = this.sessionsTable.convertRowIndexToModel(n);
        return this.sessionsModel.getHttpSessionAt(n2);
    }
}

