/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.filters.HttpPrefixFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenParseFilter;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class SpiderAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SpiderAPI.class);
    private static final String PREFIX = "spider";
    private static final String ACTION_START_SCAN = "scan";
    private static final String ACTION_START_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String ACTION_ADD_DOMAIN_ALWAYS_IN_SCOPE = "addDomainAlwaysInScope";
    private static final String ACTION_MODIFY_DOMAIN_ALWAYS_IN_SCOPE = "modifyDomainAlwaysInScope";
    private static final String ACTION_REMOVE_DOMAIN_ALWAYS_IN_SCOPE = "removeDomainAlwaysInScope";
    private static final String ACTION_ENABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE = "enableAllDomainsAlwaysInScope";
    private static final String ACTION_DISABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE = "disableAllDomainsAlwaysInScope";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_RESULTS = "results";
    private static final String VIEW_FULL_RESULTS = "fullResults";
    private static final String VIEW_SCANS = "scans";
    private static final String VIEW_ALL_URLS = "allUrls";
    private static final String VIEW_DOMAINS_ALWAYS_IN_SCOPE = "domainsAlwaysInScope";
    private static final String VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE = "optionDomainsAlwaysInScope";
    private static final String VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED = "optionDomainsAlwaysInScopeEnabled";
    private static final String PARAM_URL = "url";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_CONTEXT_NAME = "contextName";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_MAX_CHILDREN = "maxChildren";
    private static final String PARAM_SUBTREE_ONLY = "subtreeOnly";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_IS_REGEX = "isRegex";
    private static final String PARAM_IS_ENABLED = "isEnabled";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private ExtensionSpider extension;

    public SpiderAPI(ExtensionSpider extensionSpider) {
        this.extension = extensionSpider;
        this.addApiAction(new ApiAction(ACTION_START_SCAN, null, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_CONTEXT_NAME, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_START_SCAN_AS_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, null, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_ADD_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_VALUE}, new String[]{PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_MODIFY_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_IDX}, new String[]{PARAM_VALUE, PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_IDX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_RESULTS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_FULL_RESULTS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
        this.addApiView(new ApiView(VIEW_ALL_URLS));
        this.addApiView(new ApiView(VIEW_DOMAINS_ALWAYS_IN_SCOPE));
        ApiView apiView = new ApiView(VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
        apiView = new ApiView(VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("Request for handleApiAction: " + string + " (params: " + jSONObject.toString() + ")"));
        int n = -1;
        Context context = null;
        switch (string) {
            case "scan": {
                String string2;
                String string3 = ApiUtils.getOptionalStringParam(jSONObject, PARAM_URL);
                if (jSONObject.containsKey((Object)PARAM_MAX_CHILDREN) && (string2 = jSONObject.getString(PARAM_MAX_CHILDREN)) != null && string2.length() > 0) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                if (jSONObject.containsKey((Object)PARAM_CONTEXT_NAME) && !(string2 = jSONObject.getString(PARAM_CONTEXT_NAME)).isEmpty()) {
                    context = ApiUtils.getContextByName(string2);
                }
                int n2 = this.scanURL(string3, null, n, this.getParam(jSONObject, PARAM_RECURSE, true), context, this.getParam(jSONObject, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(string, Integer.toString(n2));
            }
            case "scanAsUser": {
                String string4;
                String string5 = ApiUtils.getOptionalStringParam(jSONObject, PARAM_URL);
                int n3 = ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
                ExtensionUserManagement extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                if (extensionUserManagement == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                }
                context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                User user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(n3);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                }
                if (jSONObject.containsKey((Object)PARAM_MAX_CHILDREN) && (string4 = jSONObject.getString(PARAM_MAX_CHILDREN)) != null && string4.length() > 0) {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                int n4 = this.scanURL(string5, user, n, this.getParam(jSONObject, PARAM_RECURSE, true), context, this.getParam(jSONObject, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(string, Integer.toString(n4));
            }
            case "pause": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.pauseScan(genericScanner2.getScanId());
                break;
            }
            case "resume": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.resumeScan(genericScanner2.getScanId());
                break;
            }
            case "stop": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.stopScan(genericScanner2.getScanId());
                break;
            }
            case "removeScan": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.removeScan(genericScanner2.getScanId());
                break;
            }
            case "pauseAllScans": {
                this.extension.pauseAllScans();
                break;
            }
            case "resumeAllScans": {
                this.extension.resumeAllScans();
                break;
            }
            case "stopAllScans": {
                this.extension.stopAllScans();
                break;
            }
            case "removeAllScans": {
                this.extension.removeAllScans();
                break;
            }
            case "clearExcludedFromScan": {
                try {
                    Session session = Model.getSingleton().getSession();
                    session.setExcludeFromSpiderRegexs(new ArrayList<String>());
                    break;
                }
                catch (DatabaseException databaseException) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                }
            }
            case "excludeFromScan": {
                String string6 = jSONObject.getString(PARAM_REGEX);
                try {
                    Session session = Model.getSingleton().getSession();
                    session.addExcludeFromSpiderRegex(string6);
                    break;
                }
                catch (DatabaseException databaseException) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                }
            }
            case "addDomainAlwaysInScope": {
                try {
                    String string7 = jSONObject.getString(PARAM_VALUE);
                    DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = this.getParam(jSONObject, PARAM_IS_REGEX, false) ? new DomainAlwaysInScopeMatcher(DomainAlwaysInScopeMatcher.createPattern(string7)) : new DomainAlwaysInScopeMatcher(string7);
                    domainAlwaysInScopeMatcher.setEnabled(this.getParam(jSONObject, PARAM_IS_ENABLED, true));
                    ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    arrayList.add(domainAlwaysInScopeMatcher);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(arrayList);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, illegalArgumentException);
                }
            }
            case "modifyDomainAlwaysInScope": {
                try {
                    int n5 = jSONObject.getInt(PARAM_IDX);
                    if (n5 < 0 || n5 >= this.extension.getSpiderParam().getDomainsAlwaysInScope().size()) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                    }
                    DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = this.extension.getSpiderParam().getDomainsAlwaysInScope().get(n5);
                    String string8 = this.getParam(jSONObject, PARAM_VALUE, domainAlwaysInScopeMatcher.getValue());
                    if (string8.isEmpty()) {
                        string8 = domainAlwaysInScopeMatcher.getValue();
                    }
                    DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher2 = this.getParam(jSONObject, PARAM_IS_REGEX, domainAlwaysInScopeMatcher.isRegex()) ? new DomainAlwaysInScopeMatcher(DomainAlwaysInScopeMatcher.createPattern(string8)) : new DomainAlwaysInScopeMatcher(string8);
                    domainAlwaysInScopeMatcher2.setEnabled(this.getParam(jSONObject, PARAM_IS_ENABLED, domainAlwaysInScopeMatcher.isEnabled()));
                    if (domainAlwaysInScopeMatcher.equals(domainAlwaysInScopeMatcher2)) break;
                    ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    arrayList.set(n5, domainAlwaysInScopeMatcher2);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(arrayList);
                    break;
                }
                catch (JSONException jSONException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, jSONException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, illegalArgumentException);
                }
            }
            case "removeDomainAlwaysInScope": {
                try {
                    int n6 = jSONObject.getInt(PARAM_IDX);
                    if (n6 < 0 || n6 >= this.extension.getSpiderParam().getDomainsAlwaysInScope().size()) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                    }
                    ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    arrayList.remove(n6);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(arrayList);
                    break;
                }
                catch (JSONException jSONException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, jSONException);
                }
            }
            case "enableAllDomainsAlwaysInScope": {
                this.setDomainsAlwaysInScopeEnabled(true);
                break;
            }
            case "disableAllDomainsAlwaysInScope": {
                this.setDomainsAlwaysInScopeEnabled(false);
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void setDomainsAlwaysInScopeEnabled(boolean bl) {
        List<DomainAlwaysInScopeMatcher> list = this.extension.getSpiderParam().getDomainsAlwaysInScope();
        for (DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher : this.extension.getSpiderParam().getDomainsAlwaysInScope()) {
            domainAlwaysInScopeMatcher.setEnabled(bl);
        }
        this.extension.getSpiderParam().setDomainsAlwaysInScope(list);
    }

    private GenericScanner2 getSpiderScan(JSONObject jSONObject) throws ApiException {
        int n = this.getParam(jSONObject, PARAM_SCAN_ID, -1);
        SpiderScan spiderScan = n == -1 ? this.extension.getLastScan() : this.extension.getScan(n);
        if (spiderScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return spiderScan;
    }

    private int scanURL(String string, User user, int n, boolean bl, Context context, boolean bl2) throws ApiException {
        Object object;
        log.debug((Object)("API Spider scanning url: " + string));
        boolean bl3 = true;
        if (string == null || string.isEmpty()) {
            if (context == null || !context.hasNodesInContextFromSiteTree()) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_URL);
            }
            bl3 = false;
        } else if (context != null && !context.isInContext(string)) {
            throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_URL);
        }
        StructuralNode structuralNode = null;
        URI uRI = null;
        if (bl3) {
            try {
                uRI = new URI(string, true);
            }
            catch (URIException uRIException) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            object = uRI.getScheme();
            if (object == null || !((String)object).equalsIgnoreCase("http") && !((String)object).equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            try {
                structuralNode = SessionStructure.find(Model.getSingleton().getSession().getSessionId(), new URI(string, false), "GET", "");
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (bl3) {
            object = new Target(structuralNode);
            ((Target)object).setContext(context);
        } else {
            object = new Target(context);
        }
        ((Target)object).setRecurse(bl);
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case protect: {
                if ((!bl3 || Model.getSingleton().getSession().isInScope(string)) && (context == null || context.isInScope())) break;
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case standard: {
                break;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        if (uRI != null) {
            arrayList.add(uRI);
            if (bl2) {
                arrayList.add(new HttpPrefixFetchFilter(uRI));
            }
        }
        if (n > 0) {
            MaxChildrenFetchFilter maxChildrenFetchFilter = new MaxChildrenFetchFilter();
            maxChildrenFetchFilter.setMaxChildren(n);
            maxChildrenFetchFilter.setModel(this.extension.getModel());
            MaxChildrenParseFilter maxChildrenParseFilter = new MaxChildrenParseFilter();
            maxChildrenParseFilter.setMaxChildren(n);
            maxChildrenParseFilter.setModel(this.extension.getModel());
            arrayList.add(maxChildrenFetchFilter);
            arrayList.add(maxChildrenParseFilter);
        }
        return this.extension.startScan((Target)object, user, arrayList.toArray(new Object[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        if (VIEW_STATUS.equals(string)) {
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            int n = 0;
            if (spiderScan != null) {
                n = spiderScan.isStopped() ? 100 : spiderScan.getProgress();
            }
            apiResponse = new ApiResponseElement(string, Integer.toString(n));
        } else if (VIEW_RESULTS.equals(string)) {
            apiResponse = new ApiResponseList(string);
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            if (spiderScan != null) {
                Set<String> set = spiderScan.getResults();
                synchronized (set) {
                    for (String string3 : spiderScan.getResults()) {
                        ((ApiResponseList)apiResponse).addItem(new ApiResponseElement(PARAM_URL, string3));
                    }
                }
            }
        } else if (VIEW_FULL_RESULTS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            ApiResponseList apiResponseList2 = new ApiResponseList("urlsInScope");
            Collection<Object> spiderScan2 = spiderScan.getResourcesFound();
            synchronized (spiderScan2) {
                for (SpiderResource spiderResource : spiderScan.getResourcesFound()) {
                    apiResponseList2.addItem(SpiderAPI.createApiResponseSet(spiderResource));
                }
            }
            apiResponseList.addItem(apiResponseList2);
            ApiResponseList apiResponseList3 = new ApiResponseList("urlsOutOfScope");
            spiderScan2 = spiderScan.getResultsOutOfScope();
            synchronized (spiderScan2) {
                for (String string2 : spiderScan.getResultsOutOfScope()) {
                    apiResponseList3.addItem(new ApiResponseElement(PARAM_URL, string2));
                }
            }
            apiResponseList.addItem(apiResponseList3);
            ApiResponseList genericScanner2 = new ApiResponseList("urlsIoError");
            spiderScan2 = spiderScan.getResourcesIoErrors();
            synchronized (spiderScan2) {
                for (SpiderResource spiderResource : spiderScan.getResourcesIoErrors()) {
                    genericScanner2.addItem(SpiderAPI.createApiResponseSet(spiderResource));
                }
            }
            apiResponseList.addItem(genericScanner2);
            apiResponse = apiResponseList;
        } else if (VIEW_EXCLUDED_FROM_SCAN.equals(string)) {
            apiResponse = new ApiResponseList(string);
            Session session = Model.getSingleton().getSession();
            List<String> list = session.getExcludeFromSpiderRegexs();
            for (String list2 : list) {
                ((ApiResponseList)apiResponse).addItem(new ApiResponseElement(PARAM_REGEX, list2));
            }
        } else if (VIEW_SCANS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (GenericScanner2 genericScanner2 : this.extension.getAllScans()) {
                SpiderScan spiderScan = (SpiderScan)genericScanner2;
                HashMap<String, String> string4 = new HashMap<String, String>();
                string4.put("id", Integer.toString(spiderScan.getScanId()));
                string4.put("progress", Integer.toString(spiderScan.getProgress()));
                string4.put("state", spiderScan.getState());
                apiResponseList.addItem(new ApiResponseSet(ACTION_START_SCAN, string4));
            }
            apiResponse = apiResponseList;
        } else if (VIEW_ALL_URLS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            HashSet<String> hashSet = new HashSet<String>();
            TableHistory tableHistory = this.extension.getModel().getDb().getTableHistory();
            List<Object> list = Collections.emptyList();
            try {
                list = tableHistory.getHistoryIdsOfHistType(this.extension.getModel().getSession().getSessionId(), 2, 9);
            }
            catch (DatabaseException databaseException) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
            }
            for (Integer n : list) {
                try {
                    String string3;
                    RecordHistory recordHistory = tableHistory.read(n);
                    if (recordHistory == null || !hashSet.add(string3 = recordHistory.getHttpMessage().getRequestHeader().getURI().toString())) continue;
                    apiResponseList.addItem(new ApiResponseElement(PARAM_URL, string3));
                }
                catch (DatabaseException | HttpMalformedHeaderException exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
            }
            apiResponse = apiResponseList;
        } else if (VIEW_DOMAINS_ALWAYS_IN_SCOPE.equals(string) || VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE.equals(string)) {
            apiResponse = this.domainMatchersToApiResponseList(string, this.extension.getSpiderParam().getDomainsAlwaysInScope(), false);
        } else if (VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED.equals(string)) {
            apiResponse = this.domainMatchersToApiResponseList(string, this.extension.getSpiderParam().getDomainsAlwaysInScope(), true);
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return apiResponse;
    }

    private static ApiResponseSet<String> createApiResponseSet(SpiderResource spiderResource) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("messageId", Integer.toString(spiderResource.getHistoryId()));
        hashMap.put("method", spiderResource.getMethod());
        hashMap.put(PARAM_URL, spiderResource.getUri());
        hashMap.put("statusCode", Integer.toString(spiderResource.getStatusCode()));
        hashMap.put("statusReason", spiderResource.getStatusReason());
        return new ApiResponseSet<String>("resource", hashMap);
    }

    private ApiResponse domainMatchersToApiResponseList(String string, List<DomainAlwaysInScopeMatcher> list, boolean bl) {
        ApiResponseList apiResponseList = new ApiResponseList(string);
        for (int i = 0; i < list.size(); ++i) {
            DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = list.get(i);
            if (!domainAlwaysInScopeMatcher.isEnabled() && bl) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(PARAM_IDX, i);
            hashMap.put(PARAM_VALUE, domainAlwaysInScopeMatcher.getValue());
            hashMap.put(PARAM_REGEX, domainAlwaysInScopeMatcher.isRegex());
            hashMap.put("enabled", domainAlwaysInScopeMatcher.isEnabled());
            apiResponseList.addItem(new ApiResponseSet("domain", hashMap));
        }
        return apiResponseList;
    }
}

