/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.regex.Pattern;
import org.zaproxy.zap.utils.Enableable;

public class DomainAlwaysInScopeMatcher
extends Enableable {
    private final Pattern pattern;
    private final String domain;
    private final boolean regex;

    public DomainAlwaysInScopeMatcher(Pattern pattern) {
        super(true);
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter pattern must not be null.");
        }
        this.pattern = pattern;
        this.regex = true;
        this.domain = null;
    }

    public DomainAlwaysInScopeMatcher(String string) {
        super(true);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Parameter domain must not be null or empty.");
        }
        this.domain = string;
        this.regex = false;
        this.pattern = null;
    }

    public DomainAlwaysInScopeMatcher(DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher) {
        super(domainAlwaysInScopeMatcher.isEnabled());
        this.domain = domainAlwaysInScopeMatcher.domain;
        this.regex = domainAlwaysInScopeMatcher.regex;
        this.pattern = domainAlwaysInScopeMatcher.pattern;
    }

    public String getValue() {
        if (this.isRegex()) {
            return this.pattern.pattern();
        }
        return this.domain;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public boolean matches(String string) {
        if (this.pattern != null) {
            return this.pattern.matcher(string).matches();
        }
        return this.domain.equals(string);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.domain == null ? 0 : this.domain.hashCode());
        n = 31 * n + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = (DomainAlwaysInScopeMatcher)object;
        if (this.domain == null ? domainAlwaysInScopeMatcher.domain != null : !this.domain.equals(domainAlwaysInScopeMatcher.domain)) {
            return false;
        }
        return !(this.pattern == null ? domainAlwaysInScopeMatcher.pattern != null : !this.pattern.pattern().equals(domainAlwaysInScopeMatcher.pattern.pattern()));
    }

    public static Pattern createPattern(String string) {
        return Pattern.compile(string, 2);
    }
}

