/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderODataAtomParser
extends SpiderParser {
    private static final Pattern patternURL = Pattern.compile("href=\\\"([\\w();&'/,=\\-]*)\\\"");
    private static final Pattern patternBase = Pattern.compile("base=\"(http(s?)://[^\\x00-\\x1f\"'\\s<>#]+)\"");

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        log.debug((Object)"Parsing an OData Atom resource.");
        String string = httpMessage.getRequestHeader().getURI().toString();
        String string2 = httpMessage.getResponseBody().toString();
        Matcher matcher = patternBase.matcher(string2);
        if (matcher.find()) {
            string = matcher.group(1);
            string = StringEscapeUtils.unescapeXml((String)string);
        }
        boolean bl = false;
        matcher = patternURL.matcher(string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            string3 = StringEscapeUtils.unescapeXml((String)string3);
            this.processURL(httpMessage, n, string3, string);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader().isXml();
    }
}

