/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.FontUtils;

public class DisplayUtils {
    private static List<Image> zapIconImages;
    private static Boolean scaleImages;
    private static final int STD_HEIGHT = 16;

    private static boolean isScaleImages() {
        if (scaleImages == null) {
            scaleImages = Model.getSingleton().getOptionsParam().getViewParam().isScaleImages();
        }
        return scaleImages;
    }

    public static ImageIcon getScaledIcon(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return DisplayUtils.getScaledIcon(new ImageIcon(uRL));
    }

    public static ImageIcon getScaledIcon(ImageIcon imageIcon) {
        if (!DisplayUtils.isScaleImages() || imageIcon == null || FontUtils.getScale() == 1.0f || imageIcon.getIconHeight() > 16) {
            return imageIcon;
        }
        return new ImageIcon(imageIcon.getImage().getScaledInstance((int)((float)imageIcon.getIconWidth() * FontUtils.getScale()), (int)((float)imageIcon.getIconHeight() * FontUtils.getScale()), 4));
    }

    public static Icon getScaledIcon(Icon icon) {
        if (!DisplayUtils.isScaleImages() || icon == null || FontUtils.getScale() == 1.0f || !(icon instanceof ImageIcon)) {
            return icon;
        }
        return DisplayUtils.getScaledIcon((ImageIcon)icon);
    }

    public static Dimension getScaledDimension(int n, int n2) {
        if (FontUtils.getScale() == 1.0f) {
            return new Dimension(n, n2);
        }
        return new Dimension((int)((float)n * FontUtils.getScale()), (int)((float)n2 * FontUtils.getScale()));
    }

    public static int getScaledSize(int n) {
        return (int)((float)n * FontUtils.getScale());
    }

    public static void scaleIcon(JLabel jLabel) {
        if (DisplayUtils.isScaleImages() && jLabel != null && jLabel.getIcon() != null && jLabel.getIcon() instanceof ImageIcon) {
            jLabel.setIcon(DisplayUtils.getScaledIcon((ImageIcon)jLabel.getIcon()));
        }
    }

    public static void scaleIcon(JButton jButton) {
        if (DisplayUtils.isScaleImages() && jButton != null && jButton.getIcon() != null && jButton.getIcon() instanceof ImageIcon) {
            jButton.setIcon(DisplayUtils.getScaledIcon((ImageIcon)jButton.getIcon()));
        }
    }

    public static void scaleIcon(JToggleButton jToggleButton) {
        if (DisplayUtils.isScaleImages() && jToggleButton != null) {
            if (jToggleButton.getIcon() != null && jToggleButton.getIcon() instanceof ImageIcon) {
                jToggleButton.setIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getIcon()));
            }
            if (jToggleButton.getSelectedIcon() != null && jToggleButton.getSelectedIcon() instanceof ImageIcon) {
                jToggleButton.setSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getSelectedIcon()));
            }
            if (jToggleButton.getRolloverIcon() != null && jToggleButton.getRolloverIcon() instanceof ImageIcon) {
                jToggleButton.setRolloverIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getRolloverIcon()));
            }
            if (jToggleButton.getRolloverSelectedIcon() != null && jToggleButton.getRolloverSelectedIcon() instanceof ImageIcon) {
                jToggleButton.setRolloverSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getRolloverSelectedIcon()));
            }
            if (jToggleButton.getDisabledIcon() != null && jToggleButton.getDisabledIcon() instanceof ImageIcon) {
                jToggleButton.setDisabledIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getDisabledIcon()));
            }
            if (jToggleButton.getDisabledSelectedIcon() != null && jToggleButton.getDisabledSelectedIcon() instanceof ImageIcon) {
                jToggleButton.setDisabledSelectedIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getDisabledSelectedIcon()));
            }
            if (jToggleButton.getPressedIcon() != null && jToggleButton.getPressedIcon() instanceof ImageIcon) {
                jToggleButton.setPressedIcon(DisplayUtils.getScaledIcon((ImageIcon)jToggleButton.getPressedIcon()));
            }
        }
    }

    public static List<Image> getZapIconImages() {
        if (zapIconImages == null) {
            DisplayUtils.createZapIconImages();
        }
        return zapIconImages;
    }

    private static synchronized void createZapIconImages() {
        if (zapIconImages == null) {
            ArrayList<Image> arrayList = new ArrayList<Image>(8);
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap16x16.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap48x48.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap256x256.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap512x512.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(DisplayUtils.class.getResource("/resource/zap1024x1024.png")));
            zapIconImages = Collections.unmodifiableList(arrayList);
        }
    }

    static {
        scaleImages = null;
    }
}

