// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Session_h__
#define __IceGrid_Session_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Glacier2/Session.h>
#include <IceGrid/Exception.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Session;
class SessionPrx;

}

namespace IceGrid
{

class ICEGRID_API Session : public virtual ::Glacier2::Session
{
public:

    using ProxyType = SessionPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void keepAlive(const ::Ice::Current&) = 0;
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void allocateObjectByIdAsync(::Ice::Identity, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_allocateObjectById(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void allocateObjectByTypeAsync(::std::string, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_allocateObjectByType(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void releaseObject(::Ice::Identity, const ::Ice::Current&) = 0;
    bool _iceD_releaseObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setAllocationTimeout(int, const ::Ice::Current&) = 0;
    bool _iceD_setAllocationTimeout(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) SessionPrx : public virtual ::Ice::Proxy<SessionPrx, ::Glacier2::SessionPrx>
{
public:

    void keepAlive(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::SessionPrx::_iceI_keepAlive, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::SessionPrx::_iceI_keepAlive, context);
    }

    ::std::function<void()>
    keepAliveAsync(::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::SessionPrx::_iceI_keepAlive, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::SessionPrx::_iceI_allocateObjectById, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto allocateObjectByIdAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::SessionPrx::_iceI_allocateObjectById, iceP_id, context);
    }

    ::std::function<void()>
    allocateObjectByIdAsync(const ::Ice::Identity& iceP_id,
                            ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::SessionPrx::_iceI_allocateObjectById, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_allocateObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> allocateObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::SessionPrx::_iceI_allocateObjectByType, iceP_type, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto allocateObjectByTypeAsync(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::SessionPrx::_iceI_allocateObjectByType, iceP_type, context);
    }

    ::std::function<void()>
    allocateObjectByTypeAsync(const ::std::string& iceP_type,
                              ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::SessionPrx::_iceI_allocateObjectByType, iceP_type, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_allocateObjectByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    void releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::SessionPrx::_iceI_releaseObject, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto releaseObjectAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::SessionPrx::_iceI_releaseObject, iceP_id, context);
    }

    ::std::function<void()>
    releaseObjectAsync(const ::Ice::Identity& iceP_id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::SessionPrx::_iceI_releaseObject, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_releaseObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);

    void setAllocationTimeout(int iceP_timeout, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::SessionPrx::_iceI_setAllocationTimeout, iceP_timeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setAllocationTimeoutAsync(int iceP_timeout, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::SessionPrx::_iceI_setAllocationTimeout, iceP_timeout, context);
    }

    ::std::function<void()>
    setAllocationTimeoutAsync(int iceP_timeout,
                              ::std::function<void()> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::SessionPrx::_iceI_setAllocationTimeout, iceP_timeout, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_setAllocationTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    SessionPrx() = default;
    friend ::std::shared_ptr<SessionPrx> IceInternal::createProxy<SessionPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

}

namespace IceGrid
{

using SessionPtr = ::std::shared_ptr<Session>;
using SessionPrxPtr = ::std::shared_ptr<SessionPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Session;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Session>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::Session*);

}

}

namespace IceGrid
{

class Session;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::Session*);
typedef ::IceInternal::Handle< ::IceGrid::Session> SessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Session> SessionPrx;
typedef SessionPrx SessionPrxPtr;
ICEGRID_API void _icePatchObjectPtr(SessionPtr&, const ::Ice::ObjectPtr&);

}

namespace IceGrid
{

class ICEGRID_API AMD_Session_allocateObjectById : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Session_allocateObjectById();

    virtual void ice_response(const ::Ice::ObjectPrx&) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Session_allocateObjectById> AMD_Session_allocateObjectByIdPtr;

class ICEGRID_API AMD_Session_allocateObjectByType : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Session_allocateObjectByType();

    virtual void ice_response(const ::Ice::ObjectPrx&) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Session_allocateObjectByType> AMD_Session_allocateObjectByTypePtr;

}

namespace IceAsync
{

namespace IceGrid
{

class ICEGRID_API AMD_Session_allocateObjectById : public ::IceGrid::AMD_Session_allocateObjectById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Session_allocateObjectById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

class ICEGRID_API AMD_Session_allocateObjectByType : public ::IceGrid::AMD_Session_allocateObjectByType, public ::IceInternal::IncomingAsync
{
public:

    AMD_Session_allocateObjectByType(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

}

}

namespace IceGrid
{

class Callback_Session_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_keepAlive_Base> Callback_Session_keepAlivePtr;

class Callback_Session_allocateObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_allocateObjectById_Base> Callback_Session_allocateObjectByIdPtr;

class Callback_Session_allocateObjectByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_allocateObjectByType_Base> Callback_Session_allocateObjectByTypePtr;

class Callback_Session_releaseObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_releaseObject_Base> Callback_Session_releaseObjectPtr;

class Callback_Session_setAllocationTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_setAllocationTimeout_Base> Callback_Session_setAllocationTimeoutPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Session : public virtual ::Ice::Proxy<Session, ::IceProxy::Glacier2::Session>
{
public:

    ICE_MEMBER(ICEGRID_API) void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::Callback_Session_keepAlivePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::IceGrid::Callback_Session_keepAlivePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_keepAlive(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_allocateObjectById(_iceI_begin_allocateObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_allocateObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_Session_allocateObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Session_allocateObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_allocateObjectById(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_allocateObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx allocateObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_allocateObjectByType(_iceI_begin_allocateObjectByType(iceP_type, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_allocateObjectByType(iceP_type, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& iceP_type, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(iceP_type, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& iceP_type, const ::IceGrid::Callback_Session_allocateObjectByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceGrid::Callback_Session_allocateObjectByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(iceP_type, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_allocateObjectByType(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_allocateObjectByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_releaseObject(_iceI_begin_releaseObject(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_releaseObject(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_Session_releaseObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Session_releaseObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_releaseObject(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_releaseObject(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void setAllocationTimeout(::Ice::Int iceP_timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAllocationTimeout(_iceI_begin_setAllocationTimeout(iceP_timeout, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int iceP_timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAllocationTimeout(iceP_timeout, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int iceP_timeout, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(iceP_timeout, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int iceP_timeout, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(iceP_timeout, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int iceP_timeout, const ::IceGrid::Callback_Session_setAllocationTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(iceP_timeout, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int iceP_timeout, const ::Ice::Context& context, const ::IceGrid::Callback_Session_setAllocationTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(iceP_timeout, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_setAllocationTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setAllocationTimeout(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceGrid
{

class ICEGRID_API Session : virtual public ::Glacier2::Session
{
public:

    typedef SessionPrx ProxyType;
    typedef SessionPtr PointerType;

    virtual ~Session();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void keepAlive(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void allocateObjectById_async(const ::IceGrid::AMD_Session_allocateObjectByIdPtr&, const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_allocateObjectById(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void allocateObjectByType_async(const ::IceGrid::AMD_Session_allocateObjectByTypePtr&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_allocateObjectByType(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void releaseObject(const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_releaseObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setAllocationTimeout(::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setAllocationTimeout(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

}

namespace IceGrid
{

template<class T>
class CallbackNC_Session_keepAlive : public Callback_Session_keepAlive_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_keepAlive : public Callback_Session_keepAlive_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Session_allocateObjectById : public Callback_Session_allocateObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Session_allocateObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectById<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectById<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_allocateObjectById : public Callback_Session_allocateObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Session_allocateObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Session_allocateObjectByType : public Callback_Session_allocateObjectByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Session_allocateObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectByType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectByType<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_allocateObjectByType : public Callback_Session_allocateObjectByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Session_allocateObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Session_releaseObject : public Callback_Session_releaseObject_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_releaseObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_releaseObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_releaseObject : public Callback_Session_releaseObject_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_releaseObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::SessionPrx proxy = ::IceGrid::SessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_releaseObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Session_setAllocationTimeout : public Callback_Session_setAllocationTimeout_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_setAllocationTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_setAllocationTimeout : public Callback_Session_setAllocationTimeout_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_setAllocationTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
