// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceStorm_IceStorm_h__
#define __IceStorm_IceStorm_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/SliceChecksumDict.h>
#include <IceStorm/Metrics.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceStorm/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICESTORM_API
#   if defined(ICE_STATIC_LIBS)
#       define ICESTORM_API /**/
#   elif defined(ICESTORM_API_EXPORTS)
#       define ICESTORM_API ICE_DECLSPEC_EXPORT
#   else
#       define ICESTORM_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceStorm
{

class Topic;
class TopicPrx;
class TopicManager;
class TopicManagerPrx;
class Finder;
class FinderPrx;

}

namespace IceStorm
{

struct LinkInfo
{
    ::std::shared_ptr<::IceStorm::TopicPrx> theTopic;
    ::std::string name;
    int cost;

    std::tuple<const ::std::shared_ptr<::IceStorm::TopicPrx>&, const ::std::string&, const int&> ice_tuple() const
    {
        return std::tie(theTopic, name, cost);
    }
};

using LinkInfoSeq = ::std::vector<::IceStorm::LinkInfo>;

using QoS = ::std::map<::std::string, ::std::string>;

class ICE_CLASS(ICESTORM_API) LinkExists : public ::Ice::UserExceptionHelper<LinkExists, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~LinkExists();

    LinkExists(const LinkExists&) = default;

    LinkExists() = default;

    LinkExists(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

static LinkExists _iceS_LinkExists_init;

class ICE_CLASS(ICESTORM_API) NoSuchLink : public ::Ice::UserExceptionHelper<NoSuchLink, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~NoSuchLink();

    NoSuchLink(const NoSuchLink&) = default;

    NoSuchLink() = default;

    NoSuchLink(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

class ICE_CLASS(ICESTORM_API) AlreadySubscribed : public ::Ice::UserExceptionHelper<AlreadySubscribed, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~AlreadySubscribed();

    AlreadySubscribed(const AlreadySubscribed&) = default;

    AlreadySubscribed() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICESTORM_API) InvalidSubscriber : public ::Ice::UserExceptionHelper<InvalidSubscriber, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~InvalidSubscriber();

    InvalidSubscriber(const InvalidSubscriber&) = default;

    InvalidSubscriber() = default;

    InvalidSubscriber(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICESTORM_API) BadQoS : public ::Ice::UserExceptionHelper<BadQoS, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~BadQoS();

    BadQoS(const BadQoS&) = default;

    BadQoS() = default;

    BadQoS(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

using TopicDict = ::std::map<::std::string, ::std::shared_ptr<::IceStorm::TopicPrx>>;

class ICE_CLASS(ICESTORM_API) TopicExists : public ::Ice::UserExceptionHelper<TopicExists, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~TopicExists();

    TopicExists(const TopicExists&) = default;

    TopicExists() = default;

    TopicExists(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

class ICE_CLASS(ICESTORM_API) NoSuchTopic : public ::Ice::UserExceptionHelper<NoSuchTopic, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~NoSuchTopic();

    NoSuchTopic(const NoSuchTopic&) = default;

    NoSuchTopic() = default;

    NoSuchTopic(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceStorm
{

class ICESTORM_API Topic : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::string getName(const ::Ice::Current&) const = 0;
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getPublisher(const ::Ice::Current&) const = 0;
    bool _iceD_getPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getNonReplicatedPublisher(const ::Ice::Current&) const = 0;
    bool _iceD_getNonReplicatedPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> subscribeAndGetPublisher(::IceStorm::QoS, ::std::shared_ptr<::Ice::ObjectPrx>, const ::Ice::Current&) = 0;
    bool _iceD_subscribeAndGetPublisher(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void unsubscribe(::std::shared_ptr<::Ice::ObjectPrx>, const ::Ice::Current&) = 0;
    bool _iceD_unsubscribe(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void link(::std::shared_ptr<::IceStorm::TopicPrx>, int, const ::Ice::Current&) = 0;
    bool _iceD_link(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void unlink(::std::shared_ptr<::IceStorm::TopicPrx>, const ::Ice::Current&) = 0;
    bool _iceD_unlink(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceStorm::LinkInfoSeq getLinkInfoSeq(const ::Ice::Current&) const = 0;
    bool _iceD_getLinkInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::IdentitySeq getSubscribers(const ::Ice::Current&) const = 0;
    bool _iceD_getSubscribers(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void destroy(const ::Ice::Current&) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICESTORM_API TopicManager : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicManagerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::IceStorm::TopicPrx> create(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceStorm::TopicPrx> retrieve(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_retrieve(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceStorm::TopicDict retrieveAll(const ::Ice::Current&) const = 0;
    bool _iceD_retrieveAll(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current&) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICESTORM_API Finder : public virtual ::Ice::Object
{
public:

    using ProxyType = FinderPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::IceStorm::TopicManagerPrx> getTopicManager(const ::Ice::Current&) = 0;
    bool _iceD_getTopicManager(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceStorm
{

class ICE_CLASS(ICESTORM_API) TopicPrx : public virtual ::Ice::Proxy<TopicPrx, ::Ice::ObjectPrx>
{
public:

    ::std::string getName(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &IceStorm::TopicPrx::_iceI_getName, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNameAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &IceStorm::TopicPrx::_iceI_getName, context);
    }

    ::std::function<void()>
    getNameAsync(::std::function<void(::std::string)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_getName, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getPublisher(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceStorm::TopicPrx::_iceI_getPublisher, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getPublisherAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceStorm::TopicPrx::_iceI_getPublisher, context);
    }

    ::std::function<void()>
    getPublisherAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_getPublisher, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getNonReplicatedPublisher(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceStorm::TopicPrx::_iceI_getNonReplicatedPublisher, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNonReplicatedPublisherAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceStorm::TopicPrx::_iceI_getNonReplicatedPublisher, context);
    }

    ::std::function<void()>
    getNonReplicatedPublisherAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                   ::std::function<void(bool)> sent = nullptr,
                                   const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_getNonReplicatedPublisher, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getNonReplicatedPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceStorm::TopicPrx::_iceI_subscribeAndGetPublisher, iceP_theQoS, iceP_subscriber, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto subscribeAndGetPublisherAsync(const ::IceStorm::QoS& iceP_theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceStorm::TopicPrx::_iceI_subscribeAndGetPublisher, iceP_theQoS, iceP_subscriber, context);
    }

    ::std::function<void()>
    subscribeAndGetPublisherAsync(const ::IceStorm::QoS& iceP_theQoS, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber,
                                  ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_subscribeAndGetPublisher, iceP_theQoS, iceP_subscriber, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_subscribeAndGetPublisher(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::IceStorm::QoS&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void unsubscribe(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceStorm::TopicPrx::_iceI_unsubscribe, iceP_subscriber, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto unsubscribeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceStorm::TopicPrx::_iceI_unsubscribe, iceP_subscriber, context);
    }

    ::std::function<void()>
    unsubscribeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_subscriber,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_unsubscribe, iceP_subscriber, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_unsubscribe(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void link(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo, int iceP_cost, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceStorm::TopicPrx::_iceI_link, iceP_linkTo, iceP_cost, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto linkAsync(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo, int iceP_cost, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceStorm::TopicPrx::_iceI_link, iceP_linkTo, iceP_cost, context);
    }

    ::std::function<void()>
    linkAsync(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo, int iceP_cost,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_link, iceP_linkTo, iceP_cost, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_link(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::IceStorm::TopicPrx>&, int, const ::Ice::Context&);

    void unlink(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceStorm::TopicPrx::_iceI_unlink, iceP_linkTo, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto unlinkAsync(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceStorm::TopicPrx::_iceI_unlink, iceP_linkTo, context);
    }

    ::std::function<void()>
    unlinkAsync(const ::std::shared_ptr<::IceStorm::TopicPrx>& iceP_linkTo,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_unlink, iceP_linkTo, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_unlink(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::IceStorm::TopicPrx>&, const ::Ice::Context&);

    ::IceStorm::LinkInfoSeq getLinkInfoSeq(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStorm::LinkInfoSeq>(true, this, &IceStorm::TopicPrx::_iceI_getLinkInfoSeq, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLinkInfoSeqAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStorm::LinkInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceStorm::LinkInfoSeq, P>(false, this, &IceStorm::TopicPrx::_iceI_getLinkInfoSeq, context);
    }

    ::std::function<void()>
    getLinkInfoSeqAsync(::std::function<void(::IceStorm::LinkInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStorm::LinkInfoSeq>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_getLinkInfoSeq, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getLinkInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::LinkInfoSeq>>&, const ::Ice::Context&);

    ::Ice::IdentitySeq getSubscribers(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq>(true, this, &IceStorm::TopicPrx::_iceI_getSubscribers, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSubscribersAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::IdentitySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq, P>(false, this, &IceStorm::TopicPrx::_iceI_getSubscribers, context);
    }

    ::std::function<void()>
    getSubscribersAsync(::std::function<void(::Ice::IdentitySeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::IdentitySeq>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_getSubscribers, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getSubscribers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>&, const ::Ice::Context&);

    void destroy(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceStorm::TopicPrx::_iceI_destroy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceStorm::TopicPrx::_iceI_destroy, context);
    }

    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceStorm::TopicPrx::_iceI_destroy, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    TopicPrx() = default;
    friend ::std::shared_ptr<TopicPrx> IceInternal::createProxy<TopicPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICESTORM_API) TopicManagerPrx : public virtual ::Ice::Proxy<TopicManagerPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::IceStorm::TopicPrx> create(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(true, this, &IceStorm::TopicManagerPrx::_iceI_create, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>, P>(false, this, &IceStorm::TopicManagerPrx::_iceI_create, iceP_name, context);
    }

    ::std::function<void()>
    createAsync(const ::std::string& iceP_name,
                ::std::function<void(::std::shared_ptr<::IceStorm::TopicPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(response, ex, sent, this, &IceStorm::TopicManagerPrx::_iceI_create, iceP_name, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::IceStorm::TopicPrx> retrieve(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(true, this, &IceStorm::TopicManagerPrx::_iceI_retrieve, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto retrieveAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>, P>(false, this, &IceStorm::TopicManagerPrx::_iceI_retrieve, iceP_name, context);
    }

    ::std::function<void()>
    retrieveAsync(const ::std::string& iceP_name,
                  ::std::function<void(::std::shared_ptr<::IceStorm::TopicPrx>)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicPrx>>(response, ex, sent, this, &IceStorm::TopicManagerPrx::_iceI_retrieve, iceP_name, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_retrieve(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicPrx>>>&, const ::std::string&, const ::Ice::Context&);

    ::IceStorm::TopicDict retrieveAll(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceStorm::TopicDict>(true, this, &IceStorm::TopicManagerPrx::_iceI_retrieveAll, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto retrieveAllAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceStorm::TopicDict>>().get_future())
    {
        return _makePromiseOutgoing<::IceStorm::TopicDict, P>(false, this, &IceStorm::TopicManagerPrx::_iceI_retrieveAll, context);
    }

    ::std::function<void()>
    retrieveAllAsync(::std::function<void(::IceStorm::TopicDict)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceStorm::TopicDict>(response, ex, sent, this, &IceStorm::TopicManagerPrx::_iceI_retrieveAll, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_retrieveAll(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceStorm::TopicDict>>&, const ::Ice::Context&);

    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &IceStorm::TopicManagerPrx::_iceI_getSliceChecksums, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &IceStorm::TopicManagerPrx::_iceI_getSliceChecksums, context);
    }

    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(response, ex, sent, this, &IceStorm::TopicManagerPrx::_iceI_getSliceChecksums, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    TopicManagerPrx() = default;
    friend ::std::shared_ptr<TopicManagerPrx> IceInternal::createProxy<TopicManagerPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICESTORM_API) FinderPrx : public virtual ::Ice::Proxy<FinderPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::IceStorm::TopicManagerPrx> getTopicManager(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>>(true, this, &IceStorm::FinderPrx::_iceI_getTopicManager, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getTopicManagerAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicManagerPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>, P>(false, this, &IceStorm::FinderPrx::_iceI_getTopicManager, context);
    }

    ::std::function<void()>
    getTopicManagerAsync(::std::function<void(::std::shared_ptr<::IceStorm::TopicManagerPrx>)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicManagerPrx>>(response, ex, sent, this, &IceStorm::FinderPrx::_iceI_getTopicManager, context);
    }

    ICE_MEMBER(ICESTORM_API) void _iceI_getTopicManager(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicManagerPrx>>>&, const ::Ice::Context&);

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    FinderPrx() = default;
    friend ::std::shared_ptr<FinderPrx> IceInternal::createProxy<FinderPrx>();

    ICE_MEMBER(ICESTORM_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<>
struct StreamableTraits<::IceStorm::LinkInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStorm::LinkInfo, S>
{
    static void read(S* istr, ::IceStorm::LinkInfo& v)
    {
        istr->readAll(v.theTopic, v.name, v.cost);
    }
};

template<typename S>
struct StreamReader<::IceStorm::LinkExists, S>
{
    static void read(S* istr, ::IceStorm::LinkExists& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::NoSuchLink, S>
{
    static void read(S* istr, ::IceStorm::NoSuchLink& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::InvalidSubscriber, S>
{
    static void read(S* istr, ::IceStorm::InvalidSubscriber& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceStorm::BadQoS, S>
{
    static void read(S* istr, ::IceStorm::BadQoS& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceStorm::TopicExists, S>
{
    static void read(S* istr, ::IceStorm::TopicExists& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceStorm::NoSuchTopic, S>
{
    static void read(S* istr, ::IceStorm::NoSuchTopic& v)
    {
        istr->readAll(v.name);
    }
};

}

namespace IceStorm
{

using TopicPtr = ::std::shared_ptr<Topic>;
using TopicPrxPtr = ::std::shared_ptr<TopicPrx>;

using TopicManagerPtr = ::std::shared_ptr<TopicManager>;
using TopicManagerPrxPtr = ::std::shared_ptr<TopicManagerPrx>;

using FinderPtr = ::std::shared_ptr<Finder>;
using FinderPrxPtr = ::std::shared_ptr<FinderPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceStorm
{

class Topic;
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Topic>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceStorm::Topic*);

class TopicManager;
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicManager>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceStorm::TopicManager*);

class Finder;
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Finder>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceStorm::Finder*);

}

}

namespace IceStorm
{

class Topic;
ICESTORM_API ::Ice::Object* upCast(::IceStorm::Topic*);
typedef ::IceInternal::Handle< ::IceStorm::Topic> TopicPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Topic> TopicPrx;
typedef TopicPrx TopicPrxPtr;
ICESTORM_API void _icePatchObjectPtr(TopicPtr&, const ::Ice::ObjectPtr&);

class TopicManager;
ICESTORM_API ::Ice::Object* upCast(::IceStorm::TopicManager*);
typedef ::IceInternal::Handle< ::IceStorm::TopicManager> TopicManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicManager> TopicManagerPrx;
typedef TopicManagerPrx TopicManagerPrxPtr;
ICESTORM_API void _icePatchObjectPtr(TopicManagerPtr&, const ::Ice::ObjectPtr&);

class Finder;
ICESTORM_API ::Ice::Object* upCast(::IceStorm::Finder*);
typedef ::IceInternal::Handle< ::IceStorm::Finder> FinderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::Finder> FinderPrx;
typedef FinderPrx FinderPrxPtr;
ICESTORM_API void _icePatchObjectPtr(FinderPtr&, const ::Ice::ObjectPtr&);

}

namespace IceStorm
{

struct LinkInfo
{
    ::IceStorm::TopicPrx theTopic;
    ::std::string name;
    ::Ice::Int cost;
};

typedef ::std::vector< ::IceStorm::LinkInfo> LinkInfoSeq;

typedef ::std::map< ::std::string, ::std::string> QoS;

class ICESTORM_API LinkExists : public ::Ice::UserException
{
public:

    LinkExists() {}
    explicit LinkExists(const ::std::string&);
    virtual ~LinkExists() throw();

    virtual ::std::string ice_id() const;
    virtual LinkExists* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static LinkExists _iceS_LinkExists_init;

class ICESTORM_API NoSuchLink : public ::Ice::UserException
{
public:

    NoSuchLink() {}
    explicit NoSuchLink(const ::std::string&);
    virtual ~NoSuchLink() throw();

    virtual ::std::string ice_id() const;
    virtual NoSuchLink* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICESTORM_API AlreadySubscribed : public ::Ice::UserException
{
public:

    AlreadySubscribed() {}
    virtual ~AlreadySubscribed() throw();

    virtual ::std::string ice_id() const;
    virtual AlreadySubscribed* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICESTORM_API InvalidSubscriber : public ::Ice::UserException
{
public:

    InvalidSubscriber() {}
    explicit InvalidSubscriber(const ::std::string&);
    virtual ~InvalidSubscriber() throw();

    virtual ::std::string ice_id() const;
    virtual InvalidSubscriber* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICESTORM_API BadQoS : public ::Ice::UserException
{
public:

    BadQoS() {}
    explicit BadQoS(const ::std::string&);
    virtual ~BadQoS() throw();

    virtual ::std::string ice_id() const;
    virtual BadQoS* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

typedef ::std::map< ::std::string, ::IceStorm::TopicPrx> TopicDict;

class ICESTORM_API TopicExists : public ::Ice::UserException
{
public:

    TopicExists() {}
    explicit TopicExists(const ::std::string&);
    virtual ~TopicExists() throw();

    virtual ::std::string ice_id() const;
    virtual TopicExists* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICESTORM_API NoSuchTopic : public ::Ice::UserException
{
public:

    NoSuchTopic() {}
    explicit NoSuchTopic(const ::std::string&);
    virtual ~NoSuchTopic() throw();

    virtual ::std::string ice_id() const;
    virtual NoSuchTopic* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

}

namespace IceStorm
{

class Callback_Topic_getName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getName_Base> Callback_Topic_getNamePtr;

class Callback_Topic_getPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getPublisher_Base> Callback_Topic_getPublisherPtr;

class Callback_Topic_getNonReplicatedPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getNonReplicatedPublisher_Base> Callback_Topic_getNonReplicatedPublisherPtr;

class Callback_Topic_subscribeAndGetPublisher_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_subscribeAndGetPublisher_Base> Callback_Topic_subscribeAndGetPublisherPtr;

class Callback_Topic_unsubscribe_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_unsubscribe_Base> Callback_Topic_unsubscribePtr;

class Callback_Topic_link_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_link_Base> Callback_Topic_linkPtr;

class Callback_Topic_unlink_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_unlink_Base> Callback_Topic_unlinkPtr;

class Callback_Topic_getLinkInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getLinkInfoSeq_Base> Callback_Topic_getLinkInfoSeqPtr;

class Callback_Topic_getSubscribers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_getSubscribers_Base> Callback_Topic_getSubscribersPtr;

class Callback_Topic_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Topic_destroy_Base> Callback_Topic_destroyPtr;

class Callback_TopicManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_create_Base> Callback_TopicManager_createPtr;

class Callback_TopicManager_retrieve_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_retrieve_Base> Callback_TopicManager_retrievePtr;

class Callback_TopicManager_retrieveAll_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_retrieveAll_Base> Callback_TopicManager_retrieveAllPtr;

class Callback_TopicManager_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManager_getSliceChecksums_Base> Callback_TopicManager_getSliceChecksumsPtr;

class Callback_Finder_getTopicManager_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Finder_getTopicManager_Base> Callback_Finder_getTopicManagerPtr;

}

namespace IceProxy
{

namespace IceStorm
{

class ICE_CLASS(ICESTORM_API) Topic : public virtual ::Ice::Proxy<Topic, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICESTORM_API) ::std::string getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getName(_iceI_begin_getName(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getName(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getName(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getName(const ::IceStorm::Callback_Topic_getNamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getNamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::std::string end_getName(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getName(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx getPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getPublisher(_iceI_begin_getPublisher(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getPublisher(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getPublisher(const ::IceStorm::Callback_Topic_getPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getPublisher(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPublisher(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_getPublisher(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getPublisher(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx getNonReplicatedPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNonReplicatedPublisher(_iceI_begin_getNonReplicatedPublisher(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::IceStorm::Callback_Topic_getNonReplicatedPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNonReplicatedPublisher(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getNonReplicatedPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNonReplicatedPublisher(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_getNonReplicatedPublisher(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getNonReplicatedPublisher(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_subscribeAndGetPublisher(_iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::IceStorm::Callback_Topic_subscribeAndGetPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_subscribeAndGetPublisher(const ::IceStorm::QoS& iceP_theQoS, const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_subscribeAndGetPublisherPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::Ice::ObjectPrx end_subscribeAndGetPublisher(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_subscribeAndGetPublisher(const ::IceStorm::QoS&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) void unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_unsubscribe(_iceI_begin_unsubscribe(iceP_subscriber, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unsubscribe(iceP_subscriber, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(iceP_subscriber, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(iceP_subscriber, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::IceStorm::Callback_Topic_unsubscribePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(iceP_subscriber, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unsubscribe(const ::Ice::ObjectPrx& iceP_subscriber, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_unsubscribePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unsubscribe(iceP_subscriber, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) void end_unsubscribe(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_unsubscribe(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) void link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_link(_iceI_begin_link(iceP_linkTo, iceP_cost, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_link(iceP_linkTo, iceP_cost, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(iceP_linkTo, iceP_cost, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(iceP_linkTo, iceP_cost, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::IceStorm::Callback_Topic_linkPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(iceP_linkTo, iceP_cost, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_link(const ::IceStorm::TopicPrx& iceP_linkTo, ::Ice::Int iceP_cost, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_linkPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_link(iceP_linkTo, iceP_cost, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) void end_link(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_link(const ::IceStorm::TopicPrx&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) void unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_unlink(_iceI_begin_unlink(iceP_linkTo, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unlink(iceP_linkTo, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(iceP_linkTo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(iceP_linkTo, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::IceStorm::Callback_Topic_unlinkPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(iceP_linkTo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_unlink(const ::IceStorm::TopicPrx& iceP_linkTo, const ::Ice::Context& context, const ::IceStorm::Callback_Topic_unlinkPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unlink(iceP_linkTo, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) void end_unlink(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_unlink(const ::IceStorm::TopicPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::IceStorm::LinkInfoSeq getLinkInfoSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLinkInfoSeq(_iceI_begin_getLinkInfoSeq(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLinkInfoSeq(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::IceStorm::Callback_Topic_getLinkInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLinkInfoSeq(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getLinkInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkInfoSeq(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::IceStorm::LinkInfoSeq end_getLinkInfoSeq(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getLinkInfoSeq(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::Ice::IdentitySeq getSubscribers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSubscribers(_iceI_begin_getSubscribers(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSubscribers(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSubscribers(const ::IceStorm::Callback_Topic_getSubscribersPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSubscribers(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_getSubscribersPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSubscribers(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::Ice::IdentitySeq end_getSubscribers(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getSubscribers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::IceStorm::Callback_Topic_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceStorm::Callback_Topic_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) void end_destroy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICESTORM_API) TopicManager : public virtual ::Ice::Proxy<TopicManager, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx create(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_name, const ::IceStorm::Callback_TopicManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx end_create(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx retrieve(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_retrieve(_iceI_begin_retrieve(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_retrieve(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& iceP_name, const ::IceStorm::Callback_TopicManager_retrievePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieve(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_retrievePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieve(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicPrx end_retrieve(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_retrieve(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicDict retrieveAll(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_retrieveAll(_iceI_begin_retrieveAll(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_retrieveAll(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieveAll(const ::IceStorm::Callback_TopicManager_retrieveAllPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_retrieveAll(const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_retrieveAllPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_retrieveAll(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicDict end_retrieveAll(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_retrieveAll(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceStorm::Callback_TopicManager_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceStorm::Callback_TopicManager_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICESTORM_API) Finder : public virtual ::Ice::Proxy<Finder, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicManagerPrx getTopicManager(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTopicManager(_iceI_begin_getTopicManager(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTopicManager(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getTopicManager(const ::IceStorm::Callback_Finder_getTopicManagerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getTopicManager(const ::Ice::Context& context, const ::IceStorm::Callback_Finder_getTopicManagerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTopicManager(context, del, cookie);
    }

    ICE_MEMBER(ICESTORM_API) ::IceStorm::TopicManagerPrx end_getTopicManager(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICESTORM_API) ::Ice::AsyncResultPtr _iceI_begin_getTopicManager(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceStorm
{

class ICESTORM_API Topic : public virtual ::Ice::Object
{
public:

    typedef TopicPrx ProxyType;
    typedef TopicPtr PointerType;

    virtual ~Topic();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::std::string getName(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getPublisher(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getNonReplicatedPublisher(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNonReplicatedPublisher(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx subscribeAndGetPublisher(const ::IceStorm::QoS&, const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_subscribeAndGetPublisher(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void unsubscribe(const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_unsubscribe(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void link(const ::IceStorm::TopicPrx&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_link(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void unlink(const ::IceStorm::TopicPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_unlink(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceStorm::LinkInfoSeq getLinkInfoSeq(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getLinkInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::IdentitySeq getSubscribers(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSubscribers(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void destroy(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Topic& lhs, const Topic& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Topic& lhs, const Topic& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICESTORM_API TopicManager : public virtual ::Ice::Object
{
public:

    typedef TopicManagerPrx ProxyType;
    typedef TopicManagerPtr PointerType;

    virtual ~TopicManager();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::IceStorm::TopicPrx create(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceStorm::TopicPrx retrieve(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_retrieve(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceStorm::TopicDict retrieveAll(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_retrieveAll(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const TopicManager& lhs, const TopicManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicManager& lhs, const TopicManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICESTORM_API Finder : public virtual ::Ice::Object
{
public:

    typedef FinderPrx ProxyType;
    typedef FinderPtr PointerType;

    virtual ~Finder();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::IceStorm::TopicManagerPrx getTopicManager(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getTopicManager(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Finder& lhs, const Finder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Finder& lhs, const Finder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceStorm::LinkInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStorm::LinkInfo, S>
{
    static void write(S* ostr, const ::IceStorm::LinkInfo& v)
    {
        ostr->write(v.theTopic);
        ostr->write(v.name);
        ostr->write(v.cost);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::LinkInfo, S>
{
    static void read(S* istr, ::IceStorm::LinkInfo& v)
    {
        istr->read(v.theTopic);
        istr->read(v.name);
        istr->read(v.cost);
    }
};

template<>
struct StreamableTraits< ::IceStorm::LinkExists>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::LinkExists, S>
{
    static void write(S* ostr, const ::IceStorm::LinkExists& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::LinkExists, S>
{
    static void read(S* istr, ::IceStorm::LinkExists& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::NoSuchLink>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::NoSuchLink, S>
{
    static void write(S* ostr, const ::IceStorm::NoSuchLink& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::NoSuchLink, S>
{
    static void read(S* istr, ::IceStorm::NoSuchLink& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::AlreadySubscribed>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceStorm::InvalidSubscriber>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::InvalidSubscriber, S>
{
    static void write(S* ostr, const ::IceStorm::InvalidSubscriber& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::InvalidSubscriber, S>
{
    static void read(S* istr, ::IceStorm::InvalidSubscriber& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStorm::BadQoS>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::BadQoS, S>
{
    static void write(S* ostr, const ::IceStorm::BadQoS& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::BadQoS, S>
{
    static void read(S* istr, ::IceStorm::BadQoS& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceStorm::TopicExists>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::TopicExists, S>
{
    static void write(S* ostr, const ::IceStorm::TopicExists& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::TopicExists, S>
{
    static void read(S* istr, ::IceStorm::TopicExists& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceStorm::NoSuchTopic>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceStorm::NoSuchTopic, S>
{
    static void write(S* ostr, const ::IceStorm::NoSuchTopic& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::NoSuchTopic, S>
{
    static void read(S* istr, ::IceStorm::NoSuchTopic& v)
    {
        istr->read(v.name);
    }
};

}

namespace IceStorm
{

template<class T>
class CallbackNC_Topic_getName : public Callback_Topic_getName_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Topic_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_getNamePtr
newCallback_Topic_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getName<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_getNamePtr
newCallback_Topic_getName(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getName<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_getName : public Callback_Topic_getName_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Topic_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_getNamePtr
newCallback_Topic_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getName<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_getNamePtr
newCallback_Topic_getName(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getName<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_getPublisher : public Callback_Topic_getPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_getPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getPublisher<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getPublisher<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_getPublisher : public Callback_Topic_getPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_getPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_getPublisherPtr
newCallback_Topic_getPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_getNonReplicatedPublisher : public Callback_Topic_getNonReplicatedPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_getNonReplicatedPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNonReplicatedPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getNonReplicatedPublisher<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getNonReplicatedPublisher<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_getNonReplicatedPublisher : public Callback_Topic_getNonReplicatedPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_getNonReplicatedPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNonReplicatedPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getNonReplicatedPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_getNonReplicatedPublisherPtr
newCallback_Topic_getNonReplicatedPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getNonReplicatedPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_subscribeAndGetPublisher : public Callback_Topic_subscribeAndGetPublisher_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Topic_subscribeAndGetPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_subscribeAndGetPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_subscribeAndGetPublisher<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_subscribeAndGetPublisher<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_subscribeAndGetPublisher : public Callback_Topic_subscribeAndGetPublisher_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Topic_subscribeAndGetPublisher(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_subscribeAndGetPublisher(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_subscribeAndGetPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_subscribeAndGetPublisherPtr
newCallback_Topic_subscribeAndGetPublisher(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_subscribeAndGetPublisher<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_unsubscribe : public Callback_Topic_unsubscribe_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_unsubscribe(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unsubscribe<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_unsubscribe : public Callback_Topic_unsubscribe_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_unsubscribe(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unsubscribePtr
newCallback_Topic_unsubscribe(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unsubscribe<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_link : public Callback_Topic_link_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_link(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_link(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_link<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_link : public Callback_Topic_link_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_link(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_link(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_linkPtr
newCallback_Topic_link(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_link<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_unlink : public Callback_Topic_unlink_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_unlink(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_unlink(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_unlink<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_unlink : public Callback_Topic_unlink_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_unlink(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_unlink(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_unlinkPtr
newCallback_Topic_unlink(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_unlink<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_getLinkInfoSeq : public Callback_Topic_getLinkInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStorm::LinkInfoSeq&);

    CallbackNC_Topic_getLinkInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::IceStorm::LinkInfoSeq ret;
        try
        {
            ret = proxy->end_getLinkInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::LinkInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getLinkInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(T* instance, void (T::*cb)(const ::IceStorm::LinkInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getLinkInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_getLinkInfoSeq : public Callback_Topic_getLinkInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStorm::LinkInfoSeq&, const CT&);

    Callback_Topic_getLinkInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::IceStorm::LinkInfoSeq ret;
        try
        {
            ret = proxy->end_getLinkInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::LinkInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getLinkInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_getLinkInfoSeqPtr
newCallback_Topic_getLinkInfoSeq(T* instance, void (T::*cb)(const ::IceStorm::LinkInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getLinkInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_getSubscribers : public Callback_Topic_getSubscribers_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&);

    CallbackNC_Topic_getSubscribers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_getSubscribers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getSubscribers<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_getSubscribers<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_getSubscribers : public Callback_Topic_getSubscribers_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&, const CT&);

    Callback_Topic_getSubscribers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicPrx proxy = ::IceStorm::TopicPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_getSubscribers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getSubscribers<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_getSubscribersPtr
newCallback_Topic_getSubscribers(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_getSubscribers<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Topic_destroy : public Callback_Topic_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Topic_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Topic_destroy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Topic_destroy : public Callback_Topic_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Topic_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Topic_destroyPtr
newCallback_Topic_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Topic_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_TopicManager_create : public Callback_TopicManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStorm::TopicPrx&);

    CallbackNC_TopicManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_TopicManager_createPtr
newCallback_TopicManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_create<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_TopicManager_createPtr
newCallback_TopicManager_create(T* instance, void (T::*cb)(const ::IceStorm::TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_create<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_TopicManager_create : public Callback_TopicManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStorm::TopicPrx&, const CT&);

    Callback_TopicManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_TopicManager_createPtr
newCallback_TopicManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_create<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_TopicManager_createPtr
newCallback_TopicManager_create(T* instance, void (T::*cb)(const ::IceStorm::TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_create<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_TopicManager_retrieve : public Callback_TopicManager_retrieve_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStorm::TopicPrx&);

    CallbackNC_TopicManager_retrieve(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicPrx ret;
        try
        {
            ret = proxy->end_retrieve(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieve<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(T* instance, void (T::*cb)(const ::IceStorm::TopicPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieve<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_TopicManager_retrieve : public Callback_TopicManager_retrieve_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStorm::TopicPrx&, const CT&);

    Callback_TopicManager_retrieve(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicPrx ret;
        try
        {
            ret = proxy->end_retrieve(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieve<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_TopicManager_retrievePtr
newCallback_TopicManager_retrieve(T* instance, void (T::*cb)(const ::IceStorm::TopicPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieve<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_TopicManager_retrieveAll : public Callback_TopicManager_retrieveAll_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStorm::TopicDict&);

    CallbackNC_TopicManager_retrieveAll(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicDict ret;
        try
        {
            ret = proxy->end_retrieveAll(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieveAll<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(T* instance, void (T::*cb)(const ::IceStorm::TopicDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_retrieveAll<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_TopicManager_retrieveAll : public Callback_TopicManager_retrieveAll_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStorm::TopicDict&, const CT&);

    Callback_TopicManager_retrieveAll(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicDict ret;
        try
        {
            ret = proxy->end_retrieveAll(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieveAll<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_TopicManager_retrieveAllPtr
newCallback_TopicManager_retrieveAll(T* instance, void (T::*cb)(const ::IceStorm::TopicDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_retrieveAll<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_TopicManager_getSliceChecksums : public Callback_TopicManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&);

    CallbackNC_TopicManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_TopicManager_getSliceChecksums : public Callback_TopicManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&, const CT&);

    Callback_TopicManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::TopicManagerPrx proxy = ::IceStorm::TopicManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_TopicManager_getSliceChecksumsPtr
newCallback_TopicManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Finder_getTopicManager : public Callback_Finder_getTopicManager_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStorm::TopicManagerPrx&);

    CallbackNC_Finder_getTopicManager(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::FinderPrx proxy = ::IceStorm::FinderPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicManagerPrx ret;
        try
        {
            ret = proxy->end_getTopicManager(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicManagerPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Finder_getTopicManager<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(T* instance, void (T::*cb)(const ::IceStorm::TopicManagerPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Finder_getTopicManager<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Finder_getTopicManager : public Callback_Finder_getTopicManager_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStorm::TopicManagerPrx&, const CT&);

    Callback_Finder_getTopicManager(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceStorm::FinderPrx proxy = ::IceStorm::FinderPrx::uncheckedCast(result->getProxy());
        ::IceStorm::TopicManagerPrx ret;
        try
        {
            ret = proxy->end_getTopicManager(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStorm::TopicManagerPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Finder_getTopicManager<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Finder_getTopicManagerPtr
newCallback_Finder_getTopicManager(T* instance, void (T::*cb)(const ::IceStorm::TopicManagerPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Finder_getTopicManager<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
