/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildOption<T>
implements BuildOption<T> {
    protected final String gradleProperty;
    protected final List<CommandLineOptionConfiguration> commandLineOptionConfigurations;

    public AbstractBuildOption(String gradleProperty) {
        this(gradleProperty, new CommandLineOptionConfiguration[0]);
    }

    public AbstractBuildOption(String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfiguration) {
        this.gradleProperty = gradleProperty;
        this.commandLineOptionConfigurations = commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList();
    }

    @Override
    public String getGradleProperty() {
        return this.gradleProperty;
    }

    protected boolean isTrue(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, String deprecationWarning, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description).deprecated(deprecationWarning);
        if (incubating) {
            option.incubating();
        }
        return option;
    }
}

