/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifThumbnailDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class ExifThumbnailDirectory
extends ExifDirectoryBase {
    public static final int TAG_THUMBNAIL_OFFSET = 513;
    public static final int TAG_THUMBNAIL_LENGTH = 514;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();
    @Nullable
    private byte[] _thumbnailData;

    public ExifThumbnailDirectory() {
        this.setDescriptor(new ExifThumbnailDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Exif Thumbnail";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    public boolean hasThumbnailData() {
        return this._thumbnailData != null;
    }

    @Nullable
    public byte[] getThumbnailData() {
        return this._thumbnailData;
    }

    public void setThumbnailData(@Nullable byte[] data) {
        this._thumbnailData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeThumbnail(@NotNull String filename) throws MetadataException, IOException {
        byte[] data = this._thumbnailData;
        if (data == null) {
            throw new MetadataException("No thumbnail data exists.");
        }
        try (FileOutputStream stream = null;){
            stream = new FileOutputStream(filename);
            stream.write(data);
        }
    }

    static {
        ExifThumbnailDirectory.addExifTagNames(_tagNameMap);
        _tagNameMap.put(513, "Thumbnail Offset");
        _tagNameMap.put(514, "Thumbnail Length");
    }
}

