/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.IndexMetaDataUpdater;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.StaleShard;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayAllocator;

public class AllocationService
extends AbstractComponent {
    private final AllocationDeciders allocationDeciders;
    private GatewayAllocator gatewayAllocator;
    private final ShardsAllocator shardsAllocator;
    private final ClusterInfoService clusterInfoService;

    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService) {
        this(settings, allocationDeciders, shardsAllocator, clusterInfoService);
        this.setGatewayAllocator(gatewayAllocator);
    }

    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService) {
        super(settings);
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocator = shardsAllocator;
        this.clusterInfoService = clusterInfoService;
    }

    public void setGatewayAllocator(GatewayAllocator gatewayAllocator) {
        this.gatewayAllocator = gatewayAllocator;
    }

    public ClusterState applyStartedShards(ClusterState clusterState, List<ShardRouting> startedShards) {
        if (startedShards.isEmpty()) {
            return clusterState;
        }
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.currentNanoTime(), false);
        startedShards = new ArrayList<ShardRouting>(startedShards);
        Collections.sort(startedShards, Comparator.comparing(ShardRouting::primary));
        this.applyStartedShards(allocation, startedShards);
        this.gatewayAllocator.applyStartedShards(allocation, startedShards);
        this.reroute(allocation);
        String startedShardsAsString = this.firstListElementsToCommaDelimitedString(startedShards, s -> s.shardId().toString());
        return this.buildResultAndLogHealthChange(clusterState, allocation, "shards started [" + startedShardsAsString + "] ...");
    }

    protected ClusterState buildResultAndLogHealthChange(ClusterState oldState, RoutingAllocation allocation, String reason) {
        RestoreInProgress updatedRestoreInProgress;
        RoutingTable oldRoutingTable = oldState.routingTable();
        RoutingNodes newRoutingNodes = allocation.routingNodes();
        RoutingTable newRoutingTable = new RoutingTable.Builder().updateNodes(oldRoutingTable.version(), newRoutingNodes).build();
        MetaData newMetaData = allocation.updateMetaDataWithRoutingChanges(newRoutingTable);
        assert (newRoutingTable.validate(newMetaData));
        ClusterState.Builder newStateBuilder = ClusterState.builder(oldState).routingTable(newRoutingTable).metaData(newMetaData);
        RestoreInProgress restoreInProgress = (RestoreInProgress)allocation.custom("restore");
        if (restoreInProgress != null && (updatedRestoreInProgress = allocation.updateRestoreInfoWithRoutingChanges(restoreInProgress)) != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> customsBuilder = ImmutableOpenMap.builder(allocation.getCustoms());
            customsBuilder.put("restore", updatedRestoreInProgress);
            newStateBuilder.customs(customsBuilder.build());
        }
        ClusterState newState = newStateBuilder.build();
        this.logClusterHealthStateChange(new ClusterStateHealth(oldState), new ClusterStateHealth(newState), reason);
        return newState;
    }

    public ClusterState applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        return this.applyFailedShards(clusterState, Collections.singletonList(new FailedShard(failedShard, null, null)), Collections.emptyList());
    }

    public ClusterState applyFailedShards(ClusterState clusterState, List<FailedShard> failedShards) {
        return this.applyFailedShards(clusterState, failedShards, Collections.emptyList());
    }

    public ClusterState applyFailedShards(ClusterState clusterState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
        if (staleShards.isEmpty() && failedShards.isEmpty()) {
            return clusterState;
        }
        ClusterState tmpState = IndexMetaDataUpdater.removeStaleIdsWithoutRoutings(clusterState, staleShards);
        RoutingNodes routingNodes = this.getMutableRoutingNodes(tmpState);
        routingNodes.unassigned().shuffle();
        long currentNanoTime = this.currentNanoTime();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, tmpState, this.clusterInfoService.getClusterInfo(), currentNanoTime, false);
        for (FailedShard failedShardEntry : failedShards) {
            ShardRouting shardToFail = failedShardEntry.getRoutingEntry();
            IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(shardToFail.shardId().getIndex());
            allocation.addIgnoreShardForNode(shardToFail.shardId(), shardToFail.currentNodeId());
            ShardRouting failedShard = routingNodes.getByAllocationId(shardToFail.shardId(), shardToFail.allocationId().getId());
            if (failedShard != null) {
                if (failedShard != shardToFail) {
                    this.logger.trace("{} shard routing modified in an earlier iteration (previous: {}, current: {})", (Object)shardToFail.shardId(), (Object)shardToFail, (Object)failedShard);
                }
                int failedAllocations = failedShard.unassignedInfo() != null ? failedShard.unassignedInfo().getNumFailedAllocations() : 0;
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, failedShardEntry.getMessage(), failedShardEntry.getFailure(), failedAllocations + 1, currentNanoTime, System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT);
                routingNodes.failShard(this.logger, failedShard, unassignedInfo, indexMetaData, allocation.changes());
                continue;
            }
            this.logger.trace("{} shard routing failed in an earlier iteration (routing: {})", (Object)shardToFail.shardId(), (Object)shardToFail);
        }
        this.gatewayAllocator.applyFailedShards(allocation, failedShards);
        this.reroute(allocation);
        String failedShardsAsString = this.firstListElementsToCommaDelimitedString(failedShards, s -> s.getRoutingEntry().shardId().toString());
        return this.buildResultAndLogHealthChange(clusterState, allocation, "shards failed [" + failedShardsAsString + "] ...");
    }

    public ClusterState deassociateDeadNodes(ClusterState clusterState, boolean reroute, String reason) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.currentNanoTime(), false);
        this.deassociateDeadNodes(allocation);
        if (reroute) {
            this.reroute(allocation);
        }
        if (!allocation.routingNodesChanged()) {
            return clusterState;
        }
        return this.buildResultAndLogHealthChange(clusterState, allocation, reason);
    }

    private void removeDelayMarkers(RoutingAllocation allocation) {
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
        MetaData metaData = allocation.metaData();
        while (unassignedIterator.hasNext()) {
            long newComputedLeftDelayNanos;
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!unassignedInfo.isDelayed() || (newComputedLeftDelayNanos = unassignedInfo.getRemainingDelay(allocation.getCurrentNanoTime(), metaData.getIndexSafe(shardRouting.index()).getSettings())) != 0L) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), false, unassignedInfo.getLastAllocationStatus()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    private <T> String firstListElementsToCommaDelimitedString(List<T> elements, Function<T, String> formatter) {
        int maxNumberOfElements = 10;
        return elements.stream().limit(10L).map(formatter).collect(Collectors.joining(", "));
    }

    public CommandsResult reroute(ClusterState clusterState, AllocationCommands commands, boolean explain, boolean retryFailed) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.currentNanoTime(), retryFailed);
        allocation.debugDecision(true);
        allocation.ignoreDisable(true);
        RoutingExplanations explanations = commands.execute(allocation, explain);
        allocation.ignoreDisable(false);
        this.reroute(allocation);
        return new CommandsResult(explanations, this.buildResultAndLogHealthChange(clusterState, allocation, "reroute commands"));
    }

    public ClusterState reroute(ClusterState clusterState, String reason) {
        return this.reroute(clusterState, reason, false);
    }

    protected ClusterState reroute(ClusterState clusterState, String reason, boolean debug) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.currentNanoTime(), false);
        allocation.debugDecision(debug);
        this.reroute(allocation);
        if (!allocation.routingNodesChanged()) {
            return clusterState;
        }
        return this.buildResultAndLogHealthChange(clusterState, allocation, reason);
    }

    private void logClusterHealthStateChange(ClusterStateHealth previousStateHealth, ClusterStateHealth newStateHealth, String reason) {
        ClusterHealthStatus currentHealth;
        ClusterHealthStatus previousHealth = previousStateHealth.getStatus();
        if (!previousHealth.equals(currentHealth = newStateHealth.getStatus())) {
            this.logger.info("Cluster health status changed from [{}] to [{}] (reason: [{}]).", (Object)previousHealth, (Object)currentHealth, (Object)reason);
        }
    }

    private boolean hasDeadNodes(RoutingAllocation allocation) {
        for (RoutingNode routingNode : allocation.routingNodes()) {
            if (allocation.nodes().getDataNodes().containsKey(routingNode.nodeId())) continue;
            return true;
        }
        return false;
    }

    private void reroute(RoutingAllocation allocation) {
        assert (!this.hasDeadNodes(allocation)) : "dead nodes should be explicitly cleaned up. See deassociateDeadNodes";
        if (allocation.routingNodes().unassigned().size() > 0) {
            this.removeDelayMarkers(allocation);
            this.gatewayAllocator.allocateUnassigned(allocation);
        }
        this.shardsAllocator.allocate(allocation);
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
    }

    private void deassociateDeadNodes(RoutingAllocation allocation) {
        Iterator<RoutingNode> it = allocation.routingNodes().mutableIterator();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().getDataNodes().containsKey(node.nodeId())) continue;
            for (ShardRouting shardRouting : node.copyShards()) {
                IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(shardRouting.index());
                boolean delayed = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetaData.getSettings()).nanos() > 0L;
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NODE_LEFT, "node_left[" + node.nodeId() + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), delayed, UnassignedInfo.AllocationStatus.NO_ATTEMPT);
                allocation.routingNodes().failShard(this.logger, shardRouting, unassignedInfo, indexMetaData, allocation.changes());
            }
            it.remove();
        }
    }

    private void applyStartedShards(RoutingAllocation routingAllocation, List<ShardRouting> startedShardEntries) {
        assert (!startedShardEntries.isEmpty()) : "non-empty list of started shard entries expected";
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        for (ShardRouting startedShard : startedShardEntries) {
            assert (startedShard.initializing()) : "only initializing shards can be started";
            assert (routingAllocation.metaData().index(startedShard.shardId().getIndex()) != null) : "shard started for unknown index (shard entry: " + startedShard + ")";
            assert (startedShard == routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId())) : "shard routing to start does not exist in routing table, expected: " + startedShard + " but was: " + routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId());
            routingNodes.startShard(this.logger, startedShard, routingAllocation.changes());
        }
    }

    private RoutingNodes getMutableRoutingNodes(ClusterState clusterState) {
        RoutingNodes routingNodes = new RoutingNodes(clusterState, false);
        return routingNodes;
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }

    public static class CommandsResult {
        private final RoutingExplanations explanations;
        private final ClusterState clusterState;

        private CommandsResult(RoutingExplanations explanations, ClusterState clusterState) {
            this.clusterState = clusterState;
            this.explanations = explanations;
        }

        public RoutingExplanations explanations() {
            return this.explanations;
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }
    }
}

