/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class ReportUnitPanel
extends ReportPanel {
    private final List<Unit> inEurope = new ArrayList<Unit>();
    private final Map<Colony, List<Unit>> inColonies = new HashMap<Colony, List<Unit>>();
    private final Map<String, List<Unit>> inLocations = new HashMap<String, List<Unit>>();
    private final Map<String, TypeCountMap<UnitType>> units = new HashMap<String, TypeCountMap<UnitType>>();
    private boolean showColonies = false;

    public ReportUnitPanel(FreeColClient freeColClient, String key, boolean showColonies) {
        super(freeColClient, key);
        this.showColonies = showColonies;
        this.reportPanel.setLayout(new MigLayout("fillx, wrap 12", "", ""));
        this.gatherData();
        this.addREFUnits();
        this.addOwnUnits();
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx, wrap 40");
        for (Colony colony : freeColClient.getMySortedColonies()) {
            this.handleLocation(colony, colony.getName(), this.inColonies.get(colony));
        }
        Europe europe = this.getMyPlayer().getEurope();
        if (europe != null) {
            this.handleLocation(europe, Messages.getName(europe), this.inEurope);
        }
        ArrayList<String> otherNames = new ArrayList<String>(this.inLocations.keySet());
        Collections.sort(otherNames);
        for (Map.Entry<String, List<Unit>> e : CollectionUtils.mapEntriesByKey(this.inLocations)) {
            this.handleLocation(null, e.getKey(), e.getValue());
        }
        this.revalidate();
        this.repaint();
    }

    protected int getCount(String key, UnitType type) {
        TypeCountMap<UnitType> map = this.units.get(key);
        return map == null ? 0 : map.getCount(type);
    }

    protected void incrementCount(String key, UnitType type, int number) {
        TypeCountMap<UnitType> map = this.units.get(key);
        if (map == null) {
            map = new TypeCountMap();
            this.units.put(key, map);
        }
        map.incrementCount(type, number);
    }

    protected void addUnit(Unit unit, String key) {
        if (unit.getLocation() == null) {
            return;
        }
        if (unit.isInEurope()) {
            this.inEurope.add(unit);
        } else {
            Colony colony = unit.getLocation().getColony();
            if (colony == null) {
                String locationName = this.getLocationLabelFor(unit);
                List<Unit> unitList = this.inLocations.get(locationName);
                if (unitList == null) {
                    unitList = new ArrayList<Unit>();
                    this.inLocations.put(locationName, unitList);
                }
                unitList.add(unit);
            } else {
                List<Unit> unitList = this.inColonies.get(colony);
                if (unitList == null) {
                    unitList = new ArrayList<Unit>();
                    this.inColonies.put(colony, unitList);
                }
                unitList.add(unit);
            }
        }
        this.incrementCount(key, unit.getType(), 1);
    }

    protected void handleLocation(Location location, String locationName, List<Unit> unitList) {
        JComponent component;
        if ((unitList == null || unitList.isEmpty()) && !this.showColonies) {
            return;
        }
        if (location == null) {
            component = new JLabel(locationName);
        } else {
            JButton button = Utility.getLinkButton(locationName, null, location.getId());
            button.addActionListener(this);
            component = button;
        }
        this.reportPanel.add((Component)component, "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        if (unitList == null || unitList.isEmpty()) {
            this.reportPanel.add((Component)Utility.localizedLabel("none"), "sg");
        } else {
            for (Unit u : unitList.stream().sorted(Unit.typeRoleComparator).collect(Collectors.toList())) {
                JButton unitButton = this.getUnitButton(u);
                if (u.isCarrier()) {
                    this.reportPanel.add((Component)unitButton, "newline, sg");
                    for (Goods goods : u.getGoodsList()) {
                        GoodsLabel goodsLabel = new GoodsLabel(this.getGUI(), goods);
                        this.reportPanel.add(goodsLabel);
                    }
                    for (Unit unitLoaded : u.getUnitList()) {
                        UnitLabel unitLoadedLabel = new UnitLabel(this.getFreeColClient(), unitLoaded, true);
                        this.reportPanel.add(unitLoadedLabel);
                    }
                    continue;
                }
                this.reportPanel.add((Component)unitButton, "sg");
            }
        }
    }

    protected JButton getUnitButton(Unit unit) {
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getUnitImage(unit));
        JButton button = Utility.getLinkButton("", icon, unit.getLocation().getId());
        button.addActionListener(this);
        StringTemplate tip = StringTemplate.label("\n").addStringTemplate(unit.getLabel());
        if (unit.getDestination() != null) {
            tip.addStringTemplate(unit.getDestinationLabel());
        }
        Utility.localizeToolTip((JComponent)button, tip);
        return button;
    }

    protected abstract void gatherData();

    protected abstract void addREFUnits();

    protected abstract void addOwnUnits();
}

