/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.geonames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.fibs.geotag.geonames.GeonamesService;
import org.fibs.geotag.util.Proxies;
import org.xml.sax.helpers.DefaultHandler;

public class AltitudeHandler
extends DefaultHandler {
    private String altitude = null;

    public AltitudeHandler(String latitude, String longitude) {
        try {
            GeonamesService service = new GeonamesService("srtm3");
            service.addParameter("lat", latitude);
            service.addParameter("lng", longitude);
            String url = service.buildURL();
            System.out.println(url);
            URL request = new URL(url);
            URLConnection connection = request.openConnection(Proxies.getProxy());
            connection.setReadTimeout(30000);
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            this.altitude = reader.readLine();
            reader.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getAltitude() {
        return this.altitude;
    }
}

