/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import com.google.common.base.Joiner;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class ArtifactRepositoryPluginResolver
implements PluginResolver {
    public static final String PLUGIN_MARKER_SUFFIX = ".gradle.plugin";
    private String name;
    private final DependencyResolutionServices resolution;
    private final VersionSelectorScheme versionSelectorScheme;

    public ArtifactRepositoryPluginResolver(String name, DependencyResolutionServices resolution, VersionSelectorScheme versionSelectorScheme) {
        this.name = name;
        this.resolution = resolution;
        this.versionSelectorScheme = versionSelectorScheme;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        String markerVersion = this.getMarkerDependency(pluginRequest).getVersion();
        if (markerVersion == null) {
            result.notFound(this.name, "plugin dependency must include a version number for this source");
            return;
        }
        if (markerVersion.endsWith("-SNAPSHOT")) {
            result.notFound(this.name, "snapshot plugin versions are not supported");
            return;
        }
        if (this.versionSelectorScheme.parseSelector(markerVersion).isDynamic()) {
            result.notFound(this.name, "dynamic plugin versions are not supported");
            return;
        }
        if (this.exists(pluginRequest)) {
            this.handleFound(pluginRequest, result);
        } else {
            this.handleNotFound(pluginRequest, result);
        }
    }

    private boolean exists(PluginRequestInternal request) {
        Dependency dependency = this.resolution.getDependencyHandler().create((Object)this.getMarkerDependency(request));
        ConfigurationContainer configurations = this.resolution.getConfigurationContainer();
        Configuration configuration = configurations.detachedConfiguration(new Dependency[]{dependency});
        configuration.setTransitive(false);
        return !configuration.getResolvedConfiguration().hasError();
    }

    private void handleFound(final PluginRequestInternal pluginRequest, PluginResolutionResult result) {
        result.found(this.name, new PluginResolution(){

            @Override
            public PluginId getPluginId() {
                return pluginRequest.getId();
            }

            public void execute(PluginResolveContext context) {
                context.addLegacy(pluginRequest.getId(), ArtifactRepositoryPluginResolver.this.getMarkerDependency(pluginRequest));
            }
        });
    }

    private void handleNotFound(PluginRequestInternal pluginRequest, PluginResolutionResult result) {
        result.notFound(this.name, String.format("Could not resolve plugin artifact '%s'", this.getNotation(this.getMarkerDependency(pluginRequest))));
    }

    private Dependency getMarkerDependency(PluginRequestInternal pluginRequest) {
        ModuleVersionSelector selector = pluginRequest.getModule();
        if (selector == null) {
            String id = pluginRequest.getId().getId();
            return new DefaultExternalModuleDependency(id, id + PLUGIN_MARKER_SUFFIX, pluginRequest.getVersion());
        }
        return new DefaultExternalModuleDependency(selector.getGroup(), selector.getName(), selector.getVersion());
    }

    private String getNotation(Dependency dependency) {
        return Joiner.on((char)':').join((Object)dependency.getGroup(), (Object)dependency.getName(), new Object[]{dependency.getVersion()});
    }
}

