/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.FileUtils;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.AbstractCompiler;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;

class SwiftCompiler
extends AbstractCompiler<SwiftCompileSpec> {
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final String objectFileExtension;

    SwiftCompiler(BuildOperationExecutor buildOperationExecutor, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, String objectFileExtension, WorkerLeaseService workerLeaseService) {
        super(buildOperationExecutor, commandLineToolInvocationWorker, invocationContext, new SwiftCompileArgsTransformer(), false, workerLeaseService);
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.objectFileExtension = objectFileExtension;
    }

    @Override
    protected void addOptionsFileArgs(List<String> args, File tempDir) {
    }

    protected File getOutputFileDir(File sourceFile, File objectFileDir, String fileSuffix) {
        boolean windowsPathLimitation = OperatingSystem.current().isWindows();
        File outputFile = this.compilerOutputFileNamingSchemeFactory.create().withObjectFileNameSuffix(fileSuffix).withOutputBaseFolder(objectFileDir).map(sourceFile);
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        return windowsPathLimitation ? FileUtils.assertInWindowsPathLengthLimitation((File)outputFile) : outputFile;
    }

    @Override
    protected Action<BuildOperationQueue<CommandLineToolInvocation>> newInvocationAction(final SwiftCompileSpec spec, final List<String> genericArgs) {
        final File objectDir = spec.getObjectFileDir();
        return new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                OutputFileMap outputFileMap = new OutputFileMap();
                for (File sourceFile : spec.getSourceFiles()) {
                    outputFileMap.newEntry(sourceFile.getAbsolutePath()).dependencyFile(SwiftCompiler.this.getOutputFileDir(sourceFile, objectDir, ".d")).objectFile(SwiftCompiler.this.getOutputFileDir(sourceFile, objectDir, SwiftCompiler.this.objectFileExtension)).swiftModuleFile(SwiftCompiler.this.getOutputFileDir(sourceFile, objectDir, "~partial.swiftmodule")).swiftDependenciesFile(SwiftCompiler.this.getOutputFileDir(sourceFile, objectDir, ".swiftdeps")).diagnosticsFile(SwiftCompiler.this.getOutputFileDir(sourceFile, objectDir, ".dia"));
                    genericArgs.add(sourceFile.getAbsolutePath());
                }
                if (null != spec.getModuleName()) {
                    genericArgs.add("-emit-module");
                    genericArgs.add("-module-name");
                    genericArgs.add(spec.getModuleName());
                    outputFileMap.newEntry("").swiftModuleFile(new File(spec.getObjectFileDir(), spec.getModuleName() + ".swiftmodule"));
                }
                genericArgs.add("-v");
                genericArgs.add("-emit-object");
                File outputFileMapFile = new File(spec.getObjectFileDir(), "output-file-map.json");
                outputFileMap.writeToFile(outputFileMapFile);
                ArrayList outputArgs = Lists.newArrayList();
                outputArgs.add("-output-file-map");
                outputArgs.add(outputFileMapFile.getAbsolutePath());
                ArrayList importRootArgs = Lists.newArrayList();
                for (File importRoot : spec.getIncludeRoots()) {
                    importRootArgs.add("-I");
                    importRootArgs.add(importRoot.getAbsolutePath());
                }
                if (spec.isDebuggable()) {
                    genericArgs.add("-g");
                }
                if (spec.isOptimized()) {
                    genericArgs.add("-O");
                }
                CommandLineToolInvocation perFileInvocation = SwiftCompiler.this.newInvocation("compiling swift file(s)", objectDir, Iterables.concat((Iterable)genericArgs, (Iterable)outputArgs, (Iterable)importRootArgs), spec.getOperationLogger());
                buildQueue.add((BuildOperation)perFileInvocation);
            }
        };
    }

    private static class OutputFileMap {
        private Map<String, Entry> entries = new HashMap<String, Entry>();

        private OutputFileMap() {
        }

        public Builder newEntry(String name) {
            Entry entry = new Entry();
            this.entries.put(name, entry);
            return new Builder(entry);
        }

        private void toJson(Appendable writer) {
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).setPrettyPrinting().create();
            gson.toJson(this.entries, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToFile(File outputFile) {
            try {
                PrintWriter writer = new PrintWriter(outputFile);
                try {
                    this.toJson(writer);
                }
                finally {
                    IOUtils.closeQuietly((Writer)writer);
                }
            }
            catch (FileNotFoundException ex) {
                throw new UncheckedIOException((Throwable)ex);
            }
        }

        private static class Entry {
            private String dependencies;
            private String object;
            private String swiftmodule;
            private String swiftDependencies;
            private String diagnostics;

            private Entry() {
            }
        }

        private static class Builder {
            private final Entry entry;

            Builder(Entry entry) {
                this.entry = entry;
            }

            public Builder dependencyFile(File dependencyFile) {
                this.entry.dependencies = dependencyFile.getAbsolutePath();
                return this;
            }

            public Builder objectFile(File objectFile) {
                this.entry.object = objectFile.getAbsolutePath();
                return this;
            }

            public Builder swiftModuleFile(File swiftModuleFile) {
                this.entry.swiftmodule = swiftModuleFile.getAbsolutePath();
                return this;
            }

            public Builder swiftDependenciesFile(File swiftDependenciesFile) {
                this.entry.swiftDependencies = swiftDependenciesFile.getAbsolutePath();
                return this;
            }

            public Builder diagnosticsFile(File diagnosticsFile) {
                this.entry.diagnostics = diagnosticsFile.getAbsolutePath();
                return this;
            }
        }
    }

    private static class SwiftCompileArgsTransformer
    implements ArgsTransformer<SwiftCompileSpec> {
        private SwiftCompileArgsTransformer() {
        }

        public List<String> transform(SwiftCompileSpec swiftCompileSpec) {
            return swiftCompileSpec.getArgs();
        }
    }
}

