/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileSystemUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileTooBigException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ArchiveHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipEntryMap;
import org.jetbrains.kotlin.com.intellij.util.io.FileAccessorCache;
import org.jetbrains.kotlin.com.intellij.util.text.ByteArrayCharSequence;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        protected ZipFile createAccessor(ZipHandler key) throws IOException {
            String canonicalPathToZip = key.getCanonicalPathToZip();
            ZipHandler.setFileStampAndLength(key, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        @Override
        protected void disposeAccessor(ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "<init>"));
        }
        super(path);
    }

    protected static synchronized void setFileStampAndLength(ZipHandler zipHandler, String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes(pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getCanonicalPathToZip"));
        }
        return string;
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> existingZipRef = this.getCachedZipFileHandle(true);
        Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile(existingZipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "createEntriesMap"));
        }
        return map3;
        finally {
            existingZipRef.release();
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip2) {
        ZipEntryMap map2 = new ZipEntryMap(zip2.size());
        map2.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip2.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip2);
        }
        ZipEntryMap zipEntryMap = map2;
        if (zipEntryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "buildEntryMapForZipFile"));
        }
        return zipEntryMap;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle<ZipFile> handle;
            FileAccessorCache.Handle<ZipFile> handle2 = handle = createIfNeeded ? ourZipFileFileAccessorCache.get(this) : ourZipFileFileAccessorCache.getIfCached(this);
            if (handle != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes(this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (attributes.lastModified == this.myFileStamp && attributes.length == this.myFileLength) {
                    return handle;
                }
                this.removeZipHandlerFromCache();
                handle.release();
                handle = ourZipFileFileAccessorCache.get(this);
            }
            return handle;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private void removeZipHandlerFromCache() {
        ourZipFileFileAccessorCache.remove(this);
    }

    @NotNull
    protected File getFileToUse() {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getFileToUse"));
        }
        return file;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeZipHandlerFromCache();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map2.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        Pair<String, String> path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip2);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.myFileStamp, entryName);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        CharSequence sequence2 = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString(shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence2, isDirectory, size, time, parentInfo);
        map2.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        ArchiveHandler.EntryInfo info = map2.get(entryName);
        if (info == null) {
            ZipEntry entry = zip2.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map2, zip2);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
                }
                return entryInfo;
            }
            Pair<String, String> path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip2);
            info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip2.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block8: {
            byte[] byArray;
            InputStream stream2;
            FileAccessorCache.Handle<ZipFile> zipRef;
            block9: {
                if (relativePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
                }
                zipRef = this.getCachedZipFileHandle(true);
                ZipFile zip2 = zipRef.get();
                ZipEntry entry = zip2.getEntry(relativePath);
                if (entry == null) break block8;
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge(length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                stream2 = zip2.getInputStream(entry);
                if (stream2 == null) break block8;
                byArray = FileUtil.loadBytes(stream2, (int)length);
                stream2.close();
                if (byArray != null) break block9;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    stream2.close();
                    throw throwable;
                }
            }
            finally {
                zipRef.release();
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }
}

