/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.collect.Sets;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryBlacklister;

public class ConnectionFailureRepositoryBlacklister
implements RepositoryBlacklister {
    private final Set<String> blacklistedRepositories = Sets.newConcurrentHashSet();

    @Override
    public boolean isBlacklisted(String repositoryId) {
        return this.blacklistedRepositories.contains(repositoryId);
    }

    @Override
    public boolean blacklistRepository(String repositoryId, Throwable throwable) {
        boolean blacklisted = this.isBlacklisted(repositoryId);
        if (blacklisted) {
            return true;
        }
        if (ConnectionFailureRepositoryBlacklister.isCriticalFailure(throwable)) {
            this.blacklistedRepositories.add(repositoryId);
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBlacklistedRepositories() {
        return this.blacklistedRepositories;
    }

    public static boolean hasCriticalFailure(Collection<? extends Throwable> failures) {
        for (Throwable throwable : failures) {
            if (!ConnectionFailureRepositoryBlacklister.isCriticalFailure(throwable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCriticalFailure(Throwable throwable) {
        return ConnectionFailureRepositoryBlacklister.isTimeoutException(throwable);
    }

    private static boolean isTimeoutException(Throwable throwable) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        return rootCause instanceof InterruptedIOException;
    }
}

