/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;

public abstract class AbstractExternalModuleDependency
extends AbstractModuleDependency
implements ExternalModuleDependency {
    private String group;
    private String name;
    private String version;
    private boolean changing;
    private boolean force;

    public AbstractExternalModuleDependency(String group, String name, String version, String configuration) {
        super(configuration);
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        this.group = group;
        this.name = name;
        this.version = version;
    }

    protected void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo(target);
        target.setForce(this.isForce());
        target.setChanging(this.isChanging());
    }

    protected boolean isContentEqualsFor(ExternalModuleDependency dependencyRhs) {
        if (!this.isKeyEquals((ModuleDependency)dependencyRhs) || !this.isCommonContentEquals((ModuleDependency)dependencyRhs)) {
            return false;
        }
        return this.force == dependencyRhs.isForce() && this.changing == dependencyRhs.isChanging();
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec((ModuleVersionSelector)this).isSatisfiedBy(identifier);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isForce() {
        return this.force;
    }

    public ExternalModuleDependency setForce(boolean force) {
        this.validateMutation(this.force, force);
        this.force = force;
        return this;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public ExternalModuleDependency setChanging(boolean changing) {
        this.validateMutation(this.changing, changing);
        this.changing = changing;
        return this;
    }
}

