/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.util.DeprecationLogger;

@NonNullApi
public class DefaultTaskDestroyables
implements TaskDestroyablesInternal {
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final List<Object> paths = Lists.newArrayList();

    public DefaultTaskDestroyables(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
    }

    public void files(final Object ... paths) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"TaskDestroys.files", (String)"TaskDestroys.register");
        this.taskMutator.mutate("TaskDestroys.files(Object...)", new Runnable(){

            public void run() {
                Collections.addAll(DefaultTaskDestroyables.this.paths, paths);
            }
        });
    }

    public void file(final Object path) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"TaskDestroys.file", (String)"TaskDestroys.register");
        this.taskMutator.mutate("TaskDestroys.file(Object...)", new Runnable(){

            public void run() {
                DefaultTaskDestroyables.this.paths.add(path);
            }
        });
    }

    public void register(final Object ... paths) {
        this.taskMutator.mutate("TaskDestroys.register(Object...)", new Runnable(){

            public void run() {
                Collections.addAll(DefaultTaskDestroyables.this.paths, paths);
            }
        });
    }

    public FileCollection getFiles() {
        return new DefaultConfigurableFileCollection(this.task + " destroy files", this.resolver, null, this.paths);
    }
}

