/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import com.google.common.base.Joiner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

@Incubating
public class PluginUnderTestMetadata
extends DefaultTask {
    public static final String IMPLEMENTATION_CLASSPATH_PROP_KEY = "implementation-classpath";
    public static final String IMPLEMENTATION_CLASSPATH_HASH_PROP_KEY = "implementation-classpath-hash";
    public static final String METADATA_FILE_NAME = "plugin-under-test-metadata.properties";
    private FileCollection pluginClasspath;
    private File outputDirectory;

    @Classpath
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @TaskAction
    public void generate() {
        Properties properties = new Properties();
        if (this.getPluginClasspath() != null && !this.getPluginClasspath().isEmpty()) {
            properties.setProperty(IMPLEMENTATION_CLASSPATH_PROP_KEY, this.implementationClasspath());
            properties.setProperty(IMPLEMENTATION_CLASSPATH_HASH_PROP_KEY, this.implementationClasspathHash());
        }
        File outputFile = new File(this.getOutputDirectory(), METADATA_FILE_NAME);
        this.saveProperties(properties, outputFile);
    }

    private String implementationClasspath() {
        StringBuilder implementationClasspath = new StringBuilder();
        Joiner.on((String)File.pathSeparator).appendTo(implementationClasspath, this.getPaths());
        return implementationClasspath.toString();
    }

    private String implementationClasspathHash() {
        ClasspathHasher classpathHasher = (ClasspathHasher)this.getServices().get(ClasspathHasher.class);
        return classpathHasher.hash((ClassPath)new DefaultClassPath((Iterable)this.getPluginClasspath())).toString();
    }

    private void saveProperties(Properties properties, File outputFile) {
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            GUtil.savePropertiesNoDateComment((Properties)properties, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Input
    private List<String> getPaths() {
        return CollectionUtils.collect(this.classpathFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath().replaceAll("\\\\", "/");
            }
        });
    }

    private Iterable<File> classpathFiles() {
        if (this.getPluginClasspath() != null) {
            return this.getPluginClasspath();
        }
        return Collections.emptyList();
    }
}

