/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.language.swift.tasks.CreateSwiftBundle;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.MacOSSdkPlatformPathLocator;
import org.gradle.nativeplatform.test.xctest.tasks.XcTest;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ObjectFactory objectFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ObjectFactory objectFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.objectFactory = objectFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        SwiftXCTestSuite component = (SwiftXCTestSuite)this.objectFactory.newInstance(DefaultSwiftXCTestSuite.class, new Object[]{"test", configurations});
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)component);
        project.getComponents().add((Object)component);
        project.getComponents().add((Object)component.getBundle());
        Property module = component.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        SwiftCompile compile = (SwiftCompile)tasks.getByName("compileTestSwift");
        final List currentCompilerArguments = (List)compile.getCompilerArgs().getOrElse(Collections.emptyList());
        compile.getCompilerArgs().set(project.provider((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                return Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList("-g", "-F" + frameworkDir.getAbsolutePath()), (Iterable)currentCompilerArguments));
            }
        }));
        LinkMachOBundle link = (LinkMachOBundle)tasks.getByName("linkTest");
        link.getLinkerArgs().set(project.provider((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
            }
        }));
        this.configureTestedComponent((Project)project);
        CreateSwiftBundle bundle = (CreateSwiftBundle)tasks.getByName("bundleSwiftTest");
        final XcTest xcTest = (XcTest)tasks.create("xcTest", XcTest.class);
        xcTest.setBinResultsDir(project.file((Object)"build/results/test/bin"));
        xcTest.setTestBundleDir((Provider<? extends Directory>)bundle.getOutputDir());
        xcTest.setWorkingDir((Provider<? extends Directory>)buildDirectory.dir("bundle/test"));
        xcTest.getReports().getHtml().setDestination(buildDirectory.dir("reports/test").map((Transformer)new Transformer<File, Directory>(){

            public File transform(Directory directory) {
                return directory.getAsFile();
            }
        }));
        xcTest.getReports().getJunitXml().setDestination(buildDirectory.dir("reports/test/xml").map((Transformer)new Transformer<File, Directory>(){

            public File transform(Directory directory) {
                return directory.getAsFile();
            }
        }));
        xcTest.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return xcTest.getTestBundleDir().exists();
            }
        });
        Task test = tasks.create("test");
        if (OperatingSystem.current().isMacOsX()) {
            test.dependsOn(new Object[]{xcTest});
        }
        Task check = tasks.getByName("check");
        check.dependsOn(new Object[]{test});
    }

    private void configureTestedComponent(final Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, (Action)new Action<SwiftExecutablePlugin>(){

            public void execute(SwiftExecutablePlugin plugin) {
                XCTestConventionPlugin.this.configureTestedSwiftComponent(project);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, (Action)new Action<SwiftLibraryPlugin>(){

            public void execute(SwiftLibraryPlugin plugin) {
                XCTestConventionPlugin.this.configureTestedSwiftComponent(project);
            }
        });
    }

    private void configureTestedSwiftComponent(Project project) {
        TaskContainer tasks = project.getTasks();
        SwiftCompile compileMain = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileDebugSwift");
        SwiftCompile compileTest = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileTestSwift");
        compileTest.includes((Object)compileMain.getObjectFileDir());
        AbstractLinkTask linkTest = (AbstractLinkTask)tasks.withType(AbstractLinkTask.class).getByName("linkTest");
        linkTest.source((Object)compileMain.getObjectFileDir().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

