#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.19.0.0
id: graphviz-2999.19.0.0-HGkg8iBfLhBIYU4ZsAivKD
key: graphviz-2999.19.0.0-HGkg8iBfLhBIYU4ZsAivKD
license: BSD3
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
author: Matthew Sackman, Ivan Lazar Miljenovic
exposed: True
indefinite: False
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
abi: bd595c3ffeaa6ad3546ec42eff93b67a
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/graphviz-2999.19.0.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/graphviz-2999.19.0.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/graphviz-2999.19.0.0
hs-libraries: HSgraphviz-2999.19.0.0-HGkg8iBfLhBIYU4ZsAivKD
depends:
    base-4.10.0.0 containers-0.5.10.2 process-1.6.1.0 directory-1.3.0.2
    temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo
    fgl-5.5.4.0-COv1pCfgmI26gh5vvUifJw filepath-1.4.1.2
    polyparse-1.12-4cjrjVV9T2CBEJ6qvS0lIS bytestring-0.10.8.2
    colour-2.3.3-4GTcWhusU4z5FdC5GspM4b transformers-0.5.2.0
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    wl-pprint-text-1.1.1.0-33EmaaHwePJ2aRbzjCvW04
    dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo=ba806cd7fa58c88cefcf360552466b99
             fgl-5.5.4.0-COv1pCfgmI26gh5vvUifJw=23b6dd598c8ce946a9fc29265323a307
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             polyparse-1.12-4cjrjVV9T2CBEJ6qvS0lIS=8180aaf9b1daa90854e0f351b4f90250
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             colour-2.3.3-4GTcWhusU4z5FdC5GspM4b=cf36c1b6f2aa814cbe9c4fb4c35cd187
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             wl-pprint-text-1.1.1.0-33EmaaHwePJ2aRbzjCvW04=52d0c89fd6d304b9e75064e2acd72092
             dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q=97435ce23ff4e4560f559d3afbbee81e
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

