#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.14.0.2
id: statistics-0.14.0.2-226iJjS5xXC6HIYhJ2mhFT
key: statistics-0.14.0.2-226iJjS5xXC6HIYhJ2mhFT
license: BSD2
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
indefinite: False
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.StudentT Statistics.Test.Types
    Statistics.Test.WilcoxonT Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
                Statistics.Types.Internal
abi: 15376c22f7a8af4a85474b9ba174cb9d
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/statistics-0.14.0.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/statistics-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/statistics-0.14.0.2
hs-libraries: HSstatistics-0.14.0.2-226iJjS5xXC6HIYhJ2mhFT
depends:
    aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq base-4.10.0.0
    base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L binary-0.8.5.1
    deepseq-1.4.3.0 erf-2.0.0.0-5HxZcIsjrVYDzBhPSPHDu9
    math-functions-0.2.1.0-EZEKt9kx6qT9flHpNtHv8e
    monad-par-0.3.4.8-73MDniBlugD8L8eTzpiIpe
    mwc-random-0.13.6.0-9isDaETTkAQ4w6DSIRGQbB
    primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    vector-algorithms-0.7.0.1-7iegdTORhweEiKzXWIWqK9
    vector-th-unbox-0.2.1.6-JdDbsOZxikU7Wr8hmBip1S
    vector-binary-instances-0.2.3.5-DWvVOI4GHrECD2ZJqrEThD
abi-depends: aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq=61053bde0c5cda47d1a123db05d36888
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L=80bc3cbc1a27ff088178ac694da5ed41
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             erf-2.0.0.0-5HxZcIsjrVYDzBhPSPHDu9=7093557a54e0ef60dc422d9e6fdef74c
             math-functions-0.2.1.0-EZEKt9kx6qT9flHpNtHv8e=9620a2139112940b94f30bc0011fad04
             monad-par-0.3.4.8-73MDniBlugD8L8eTzpiIpe=c4d232051c8a307cf77649c5324e7bcc
             mwc-random-0.13.6.0-9isDaETTkAQ4w6DSIRGQbB=37879dc7727b997b0a1807fa5f0e56da
             primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg=998ed6e6951fb3231f40c732faa08c23
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             vector-algorithms-0.7.0.1-7iegdTORhweEiKzXWIWqK9=6fdc3d307da88f1f18b05070c921f9b7
             vector-th-unbox-0.2.1.6-JdDbsOZxikU7Wr8hmBip1S=42d61f41320644d920ba44f9a10203d4
             vector-binary-instances-0.2.3.5-DWvVOI4GHrECD2ZJqrEThD=b1e020dd6984c8831af2f8a0a4fee437
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

