#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: stringsearch
version: 0.3.6.6
id: stringsearch-0.3.6.6-K30MyFaBEiEDdRa9SPnW19
key: stringsearch-0.3.6.6-K30MyFaBEiEDdRa9SPnW19
license: BSD3
copyright: (c) 2007-2011
           Daniel Fischer, Chris Kuklewicz, Justin Bailey
maintainer: daniel.is.fischer@googlemail.com
homepage: https://bitbucket.org/dafis/stringsearch
synopsis: Fast searching, splitting and replacing of ByteStrings
description:
    This package provides several functions to quickly
    search for substrings in strict or lazy ByteStrings.
    It also provides functions for breaking or splitting
    on substrings and replacing all occurrences of a
    substring (the first in case of overlaps) with another.
    GHC before 6.10 are no longer supported, other compilers
    only if they support BangPatterns. If you need it to
    work with other compilers, send a feature request.
category: Text, Search
author: Daniel Fischer, Chris Kuklewicz, Justin Bailey
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Lazy.Search Data.ByteString.Lazy.Search.DFA
    Data.ByteString.Lazy.Search.KMP
    Data.ByteString.Lazy.Search.KarpRabin Data.ByteString.Search
    Data.ByteString.Search.BoyerMoore Data.ByteString.Search.DFA
    Data.ByteString.Search.KMP Data.ByteString.Search.KarpRabin
    Data.ByteString.Search.KnuthMorrisPratt
    Data.ByteString.Search.Substitution
hidden-modules: Data.ByteString.Search.Internal.BoyerMoore
                Data.ByteString.Search.Internal.KnuthMorrisPratt
                Data.ByteString.Search.Internal.Utils
                Data.ByteString.Lazy.Search.Internal.BoyerMoore
abi: 6fad8b18f5a5d3ec2b7c7758d7d2ee3e
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/stringsearch-0.3.6.6
library-dirs: /usr/lib/ghc-8.2.1/site-local/stringsearch-0.3.6.6
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/stringsearch-0.3.6.6
hs-libraries: HSstringsearch-0.3.6.6-K30MyFaBEiEDdRa9SPnW19
depends:
    array-0.5.2.0 base-4.10.0.0 bytestring-0.10.8.2 containers-0.5.10.2
abi-depends: array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
haddock-interfaces: /usr/share/doc/haskell-stringsearch/html/stringsearch.haddock
haddock-html: /usr/share/doc/haskell-stringsearch/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

