#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.0
id: tls-1.4.0-6CluRDXMj6G5qEgLlQLZ3x
key: tls-1.4.0-6CluRDXMj6G5qEgLlQLZ3x
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: 0cf5fc109726fb04bbb8643630c4e74c
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tls-1.4.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/tls-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tls-1.4.0
hs-libraries: HStls-1.4.0-6CluRDXMj6G5qEgLlQLZ3x
depends:
    base-4.10.0.0 mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 transformers-0.5.2.0
    cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE bytestring-0.10.8.2
    data-default-class-0.1.2.0-K0O6u0ifzTuLE4f7kBhgzp
    memory-0.14.8-BAg3DtPwumR3TQfKUohmeR
    cryptonite-0.24-ELENUw6Chsl82ACxm0cgXp
    asn1-types-0.3.2-48XQGtsS6SE5zfarz06o85
    asn1-encoding-0.9.5-8mKnGJnlPdN3znZAPxW19G
    x509-1.7.2-BkUsBex4pvBdlJA0fUJWS
    x509-store-1.6.5-AGUB395E0NTF8xXol9wxPY
    x509-validation-1.6.9-9NxktlNr7AtKOZJOC3QOPb
    async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE=7bc02437e77f59917ed10938dea3d025
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             data-default-class-0.1.2.0-K0O6u0ifzTuLE4f7kBhgzp=cbc023a13af0b49e672a5936ee9b18d1
             memory-0.14.8-BAg3DtPwumR3TQfKUohmeR=b78231a975bde8739839c13c0576fe77
             cryptonite-0.24-ELENUw6Chsl82ACxm0cgXp=d36853e10cf2a0c9b1a6796b9ffe1717
             asn1-types-0.3.2-48XQGtsS6SE5zfarz06o85=575f545131a6fdb4df75d03cd7306f6e
             asn1-encoding-0.9.5-8mKnGJnlPdN3znZAPxW19G=6e181825416b69e608b83d5728cdcc65
             x509-1.7.2-BkUsBex4pvBdlJA0fUJWS=b145bd8477827e4ef45b9ac4229441ac
             x509-store-1.6.5-AGUB395E0NTF8xXol9wxPY=7c99921b7a54a124c6e3a8e818ee8b51
             x509-validation-1.6.9-9NxktlNr7AtKOZJOC3QOPb=fdc5a3ba77286acba150fbaeb3da9a3d
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

