/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;

public class UnitCellIterator
implements AtomIndexIterator {
    private Atom[] atoms;
    private T3 center;
    private T3 translation;
    private int nFound;
    private float maxDistance2;
    private float distance2;
    private SymmetryInterface unitCell;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3i t;
    private P3 p;
    private int ipt = Integer.MIN_VALUE;
    private Lst<P3[]> unitList;
    private boolean done;
    private int nAtoms;
    private int listPt;

    public UnitCellIterator set(SymmetryInterface unitCell, Atom atom, Atom[] atoms, BS bsAtoms, float distance) {
        this.unitCell = unitCell;
        this.atoms = atoms;
        this.addAtoms(bsAtoms);
        this.p = new P3();
        if (distance > 0.0f) {
            this.setCenter(atom, distance);
        }
        return this;
    }

    @Override
    public void setModel(ModelSet modelSet, int modelIndex, int zeroBase, int atomIndex, T3 center, float distance, RadiusData rd) {
    }

    @Override
    public void setCenter(T3 center, float distance) {
        if (distance == 0.0f) {
            return;
        }
        this.maxDistance2 = distance * distance;
        this.center = center;
        this.translation = new P3();
        P3[] pts = BoxInfo.unitCubePoints;
        P3 min = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        P3 max = P3.new3(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.p = new P3();
        P3 ptC = new P3();
        ptC.setT(center);
        this.unitCell.toFractional(ptC, true);
        for (int i = 0; i < 8; ++i) {
            this.p.scaleAdd2(-2.0f, pts[i], pts[7]);
            this.p.scaleAdd2(distance, this.p, center);
            this.unitCell.toFractional(this.p, true);
            if (min.x > this.p.x) {
                min.x = this.p.x;
            }
            if (max.x < this.p.x) {
                max.x = this.p.x;
            }
            if (min.y > this.p.y) {
                min.y = this.p.y;
            }
            if (max.y < this.p.y) {
                max.y = this.p.y;
            }
            if (min.z > this.p.z) {
                min.z = this.p.z;
            }
            if (!(max.z < this.p.z)) continue;
            max.z = this.p.z;
        }
        this.minXYZ = P3i.new3((int)Math.floor(min.x), (int)Math.floor(min.y), (int)Math.floor(min.z));
        this.maxXYZ = P3i.new3((int)Math.ceil(max.x), (int)Math.ceil(max.y), (int)Math.ceil(max.z));
        if (Logger.debugging) {
            Logger.info("UnitCellIterator minxyz/maxxyz " + this.minXYZ + " " + this.maxXYZ);
        }
        this.t = P3i.new3(this.minXYZ.x - 1, this.minXYZ.y, this.minXYZ.z);
        this.nextCell();
    }

    @Override
    public void addAtoms(BS bsAtoms) {
        boolean bl = this.done = bsAtoms == null;
        if (this.done) {
            return;
        }
        this.unitList = new Lst();
        String cat = "";
        M4[] ops = this.unitCell.getSymmetryOperations();
        int nOps = ops.length;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.atoms[i];
            for (int j = 0; j < nOps; ++j) {
                P3 pt = new P3();
                pt.setT(a);
                if (j > 0) {
                    this.unitCell.toFractional(pt, false);
                    ops[j].rotTrans(pt);
                    this.unitCell.unitize(pt);
                    this.unitCell.toCartesian(pt, false);
                } else {
                    this.unitCell.toUnitCell(pt, null);
                }
                String key = "_" + (int)(pt.x * 100.0f) + "_" + (int)(pt.y * 100.0f) + "_" + (int)(pt.z * 100.0f) + "_";
                if (cat.indexOf(key) >= 0) continue;
                cat = cat + key;
                this.unitList.addLast(new P3[]{a, pt});
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        this.nAtoms = this.unitList.size();
        boolean bl2 = this.done = this.nAtoms == 0;
        if (Logger.debugging) {
            Logger.info("UnitCellIterator " + this.nAtoms + " unique points found");
        }
    }

    @Override
    public boolean hasNext() {
        while (this.ipt < this.nAtoms || this.nextCell()) {
            float f;
            ++this.ipt;
            this.listPt = this.listPt;
            this.p.add2(((P3[])this.unitList.get(this.listPt))[1], this.translation);
            this.distance2 = this.p.distanceSquared(this.center);
            if (!(f < this.maxDistance2) || !(this.distance2 > 0.1f)) continue;
            ++this.nFound;
            return true;
        }
        return false;
    }

    private boolean nextCell() {
        if (this.done) {
            return false;
        }
        if (++this.t.x >= this.maxXYZ.x) {
            this.t.x = this.minXYZ.x;
            if (++this.t.y >= this.maxXYZ.y) {
                this.t.y = this.minXYZ.y;
                if (++this.t.z >= this.maxXYZ.z) {
                    this.done = true;
                    this.ipt = this.nAtoms;
                    return false;
                }
            }
        }
        this.translation.set(this.t.x, this.t.y, this.t.z);
        this.unitCell.toCartesian(this.translation, false);
        this.ipt = 0;
        return true;
    }

    @Override
    public int next() {
        return this.done || this.ipt < 0 ? -1 : this.getAtom().i;
    }

    private Atom getAtom() {
        return (Atom)((P3[])this.unitList.get(this.listPt))[0];
    }

    @Override
    public float foundDistance2() {
        return this.nFound > 0 ? this.distance2 : Float.MAX_VALUE;
    }

    @Override
    public P3 getPosition() {
        Atom a = this.getAtom();
        if (Logger.debugging) {
            Logger.info("draw ID p_" + this.nFound + " " + this.p + " //" + a + " " + this.t);
        }
        if (this.p.distanceSquared(a) < 1.0E-4f) {
            return a;
        }
        Point3fi p = new Point3fi();
        p.setT(this.p);
        p.i = a.i;
        p.sD = (short)a.getElementNumber();
        return p;
    }

    @Override
    public void release() {
        this.atoms = null;
        this.center = null;
        this.translation = null;
    }
}

