/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.OlympusCameraSettingsMakernoteDirectory;
import java.text.DecimalFormat;
import java.util.HashMap;

public class OlympusCameraSettingsMakernoteDescriptor
extends TagDescriptor<OlympusCameraSettingsMakernoteDirectory> {
    private static final HashMap<Integer, String> _filters = new HashMap();

    public OlympusCameraSettingsMakernoteDescriptor(@NotNull OlympusCameraSettingsMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getCameraSettingsVersionDescription();
            }
            case 256: {
                return this.getPreviewImageValidDescription();
            }
            case 512: {
                return this.getExposureModeDescription();
            }
            case 513: {
                return this.getAeLockDescription();
            }
            case 514: {
                return this.getMeteringModeDescription();
            }
            case 515: {
                return this.getExposureShiftDescription();
            }
            case 516: {
                return this.getNdFilterDescription();
            }
            case 768: {
                return this.getMacroModeDescription();
            }
            case 769: {
                return this.getFocusModeDescription();
            }
            case 770: {
                return this.getFocusProcessDescription();
            }
            case 771: {
                return this.getAfSearchDescription();
            }
            case 772: {
                return this.getAfAreasDescription();
            }
            case 773: {
                return this.getAfPointSelectedDescription();
            }
            case 774: {
                return this.getAfFineTuneDescription();
            }
            case 1024: {
                return this.getFlashModeDescription();
            }
            case 1027: {
                return this.getFlashRemoteControlDescription();
            }
            case 1028: {
                return this.getFlashControlModeDescription();
            }
            case 1029: {
                return this.getFlashIntensityDescription();
            }
            case 1030: {
                return this.getManualFlashStrengthDescription();
            }
            case 1280: {
                return this.getWhiteBalance2Description();
            }
            case 1281: {
                return this.getWhiteBalanceTemperatureDescription();
            }
            case 1283: {
                return this.getCustomSaturationDescription();
            }
            case 1284: {
                return this.getModifiedSaturationDescription();
            }
            case 1285: {
                return this.getContrastSettingDescription();
            }
            case 1286: {
                return this.getSharpnessSettingDescription();
            }
            case 1287: {
                return this.getColorSpaceDescription();
            }
            case 1289: {
                return this.getSceneModeDescription();
            }
            case 1290: {
                return this.getNoiseReductionDescription();
            }
            case 1291: {
                return this.getDistortionCorrectionDescription();
            }
            case 1292: {
                return this.getShadingCompensationDescription();
            }
            case 1295: {
                return this.getGradationDescription();
            }
            case 1312: {
                return this.getPictureModeDescription();
            }
            case 1313: {
                return this.getPictureModeSaturationDescription();
            }
            case 1315: {
                return this.getPictureModeContrastDescription();
            }
            case 1316: {
                return this.getPictureModeSharpnessDescription();
            }
            case 1317: {
                return this.getPictureModeBWFilterDescription();
            }
            case 1318: {
                return this.getPictureModeToneDescription();
            }
            case 1319: {
                return this.getNoiseFilterDescription();
            }
            case 1321: {
                return this.getArtFilterDescription();
            }
            case 1324: {
                return this.getMagicFilterDescription();
            }
            case 1325: {
                return this.getPictureModeEffectDescription();
            }
            case 1326: {
                return this.getToneLevelDescription();
            }
            case 1327: {
                return this.getArtFilterEffectDescription();
            }
            case 1536: {
                return this.getDriveModeDescription();
            }
            case 1537: {
                return this.getPanoramaModeDescription();
            }
            case 1539: {
                return this.getImageQuality2Description();
            }
            case 1540: {
                return this.getImageStabilizationDescription();
            }
            case 2052: {
                return this.getStackedImageDescription();
            }
            case 2304: {
                return this.getManometerPressureDescription();
            }
            case 2305: {
                return this.getManometerReadingDescription();
            }
            case 2306: {
                return this.getExtendedWBDetectDescription();
            }
            case 2307: {
                return this.getRollAngleDescription();
            }
            case 2308: {
                return this.getPitchAngleDescription();
            }
            case 2312: {
                return this.getDateTimeUTCDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getCameraSettingsVersionDescription() {
        return this.getVersionBytesDescription(0, 4);
    }

    @Nullable
    public String getPreviewImageValidDescription() {
        return this.getIndexedDescription(256, "No", "Yes");
    }

    @Nullable
    public String getExposureModeDescription() {
        return this.getIndexedDescription(512, 1, "Manual", "Program", "Aperture-priority AE", "Shutter speed priority", "Program-shift");
    }

    @Nullable
    public String getAeLockDescription() {
        return this.getIndexedDescription(513, "Off", "On");
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(514);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "Center-weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 5: {
                return "ESP";
            }
            case 261: {
                return "Pattern+AF";
            }
            case 515: {
                return "Spot+Highlight control";
            }
            case 1027: {
                return "Spot+Shadow control";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getExposureShiftDescription() {
        return this.getRationalOrDoubleString(515);
    }

    @Nullable
    public String getNdFilterDescription() {
        return this.getIndexedDescription(516, "Off", "On");
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getIndexedDescription(768, "Off", "On", "Super Macro");
    }

    @Nullable
    public String getFocusModeDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(769);
        if (values == null) {
            Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(769);
            if (value == null) {
                return null;
            }
            values = new int[]{value};
        }
        if (values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (values[0]) {
            case 0: {
                sb.append("Single AF");
                break;
            }
            case 1: {
                sb.append("Sequential shooting AF");
                break;
            }
            case 2: {
                sb.append("Continuous AF");
                break;
            }
            case 3: {
                sb.append("Multi AF");
                break;
            }
            case 4: {
                sb.append("Face detect");
                break;
            }
            case 10: {
                sb.append("MF");
                break;
            }
            default: {
                sb.append("Unknown (" + values[0] + ")");
            }
        }
        if (values.length > 1) {
            sb.append("; ");
            int value1 = values[1];
            if (value1 == 0) {
                sb.append("(none)");
            } else {
                if ((value1 & 1) > 0) {
                    sb.append("S-AF, ");
                }
                if ((value1 >> 2 & 1) > 0) {
                    sb.append("C-AF, ");
                }
                if ((value1 >> 4 & 1) > 0) {
                    sb.append("MF, ");
                }
                if ((value1 >> 5 & 1) > 0) {
                    sb.append("Face detect, ");
                }
                if ((value1 >> 6 & 1) > 0) {
                    sb.append("Imager AF, ");
                }
                if ((value1 >> 7 & 1) > 0) {
                    sb.append("Live View Magnification Frame, ");
                }
                if ((value1 >> 8 & 1) > 0) {
                    sb.append("AF sensor, ");
                }
                sb.setLength(sb.length() - 2);
            }
        }
        return sb.toString();
    }

    @Nullable
    public String getFocusProcessDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(770);
        if (values == null) {
            Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(770);
            if (value == null) {
                return null;
            }
            values = new int[]{value};
        }
        if (values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (values[0]) {
            case 0: {
                sb.append("AF not used");
                break;
            }
            case 1: {
                sb.append("AF used");
                break;
            }
            default: {
                sb.append("Unknown (" + values[0] + ")");
            }
        }
        if (values.length > 1) {
            sb.append("; " + values[1]);
        }
        return sb.toString();
    }

    @Nullable
    public String getAfSearchDescription() {
        return this.getIndexedDescription(771, "Not Ready", "Ready");
    }

    @Nullable
    public String getAfAreasDescription() {
        Object obj = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getObject(772);
        if (obj == null || !(obj instanceof long[])) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (long point : (long[])obj) {
            if (point == 0L) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            if (point == 913916549L) {
                sb.append("Left ");
            } else if (point == 2038007173L) {
                sb.append("Center ");
            } else if (point == 3178875269L) {
                sb.append("Right ");
            }
            sb.append(String.format("(%d/255,%d/255)-(%d/255,%d/255)", point >> 24 & 0xFFL, point >> 16 & 0xFFL, point >> 8 & 0xFFL, point & 0xFFL));
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Nullable
    public String getAfPointSelectedDescription() {
        Rational[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(773);
        if (values == null) {
            return "n/a";
        }
        if (values.length < 4) {
            return null;
        }
        int index = 0;
        if (values.length == 5 && values[0].longValue() == 0L) {
            index = 1;
        }
        int p1 = (int)(values[index].doubleValue() * 100.0);
        int p2 = (int)(values[index + 1].doubleValue() * 100.0);
        int p3 = (int)(values[index + 2].doubleValue() * 100.0);
        int p4 = (int)(values[index + 3].doubleValue() * 100.0);
        return String.format("(%d%%,%d%%) (%d%%,%d%%)", p1, p2, p3, p4);
    }

    @Nullable
    public String getAfFineTuneDescription() {
        return this.getIndexedDescription(774, "Off", "On");
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1024);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Off";
        }
        StringBuilder sb = new StringBuilder();
        int v = value;
        if ((v & 1) != 0) {
            sb.append("On, ");
        }
        if ((v >> 1 & 1) != 0) {
            sb.append("Fill-in, ");
        }
        if ((v >> 2 & 1) != 0) {
            sb.append("Red-eye, ");
        }
        if ((v >> 3 & 1) != 0) {
            sb.append("Slow-sync, ");
        }
        if ((v >> 4 & 1) != 0) {
            sb.append("Forced On, ");
        }
        if ((v >> 5 & 1) != 0) {
            sb.append("2nd Curtain, ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getFlashRemoteControlDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1027);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Channel 1, Low";
            }
            case 2: {
                return "Channel 2, Low";
            }
            case 3: {
                return "Channel 3, Low";
            }
            case 4: {
                return "Channel 4, Low";
            }
            case 9: {
                return "Channel 1, Mid";
            }
            case 10: {
                return "Channel 2, Mid";
            }
            case 11: {
                return "Channel 3, Mid";
            }
            case 12: {
                return "Channel 4, Mid";
            }
            case 17: {
                return "Channel 1, High";
            }
            case 18: {
                return "Channel 2, High";
            }
            case 19: {
                return "Channel 3, High";
            }
            case 20: {
                return "Channel 4, High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashControlModeDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1028);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (values[0]) {
            case 0: {
                sb.append("Off");
                break;
            }
            case 3: {
                sb.append("TTL");
                break;
            }
            case 4: {
                sb.append("Auto");
                break;
            }
            case 5: {
                sb.append("Manual");
                break;
            }
            default: {
                sb.append("Unknown (").append(values[0]).append(")");
            }
        }
        for (int i = 1; i < values.length; ++i) {
            sb.append("; ").append(values[i]);
        }
        return sb.toString();
    }

    @Nullable
    public String getFlashIntensityDescription() {
        Rational[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(1029);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 3) {
            if (values[0].getDenominator() == 0L && values[1].getDenominator() == 0L && values[2].getDenominator() == 0L) {
                return "n/a";
            }
        } else if (values.length == 4 && values[0].getDenominator() == 0L && values[1].getDenominator() == 0L && values[2].getDenominator() == 0L && values[3].getDenominator() == 0L) {
            return "n/a (x4)";
        }
        StringBuilder sb = new StringBuilder();
        for (Rational t : values) {
            sb.append(t).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getManualFlashStrengthDescription() {
        Rational[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(1030);
        if (values == null || values.length == 0) {
            return "n/a";
        }
        if (values.length == 3) {
            if (values[0].getDenominator() == 0L && values[1].getDenominator() == 0L && values[2].getDenominator() == 0L) {
                return "n/a";
            }
        } else if (values.length == 4 && values[0].getDenominator() == 0L && values[1].getDenominator() == 0L && values[2].getDenominator() == 0L && values[3].getDenominator() == 0L) {
            return "n/a (x4)";
        }
        StringBuilder sb = new StringBuilder();
        for (Rational t : values) {
            sb.append(t).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getWhiteBalance2Description() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1280);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Auto (Keep Warm Color Off)";
            }
            case 16: {
                return "7500K (Fine Weather with Shade)";
            }
            case 17: {
                return "6000K (Cloudy)";
            }
            case 18: {
                return "5300K (Fine Weather)";
            }
            case 20: {
                return "3000K (Tungsten light)";
            }
            case 21: {
                return "3600K (Tungsten light-like)";
            }
            case 22: {
                return "Auto Setup";
            }
            case 23: {
                return "5500K (Flash)";
            }
            case 33: {
                return "6600K (Daylight fluorescent)";
            }
            case 34: {
                return "4500K (Neutral white fluorescent)";
            }
            case 35: {
                return "4000K (Cool white fluorescent)";
            }
            case 36: {
                return "White Fluorescent";
            }
            case 48: {
                return "3600K (Tungsten light-like)";
            }
            case 67: {
                return "Underwater";
            }
            case 256: {
                return "One Touch WB 1";
            }
            case 257: {
                return "One Touch WB 2";
            }
            case 258: {
                return "One Touch WB 3";
            }
            case 259: {
                return "One Touch WB 4";
            }
            case 512: {
                return "Custom WB 1";
            }
            case 513: {
                return "Custom WB 2";
            }
            case 514: {
                return "Custom WB 3";
            }
            case 515: {
                return "Custom WB 4";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceTemperatureDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1281);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Auto";
        }
        return value.toString();
    }

    @Nullable
    public String getCustomSaturationDescription() {
        return this.getValueMinMaxDescription(1283);
    }

    @Nullable
    public String getModifiedSaturationDescription() {
        return this.getIndexedDescription(1284, "Off", "CM1 (Red Enhance)", "CM2 (Green Enhance)", "CM3 (Blue Enhance)", "CM4 (Skin Tones)");
    }

    @Nullable
    public String getContrastSettingDescription() {
        return this.getValueMinMaxDescription(1285);
    }

    @Nullable
    public String getSharpnessSettingDescription() {
        return this.getValueMinMaxDescription(1286);
    }

    @Nullable
    public String getColorSpaceDescription() {
        return this.getIndexedDescription(1287, "sRGB", "Adobe RGB", "Pro Photo RGB");
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1289);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Standard";
            }
            case 6: {
                return "Auto";
            }
            case 7: {
                return "Sport";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Landscape+Portrait";
            }
            case 10: {
                return "Landscape";
            }
            case 11: {
                return "Night Scene";
            }
            case 12: {
                return "Self Portrait";
            }
            case 13: {
                return "Panorama";
            }
            case 14: {
                return "2 in 1";
            }
            case 15: {
                return "Movie";
            }
            case 16: {
                return "Landscape+Portrait";
            }
            case 17: {
                return "Night+Portrait";
            }
            case 18: {
                return "Indoor";
            }
            case 19: {
                return "Fireworks";
            }
            case 20: {
                return "Sunset";
            }
            case 21: {
                return "Beauty Skin";
            }
            case 22: {
                return "Macro";
            }
            case 23: {
                return "Super Macro";
            }
            case 24: {
                return "Food";
            }
            case 25: {
                return "Documents";
            }
            case 26: {
                return "Museum";
            }
            case 27: {
                return "Shoot & Select";
            }
            case 28: {
                return "Beach & Snow";
            }
            case 29: {
                return "Self Portrait+Timer";
            }
            case 30: {
                return "Candle";
            }
            case 31: {
                return "Available Light";
            }
            case 32: {
                return "Behind Glass";
            }
            case 33: {
                return "My Mode";
            }
            case 34: {
                return "Pet";
            }
            case 35: {
                return "Underwater Wide1";
            }
            case 36: {
                return "Underwater Macro";
            }
            case 37: {
                return "Shoot & Select1";
            }
            case 38: {
                return "Shoot & Select2";
            }
            case 39: {
                return "High Key";
            }
            case 40: {
                return "Digital Image Stabilization";
            }
            case 41: {
                return "Auction";
            }
            case 42: {
                return "Beach";
            }
            case 43: {
                return "Snow";
            }
            case 44: {
                return "Underwater Wide2";
            }
            case 45: {
                return "Low Key";
            }
            case 46: {
                return "Children";
            }
            case 47: {
                return "Vivid";
            }
            case 48: {
                return "Nature Macro";
            }
            case 49: {
                return "Underwater Snapshot";
            }
            case 50: {
                return "Shooting Guide";
            }
            case 54: {
                return "Face Portrait";
            }
            case 57: {
                return "Bulb";
            }
            case 59: {
                return "Smile Shot";
            }
            case 60: {
                return "Quick Shutter";
            }
            case 63: {
                return "Slow Shutter";
            }
            case 64: {
                return "Bird Watching";
            }
            case 65: {
                return "Multiple Exposure";
            }
            case 66: {
                return "e-Portrait";
            }
            case 67: {
                return "Soft Background Shot";
            }
            case 142: {
                return "Hand-held Starlight";
            }
            case 154: {
                return "HDR";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1290);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        int v = value;
        if ((v & 1) != 0) {
            sb.append("Noise Reduction, ");
        }
        if ((v >> 1 & 1) != 0) {
            sb.append("Noise Filter, ");
        }
        if ((v >> 2 & 1) != 0) {
            sb.append("Noise Filter (ISO Boost), ");
        }
        if ((v >> 3 & 1) != 0) {
            sb.append("Auto, ");
        }
        return sb.length() != 0 ? sb.substring(0, sb.length() - 2) : "(none)";
    }

    @Nullable
    public String getDistortionCorrectionDescription() {
        return this.getIndexedDescription(1291, "Off", "On");
    }

    @Nullable
    public String getShadingCompensationDescription() {
        return this.getIndexedDescription(1292, "Off", "On");
    }

    @Nullable
    public String getGradationDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1295);
        if (values == null || values.length < 3) {
            return null;
        }
        String join = String.format("%d %d %d", values[0], values[1], values[2]);
        String ret = join.equals("0 0 0") ? "n/a" : (join.equals("-1 -1 1") ? "Low Key" : (join.equals("0 -1 1") ? "Normal" : (join.equals("1 -1 1") ? "High Key" : "Unknown (" + join + ")")));
        if (values.length > 3) {
            if (values[3] == 0) {
                ret = ret + "; User-Selected";
            } else if (values[3] == 1) {
                ret = ret + "; Auto-Override";
            }
        }
        return ret;
    }

    @Nullable
    public String getPictureModeDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1312);
        if (values == null) {
            Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1290);
            if (value == null) {
                return null;
            }
            values = new int[]{value};
        }
        if (values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (values[0]) {
            case 1: {
                sb.append("Vivid");
                break;
            }
            case 2: {
                sb.append("Natural");
                break;
            }
            case 3: {
                sb.append("Muted");
                break;
            }
            case 4: {
                sb.append("Portrait");
                break;
            }
            case 5: {
                sb.append("i-Enhance");
                break;
            }
            case 256: {
                sb.append("Monotone");
                break;
            }
            case 512: {
                sb.append("Sepia");
                break;
            }
            default: {
                sb.append("Unknown (").append(values[0]).append(")");
            }
        }
        if (values.length > 1) {
            sb.append("; ").append(values[1]);
        }
        return sb.toString();
    }

    @Nullable
    public String getPictureModeSaturationDescription() {
        return this.getValueMinMaxDescription(1313);
    }

    @Nullable
    public String getPictureModeContrastDescription() {
        return this.getValueMinMaxDescription(1315);
    }

    @Nullable
    public String getPictureModeSharpnessDescription() {
        return this.getValueMinMaxDescription(1316);
    }

    @Nullable
    public String getPictureModeBWFilterDescription() {
        return this.getIndexedDescription(1317, "n/a", "Neutral", "Yellow", "Orange", "Red", "Green");
    }

    @Nullable
    public String getPictureModeToneDescription() {
        return this.getIndexedDescription(1318, "n/a", "Neutral", "Sepia", "Blue", "Purple", "Green");
    }

    @Nullable
    public String getNoiseFilterDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1319);
        if (values == null) {
            return null;
        }
        String join = String.format("%d %d %d", values[0], values[1], values[2]);
        if (join.equals("0 0 0")) {
            return "n/a";
        }
        if (join.equals("-2 -2 1")) {
            return "Off";
        }
        if (join.equals("-1 -2 1")) {
            return "Low";
        }
        if (join.equals("0 -2 1")) {
            return "Standard";
        }
        if (join.equals("1 -2 1")) {
            return "High";
        }
        return "Unknown (" + join + ")";
    }

    @Nullable
    public String getArtFilterDescription() {
        return this.getFiltersDescription(1321);
    }

    @Nullable
    public String getMagicFilterDescription() {
        return this.getFiltersDescription(1324);
    }

    @Nullable
    public String getPictureModeEffectDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1325);
        if (values == null) {
            return null;
        }
        String key = String.format("%d %d %d", values[0], values[1], values[2]);
        if (key.equals("0 0 0")) {
            return "n/a";
        }
        if (key.equals("-1 -1 1")) {
            return "Low";
        }
        if (key.equals("0 -1 1")) {
            return "Standard";
        }
        if (key.equals("1 -1 1")) {
            return "High";
        }
        return "Unknown (" + key + ")";
    }

    @Nullable
    public String getToneLevelDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1326);
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i == 1) {
                sb.append("Highlights ");
            } else if (i == 5) {
                sb.append("Shadows ");
            }
            sb.append(values[i]).append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getArtFilterEffectDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1327);
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                sb.append(_filters.containsKey(values[i]) ? _filters.get(values[i]) : "[unknown]");
            } else if (i == 4) {
                switch (values[i]) {
                    case 0: {
                        sb.append("No Effect");
                        break;
                    }
                    case 32784: {
                        sb.append("Star Light");
                        break;
                    }
                    case 32800: {
                        sb.append("Pin Hole");
                        break;
                    }
                    case 32816: {
                        sb.append("Frame");
                        break;
                    }
                    case 32832: {
                        sb.append("Soft Focus");
                        break;
                    }
                    case 32848: {
                        sb.append("White Edge");
                        break;
                    }
                    case 32864: {
                        sb.append("B&W");
                        break;
                    }
                    default: {
                        sb.append("Unknown (").append(values[i]).append(")");
                        break;
                    }
                }
            } else {
                sb.append(values[i]);
            }
            sb.append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getDriveModeDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1536);
        if (values == null) {
            return null;
        }
        if (values.length == 0 || values[0] == 0) {
            return "Single Shot";
        }
        StringBuilder a = new StringBuilder();
        if (values[0] == 5 && values.length >= 3) {
            int c = values[2];
            if ((c & 1) > 0) {
                a.append("AE");
            }
            if ((c >> 1 & 1) > 0) {
                a.append("WB");
            }
            if ((c >> 2 & 1) > 0) {
                a.append("FL");
            }
            if ((c >> 3 & 1) > 0) {
                a.append("MF");
            }
            if ((c >> 6 & 1) > 0) {
                a.append("Focus");
            }
            a.append(" Bracketing");
        } else {
            switch (values[0]) {
                case 1: {
                    a.append("Continuous Shooting");
                    break;
                }
                case 2: {
                    a.append("Exposure Bracketing");
                    break;
                }
                case 3: {
                    a.append("White Balance Bracketing");
                    break;
                }
                case 4: {
                    a.append("Exposure+WB Bracketing");
                    break;
                }
                default: {
                    a.append("Unknown (").append(values[0]).append(")");
                }
            }
        }
        a.append(", Shot ").append(values[1]);
        return a.toString();
    }

    @Nullable
    public String getPanoramaModeDescription() {
        String a;
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1537);
        if (values == null) {
            return null;
        }
        if (values.length == 0 || values[0] == 0) {
            return "Off";
        }
        switch (values[0]) {
            case 1: {
                a = "Left to Right";
                break;
            }
            case 2: {
                a = "Right to Left";
                break;
            }
            case 3: {
                a = "Bottom to Top";
                break;
            }
            case 4: {
                a = "Top to Bottom";
                break;
            }
            default: {
                a = "Unknown (" + values[0] + ")";
            }
        }
        return String.format("%s, Shot %d", a, values[1]);
    }

    @Nullable
    public String getImageQuality2Description() {
        return this.getIndexedDescription(1539, 1, "SQ", "HQ", "SHQ", "RAW", "SQ (5)");
    }

    @Nullable
    public String getImageStabilizationDescription() {
        return this.getIndexedDescription(1540, "Off", "On, Mode 1", "On, Mode 2", "On, Mode 3", "On, Mode 4");
    }

    @Nullable
    public String getStackedImageDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2052);
        if (values == null || values.length < 2) {
            return null;
        }
        int v1 = values[0];
        int v2 = values[1];
        if (v1 == 0 && v2 == 0) {
            return "No";
        }
        if (v1 == 9 && v2 == 8) {
            return "Focus-stacked (8 images)";
        }
        return String.format("Unknown (%d %d)", v1, v2);
    }

    @Nullable
    public String getManometerPressureDescription() {
        Integer value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(2304);
        if (value == null) {
            return null;
        }
        return String.format("%s kPa", new DecimalFormat("#.##").format((double)value.intValue() / 10.0));
    }

    @Nullable
    public String getManometerReadingDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2305);
        if (values == null || values.length < 2) {
            return null;
        }
        DecimalFormat format = new DecimalFormat("#.##");
        return String.format("%s m, %s ft", format.format((double)values[0] / 10.0), format.format((double)values[1] / 10.0));
    }

    @Nullable
    public String getExtendedWBDetectDescription() {
        return this.getIndexedDescription(2306, "Off", "On");
    }

    @Nullable
    public String getRollAngleDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2307);
        if (values == null || values.length < 2) {
            return null;
        }
        String ret = values[0] != 0 ? Double.toString((double)(-values[0]) / 10.0) : "n/a";
        return String.format("%s %d", ret, values[1]);
    }

    @Nullable
    public String getPitchAngleDescription() {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2308);
        if (values == null || values.length < 2) {
            return null;
        }
        String ret = values[0] != 0 ? Double.toString((double)values[0] / 10.0) : "n/a";
        return String.format("%s %d", ret, values[1]);
    }

    @Nullable
    public String getDateTimeUTCDescription() {
        Object value = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getObject(2312);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Nullable
    private String getValueMinMaxDescription(int tagId) {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(tagId);
        if (values == null || values.length < 3) {
            return null;
        }
        return String.format("%d (min %d, max %d)", values[0], values[1], values[2]);
    }

    private String getFiltersDescription(int tagId) {
        int[] values = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(tagId);
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                sb.append(_filters.containsKey(values[i]) ? _filters.get(values[i]) : "[unknown]");
            } else {
                sb.append(values[i]);
            }
            sb.append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    static {
        _filters.put(0, "Off");
        _filters.put(1, "Soft Focus");
        _filters.put(2, "Pop Art");
        _filters.put(3, "Pale & Light Color");
        _filters.put(4, "Light Tone");
        _filters.put(5, "Pin Hole");
        _filters.put(6, "Grainy Film");
        _filters.put(9, "Diorama");
        _filters.put(10, "Cross Process");
        _filters.put(12, "Fish Eye");
        _filters.put(13, "Drawing");
        _filters.put(14, "Gentle Sepia");
        _filters.put(15, "Pale & Light Color II");
        _filters.put(16, "Pop Art II");
        _filters.put(17, "Pin Hole II");
        _filters.put(18, "Pin Hole III");
        _filters.put(19, "Grainy Film II");
        _filters.put(20, "Dramatic Tone");
        _filters.put(21, "Punk");
        _filters.put(22, "Soft Focus 2");
        _filters.put(23, "Sparkle");
        _filters.put(24, "Watercolor");
        _filters.put(25, "Key Line");
        _filters.put(26, "Key Line II");
        _filters.put(27, "Miniature");
        _filters.put(28, "Reflection");
        _filters.put(29, "Fragmented");
        _filters.put(31, "Cross Process II");
        _filters.put(32, "Dramatic Tone II");
        _filters.put(33, "Watercolor I");
        _filters.put(34, "Watercolor II");
        _filters.put(35, "Diorama II");
        _filters.put(36, "Vintage");
        _filters.put(37, "Vintage II");
        _filters.put(38, "Vintage III");
        _filters.put(39, "Partial Color");
        _filters.put(40, "Partial Color II");
        _filters.put(41, "Partial Color III");
    }
}

