/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class PurgeAction
extends JosmAction {
    protected transient OsmDataLayer layer;
    protected JCheckBox cbClearUndoRedo;
    protected boolean modified;
    protected transient List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge...", new Object[0]), "purge", I18n.tr("Forget objects but do not delete them on server when uploading.", new Object[0]), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge", new Object[0])), 80, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        PurgeCommand cmd = this.getPurgeCommand(this.getLayerManager().getEditDataSet().getAllSelected());
        boolean clearUndoRedo = false;
        if (!GraphicsEnvironment.isHeadless()) {
            boolean answer = ConditionalOptionPaneUtil.showConfirmationDialog("purge", Main.parent, this.buildPanel(this.modified), I18n.tr("Confirm Purging", new Object[0]), 2, -1, 0);
            if (!answer) {
                return;
            }
            clearUndoRedo = this.cbClearUndoRedo.isSelected();
            Config.getPref().putBoolean("purge.clear_undo_redo", clearUndoRedo);
        }
        MainApplication.undoRedo.add(cmd);
        if (clearUndoRedo) {
            MainApplication.undoRedo.clean();
            this.getLayerManager().getEditDataSet().clearSelectionHistory();
        }
    }

    public PurgeCommand getPurgeCommand(Collection<OsmPrimitive> sel) {
        this.layer = this.getLayerManager().getEditLayer();
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        PurgeCommand cmd = PurgeCommand.build(sel, this.toPurgeAdditionally);
        this.modified = cmd.getParticipatingPrimitives().stream().anyMatch(AbstractPrimitive::isModified);
        return cmd;
    }

    private JPanel buildPanel(boolean modified) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.", new Object[0]) + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:", new Object[0]) + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            this.toPurgeAdditionally.sort((o1, o2) -> {
                int type = o2.getType().compareTo(o1.getType());
                if (type != 0) {
                    return type;
                }
                return Long.compare(o1.getUniqueId(), o2.getUniqueId());
            });
            JList<OsmPrimitive> list = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[this.toPurgeAdditionally.size()]));
            list.setCellRenderer(new SelectionForcedOsmPrimitivRenderer());
            JScrollPane scroll = new JScrollPane(list);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setMinimumSize(new Dimension(250, 300));
            pnl.add((Component)scroll, GBC.std().fill(1).weight(1.0, 1.0));
            JButton addToSelection = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            addToSelection.setMargin(new Insets(0, 0, 0, 0));
            pnl.add((Component)addToSelection, GBC.eol().anchor(16).weight(0.0, 1.0).insets(2, 0, 0, 3));
        }
        if (modified) {
            pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            pnl.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>", new Object[0]), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer", new Object[0]));
        this.cbClearUndoRedo.setSelected(Config.getPref().getBoolean("purge.clear_undo_redo", false));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)this.cbClearUndoRedo, GBC.eol());
        return pnl;
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    static class SelectionForcedOsmPrimitivRenderer
    extends OsmPrimitivRenderer {
        SelectionForcedOsmPrimitivRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends OsmPrimitive> list, OsmPrimitive value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value, index, true, false);
        }
    }
}

