/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class DownloadSelectedIncompleteMembersAction
extends AbstractRelationAction {
    private transient Collection<OsmPrimitive> incompleteMembers;

    public DownloadSelectedIncompleteMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
        this.putValue("Name", I18n.tr("Download incomplete members", new Object[0]));
    }

    public static Set<OsmPrimitive> buildSetOfIncompleteMembers(Collection<Relation> rels) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (Relation r : rels) {
            ret.addAll(SubclassFilteredCollection.filter(r.getIncompleteMembers(), osm -> !osm.isNew()));
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(this.relations, this.incompleteMembers, MainApplication.getLayerManager().getEditLayer()));
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> primitives) {
        this.relations = SubclassFilteredCollection.filter(DownloadSelectedIncompleteMembersAction.getRelations(primitives), Relation::hasIncompleteMembers);
        this.incompleteMembers = DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(this.relations);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty() && !this.incompleteMembers.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }
}

