/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bugreport;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class JosmUpdatePanel
extends JPanel {
    private final JMultilineLabel testedVersionField;
    private final int josmVersion = Version.getInstance().getVersion();

    public JosmUpdatePanel() {
        super(new GridBagLayout());
        this.add((Component)new JMultilineLabel(I18n.tr("Your current version of JOSM is {0}", Integer.toString(this.josmVersion))), GBC.eol().fill(2));
        this.testedVersionField = new JMultilineLabel(I18n.tr("JOSM is searching for updates...", new Object[0]));
        this.add((Component)this.testedVersionField, GBC.eol().fill(2));
        this.checkCurrentVersion();
    }

    private void checkCurrentVersion() {
        new Thread(this::readCurrentVersion, "JOSM version checker").start();
    }

    private void readCurrentVersion() {
        int testedVersion = JosmUpdatePanel.getTestedVersion();
        if (testedVersion < 0) {
            SwingUtilities.invokeLater(this::displayError);
        } else if (this.josmVersion < testedVersion) {
            SwingUtilities.invokeLater(() -> this.displayOutOfDate(testedVersion));
        } else {
            SwingUtilities.invokeLater(this::displayUpToDate);
        }
    }

    private static int getTestedVersion() {
        try {
            CachedFile testedVersion = new CachedFile(Main.getJOSMWebsite() + "/tested");
            testedVersion.setMaxAge(900L);
            String testedString = new String(testedVersion.getByteContent(), StandardCharsets.ISO_8859_1);
            return Integer.parseInt(testedString.trim());
        }
        catch (IOException | NumberFormatException e) {
            Logging.log(Logging.LEVEL_WARN, "Unable to detect current tested version of JOSM:", e);
            return -1;
        }
    }

    private void displayError() {
        this.testedVersionField.setText(I18n.tr("An error occured while checking if your JOSM instance is up to date.", new Object[0]));
        this.showUpdateButton();
    }

    private void displayUpToDate() {
        this.testedVersionField.setText(I18n.tr("JOSM is up to date.", new Object[0]));
    }

    private void displayOutOfDate(int testedVersion) {
        this.testedVersionField.setText(I18n.tr("JOSM is out of date. The current version is {0}. Try updating JOSM.", Integer.toString(testedVersion)));
        this.showUpdateButton();
    }

    private void showUpdateButton() {
        this.add((Component)new JMultilineLabel(I18n.tr("Before you file a bug report make sure you have updated to the latest version of JOSM here:", new Object[0])), GBC.eol());
        this.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eop().insets(8, 0, 0, 0));
        JButton updateButton = new JButton(I18n.tr("Update JOSM", new Object[0]), ImageProvider.get("download"));
        updateButton.addActionListener(e -> JosmUpdatePanel.openJosmUpdateSite());
        this.add((Component)updateButton, GBC.eol().anchor(13));
    }

    private static void openJosmUpdateSite() {
        try {
            Main.platform.openUrl(Main.getJOSMWebsite());
        }
        catch (IOException ex) {
            Logging.log(Logging.LEVEL_WARN, "Unable to access JOSM website:", ex);
        }
    }
}

