/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveSelectedAction
extends AddFromSelectionAction {
    public RemoveSelectedAction(MemberTableModel memberTableModel, SelectionTableModel selectionTableModel, OsmDataLayer layer) {
        super(null, memberTableModel, null, selectionTableModel, null, layer, null);
        this.putValue("ShortDescription", I18n.tr("Remove all members referring to one of the selected objects", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "deletemembers"));
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.layer.data;
        if (ds == null || ds.selectionEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.memberTableModel.hasMembersReferringTo(ds.getSelected()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.memberTableModel.removeMembersReferringTo(this.selectionTableModel.getSelection());
    }
}

